# 画面設計書 28-メニューテンプレート

## 概要

MenuTemplateFormは、メニューテンプレートを選択するためのダイアログ画面です。定義済みのメニュー構成をツリービューで表示し、ユーザーがテンプレートを選択してメニュー項目を追加できます。

### 本画面の処理概要

本画面は、カスタムメニュー設定時に既存のメニュー構成をテンプレートとして選択するためのダイアログを提供します。

**業務上の目的・背景**：StaxRipはカスタムメニュー機能を提供しており、ユーザーが独自のメニュー構成を作成できます。新しいメニュー項目を追加する際に、既存のメニュー構成をテンプレートとしてコピーすることで、効率的なメニューカスタマイズが可能になります。

**画面へのアクセス方法**：カスタムメニューエディタ（CustomMenuEditor）から、テンプレート選択時に呼び出されます。メニューのカスタマイズ機能の一部として使用されます。

**主要な操作・処理内容**：
1. TreeViewによるメニュー構造の階層表示
2. メニュー項目の選択
3. OKボタンで選択を確定（ルート以外が選択されている場合のみ有効）
4. Cancelボタンで選択をキャンセル
5. F1キーでヘルプ表示

**画面遷移**：
- 遷移元：CustomMenuEditor（カスタムメニューエディタ）
- 遷移先：HelpForm（ヘルプ表示）

**権限による表示制御**：特になし（全ユーザー共通）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | メニューテンプレート選択 | 主機能 | 定義済みメニュー構成の選択 |

## 画面種別

選択ダイアログ（モーダル）

## URL/ルーティング

Windows Formsアプリケーションのため、URL/ルーティングは該当なし。`MenuTemplateForm`クラス（StaxRip.UI名前空間）として実装。

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 説明 |
|--------|--------|------|----------|------|------|
| メニューアイテム | item | CustomMenuItem | 入力（コンストラクタ） | Yes | 表示するメニュー構造のルート |
| 選択ノード | TreeNode | TreeNode | 出力（プロパティ） | - | 選択されたTreeNode |
| ダイアログ結果 | DialogResult | DialogResult | 出力 | Yes | OKまたはCancel |

## 表示項目

| 表示項目 | 表示形式 | 説明 |
|----------|----------|------|
| タイトルバー | テキスト | "Default Menu - {アプリケーション詳細}" |
| ツリービュー | TreeView | メニュー構造の階層表示（Panel内にDock） |
| OKボタン | Button | 右下に配置、選択を確定 |
| Cancelボタン | Button | 右下に配置、選択をキャンセル |

## イベント仕様

### 1-初期化（コンストラクタ）

メニュー構造をTreeViewに展開し、テーマを適用します。

**処理フロー**：
1. InitializeComponentでUI初期化
2. PopulateTreeViewでCustomMenuItemをTreeViewに変換
3. tv.ExpandAll()ですべてのノードを展開
4. ApplyTheme()でテーマ適用
5. ThemeManager.CurrentThemeChangedイベントをハンドリング

### 2-ツリービュー選択変更（AfterSelect）

ノード選択時にOKボタンの有効/無効を制御します。

**処理フロー**：
1. tv.SelectedNodeを確認
2. TreeNodeプロパティに選択ノードを設定
3. bnOK.Enabled = Not TreeNode.Parent Is Nothing（ルート以外のみOK可能）

### 3-OKボタン押下

OKボタンをクリックすると、選択を確定してダイアログを閉じます。

**処理フロー**：
1. DialogResult = DialogResult.OK
2. フォームが閉じられる
3. 呼び出し元でTreeNodeプロパティから選択結果を取得

### 4-Cancelボタン押下

Cancelボタンをクリックすると、選択をキャンセルしてダイアログを閉じます。

**処理フロー**：
1. DialogResult = DialogResult.Cancel
2. フォームが閉じられる

### 5-ヘルプリクエスト（F1キー）

F1キー押下時にヘルプを表示します。

**処理フロー**：
1. HelpFormを生成
2. "The new item will be a clone of the selected item."というメッセージを表示
3. form.Show()でヘルプを表示

### 6-テーマ変更

ThemeManagerの変更イベントに応答してテーマを適用します。

**処理フロー**：
1. BackColorをテーマの背景色に更新

## データベース更新仕様

本画面はデータベースを使用しません。選択結果はTreeNodeプロパティで返されます。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| ヘルプ | The new item will be a clone of the selected item. | F1キー押下時 |

## 例外処理

本画面に特定の例外処理はありません。

## 備考

- DialogBaseを継承しており、ダイアログの基本機能が利用可能
- UI名前空間に定義されており、カスタムメニュー機能の一部
- TreeViewExは拡張されたTreeViewコントロール
- ルートノードはOKボタンが無効になり、選択できない設計
- 選択されたノードのTagにはCustomMenuItemが設定されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

CustomMenuItemとTreeNodeの関係を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MenuTemplateForm.vb | `Source/UI/MenuTemplateForm.vb` | TreeNodeプロパティ（99行目）で選択ノードを保持 |
| 1-2 | Menu.vb | `Source/UI/Menu.vb` | CustomMenuItemクラスの構造を確認 |

**読解のコツ**: CustomMenuItemはSubItemsプロパティで子メニューを持つ階層構造です。

#### Step 2: エントリーポイントを理解する

コンストラクタでのツリー構築を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MenuTemplateForm.vb | `Source/UI/MenuTemplateForm.vb` | コンストラクタ（101-108行目）でツリー構築 |

**主要処理フロー**:
1. **102行目**: InitializeComponent()でUI初期化
2. **103行目**: PopulateTreeViewでメニュー→ツリー変換
3. **104行目**: tv.ExpandAll()で全ノード展開
4. **106行目**: ApplyTheme()でテーマ適用

#### Step 3: ツリー構築処理を理解する

再帰的なツリー構築ロジックを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MenuTemplateForm.vb | `Source/UI/MenuTemplateForm.vb` | PopulateTreeView（131-144行目）で再帰処理 |

**主要処理フロー**:
- **132行目**: item.Textでノードを作成
- **133行目**: item自体をTagに設定
- **135-138行目**: ルートならtv.Nodes.Add、子ならnode.Nodes.Add
- **140-142行目**: SubItemsを再帰的に処理

#### Step 4: 選択制御を理解する

ノード選択時のOKボタン制御を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | MenuTemplateForm.vb | `Source/UI/MenuTemplateForm.vb` | tv_AfterSelect（146-151行目）で選択処理 |

**主要処理フロー**:
- **147-148行目**: SelectedNodeを確認してTreeNodeプロパティに設定
- **149行目**: bnOK.Enabled = Not TreeNode.Parent Is Nothing でルート選択禁止

### プログラム呼び出し階層図

```
CustomMenuEditor
    │
    └─ MenuTemplateForm.New(item)
           │
           ├─ InitializeComponent() - UI初期化
           │      ├─ tv (TreeViewEx)
           │      ├─ pnTreeView (PanelEx)
           │      ├─ bnOK (ButtonEx)
           │      └─ bnCancel (ButtonEx)
           │
           ├─ PopulateTreeView(item, Nothing) - 再帰的ツリー構築
           │      │
           │      └─ [再帰] PopulateTreeView(subItem, newNode)
           │
           ├─ tv.ExpandAll() - 全展開
           │
           ├─ ApplyTheme() - テーマ適用
           │
           └─ ShowDialog()
                  │
                  ├─ tv_AfterSelect
                  │     ├─ TreeNode = tv.SelectedNode
                  │     └─ bnOK.Enabled = Not Parent Is Nothing
                  │
                  ├─ bnOK_Click → DialogResult.OK
                  │
                  └─ MenuTemplateForm_HelpRequested → HelpForm
```

### データフロー図

```
[入力]                    [処理]                      [出力]

CustomMenuItem ───────▶ PopulateTreeView ──────────▶ TreeView表示
   │                         │
   │                         ▼
   │                    newNode.Tag = item
   │
   └─ SubItems ───────▶ [再帰処理] ─────────────────▶ 子ノード
                              │
                              ▼
                       AfterSelect ──────────────▶ TreeNode
                              │                   (選択結果)
                              ▼
                       DialogResult ─────────────▶ OK/Cancel
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MenuTemplateForm.vb | `Source/UI/MenuTemplateForm.vb` | ソース | 本画面のロジック |
| DialogBase.vb | `Source/UI/DialogBase.vb` | ソース | ダイアログ基底クラス |
| Menu.vb | `Source/UI/Menu.vb` | ソース | CustomMenuItemクラス定義 |
| CustomMenuEditor.vb | `Source/UI/CustomMenuEditor.vb` | ソース | 呼び出し元 |
| TreeViewEx.vb | `Source/UI/TreeViewEx.vb` | ソース | 拡張TreeView |
| HelpForm.vb | `Source/Forms/HelpForm.vb` | ソース | ヘルプ表示 |
| ThemeManager.vb | `Source/UI/ThemeManager.vb` | ソース | テーマ管理 |
