# 画面設計書 29-タスクダイアログ

## 概要

TaskDialogBaseFormは、Windows Vista以降のタスクダイアログ風UIを提供する基底フォームです。コマンドリンク形式のダイアログを実装し、情報表示、選択肢の提示、ユーザー入力の取得など、様々なダイアログシナリオに対応できる汎用的なダイアログ基盤を提供します。

### 本画面の処理概要

本画面は、Windowsタスクダイアログのような高機能なダイアログUIを提供する基底クラスで、派生クラスTaskDialog(Of T)と組み合わせて使用されます。

**業務上の目的・背景**：通常のMessageBoxでは表現できない複雑なダイアログ（複数の選択肢、詳細表示の展開/折りたたみ、コマンドリンクボタン、アイコン表示等）が必要な場面で使用されます。ユーザーに対してより多くの情報を提示しながら選択を促すことができ、情報の階層化（タイトル、本文、詳細）により、必要に応じて詳細情報を表示できます。

**画面へのアクセス方法**：直接アクセスされることはなく、TaskDialog(Of T)クラスを通じて使用されます。アプリケーション全体で様々なダイアログ表示に使用されます。

**主要な操作・処理内容**：
1. タイトルと本文の表示
2. アイコン表示（Warning、Error、Info、Shield、Question）
3. コマンドボタンによる選択肢の提示
4. 標準ボタン（OK、Cancel、Yes、No等）の表示
5. 詳細情報の展開/折りたたみ（Show Details / Hide Details）
6. テキスト入力フィールド
7. チェックボックス
8. メニューボタン
9. メッセージのクリップボードコピー
10. タイムアウト機能付きボタン

**画面遷移**：
- 遷移元：アプリケーション全体から
- 遷移先：なし（モーダルダイアログ）

**権限による表示制御**：特になし（全ユーザー共通）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | タスクダイアログ表示 | 主機能 | 高機能ダイアログUIの提供 |

## 画面種別

汎用ダイアログ基底クラス（モーダル）

## URL/ルーティング

Windows Formsアプリケーションのため、URL/ルーティングは該当なし。`TaskDialogBaseForm`クラスとして実装。

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 説明 |
|--------|--------|------|----------|------|------|
| タイトル | Title | String | 入力 | No | ダイアログタイトル |
| 本文 | Content | String | 入力 | No | メイン本文 |
| 詳細内容 | ExpandedContent | String | 入力 | No | 展開時に表示する詳細 |
| アイコン | Icon | TaskIcon | 入力 | No | 表示アイコン種別 |
| コマンド定義 | CommandDefinitions | List | 入力 | No | コマンドボタン定義 |
| ボタン定義 | ButtonDefinitions | List | 入力 | No | 標準ボタン定義 |
| タイムアウト | Timeout | Integer | 入力 | No | 自動クローズまでの秒数 |
| 選択値 | SelectedValue | T | 出力 | - | 選択された値 |
| 選択テキスト | SelectedText | String | 出力 | - | 選択されたテキスト |
| 入力テキスト | InputTextEdit.Text | String | 入出力 | No | テキスト入力値 |
| チェック状態 | CheckBox.Checked | Boolean | 入出力 | No | チェックボックス状態 |

## 表示項目

| 表示項目 | 表示形式 | 説明 |
|----------|----------|------|
| タイトルラベル | LabelEx | 太字のダイアログタイトル |
| アイコン | PictureBox | 左側に表示されるアイコン |
| メインパネル | TaskDialogPanel | コマンドボタンとラベルを含むスクロール可能エリア |
| 入力フィールド | TextEdit | テキスト入力（表示/非表示可） |
| メニューボタン | MenuButton | ドロップダウンメニュー（表示/非表示可） |
| チェックボックス | CheckBoxEx | 確認チェック（表示/非表示可） |
| ボタン領域 | FlowLayoutPanel | 標準ボタン（OK、Cancel等） |
| 詳細ボタン | ButtonLabel | Show Details / Hide Details |
| コピーボタン | ButtonLabel | Copy Message |

## イベント仕様

### 1-初期化（コンストラクタ）

基本UIを初期化し、テーマを適用します。

**処理フロー**：
1. InitializeComponentでUI初期化
2. ApplyTheme()でテーマ適用
3. InputTextEdit.TextBox.KeyDownイベントをハンドリング
4. ThemeManager.CurrentThemeChangedイベントをハンドリング

### 2-詳細表示切り替え（blDetails_Click）

詳細情報の表示/非表示を切り替えます。

**処理フロー**：
1. paMain.ScrollControlIntoViewで先頭にスクロール
2. blDetails.Textが"Show Details"なら"Hide Details"に変更
3. そうでなければWidthをリセットして"Show Details"に変更
4. paMain.PerformLayoutでレイアウト更新
5. AdjustSize()を2回呼び出してサイズ調整

### 3-コマンドボタンクリック（CommandClick）

コマンドボタンをクリックした際の処理です。

**処理フロー**：
1. senderからCommandButtonを取得
2. TagからCommandDefinitionを取得
3. SelectedTextとSelectedValueを設定
4. ダイアログをClose()

### 4-ボタンクリック（ButtonClick）

標準ボタンをクリックした際の処理です。

**処理フロー**：
1. senderからButtonExを取得
2. SelectedTextとSelectedValueを設定
3. ダイアログをClose()

### 5-テキスト入力でのEnterキー（InputTextEditTextBoxKeyDown）

テキストフィールドでEnterキー押下時、AcceptButtonを実行します。

**処理フロー**：
1. Keys.Enterを検知
2. AcceptButton?.PerformClick()を実行

### 6-テーマ変更

ThemeManagerの変更イベントに応答してテーマを適用します。

**処理フロー**：
1. BackColor/ForeColorをテーマ色に更新
2. blCopyMessage/blDetailsのBackColorを更新

## データベース更新仕様

本画面はデータベースを使用しません。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 情報 | Message was copied to clipboard. | Copy Message実行時 |
| UI | Show Details / Hide Details | 詳細切り替えボタン |
| UI | Copy Message | コピーボタン |

## 例外処理

- **タイムアウト処理**：タイムアウト中の例外はTry-Catchで捕捉され、クラッシュを防止
- **InvokeRequired**：スレッドセーフなUI更新のためInvokeを使用

## 備考

- FormBaseを継承しており、フォームの基本機能が利用可能
- TaskDialog(Of T)ジェネリッククラスと組み合わせて使用
- CommandButtonはカスタム描画のボタンで、タイトルと説明を表示
- TaskDialogPanelはカスタムレイアウトを行う内部Panel
- AdjustSize()オーバーライドでダイアログサイズを動的に調整
- SetWindowLongPtrでオーナーウィンドウを設定（32bit/64bit対応）
- TaskIcon列挙型でアイコン種類を指定
- TaskButton列挙型でボタンの組み合わせを指定（フラグ形式）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

TaskDialogの主要なプロパティとクラス構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | TaskDialog.vb | `Source/UI/TaskDialog.vb` | TaskDialog(Of T)クラスの定義（8-578行目）、ジェネリック型でSelectedValueを返す |
| 1-2 | TaskDialog.vb | `Source/UI/TaskDialog.vb` | CommandDefinition/ButtonDefinition（566-577行目）で選択肢を定義 |
| 1-3 | TaskDialog.vb | `Source/UI/TaskDialog.vb` | TaskIcon/TaskButton列挙型（580-601行目） |

**読解のコツ**: ジェネリック型Tでダイアログの戻り値型を指定します。DialogResultやStringなど様々な型で使用可能です。

#### Step 2: 基底フォームを理解する

TaskDialogBaseFormの構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TaskDialogBaseForm.vb | `Source/UI/TaskDialogBaseForm.vb` | コンストラクタ（10-16行目）でテーマ適用とイベントハンドリング |
| 2-2 | TaskDialogBaseForm.vb | `Source/UI/TaskDialogBaseForm.vb` | ApplyTheme（32-43行目）でテーマ色設定 |
| 2-3 | TaskDialogBaseForm.vb | `Source/UI/TaskDialogBaseForm.vb` | blDetails_Click（273-286行目）で詳細表示切り替え |

**主要処理フロー**:
1. **12行目**: InitializeComponent()でUI初期化
2. **13行目**: ApplyTheme()でテーマ適用
3. **14行目**: InputTextEdit.TextBox.KeyDownでEnter処理

#### Step 3: 内部コンポーネントを理解する

TaskDialogPanelとCommandButtonの実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TaskDialogBaseForm.vb | `Source/UI/TaskDialogBaseForm.vb` | TaskDialogPanel（61-116行目）でカスタムレイアウト |
| 3-2 | TaskDialogBaseForm.vb | `Source/UI/TaskDialogBaseForm.vb` | CommandButton（118-271行目）でタイトル+説明ボタン |

**主要処理フロー**:
- **67-114行目**: OnLayoutでコントロールを動的配置
- **170-201行目**: AdjustSizeでボタンサイズを計算
- **241-263行目**: OnPaintでカスタム描画（タイトル+説明）

#### Step 4: ダイアログ初期化を理解する

TaskDialog.Initでの初期化処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | TaskDialog.vb | `Source/UI/TaskDialog.vb` | Init（43-271行目）でダイアログ全体を初期化 |

**主要処理フロー**:
- **77-96行目**: アイコン設定（TaskIconに応じてStockIcon使用）
- **103-150行目**: コマンドボタンを生成してpaMainに追加
- **152-178行目**: 標準ボタンを生成してflpButtonsに追加
- **183-232行目**: タイムアウト機能（別スレッドでカウントダウン）

### プログラム呼び出し階層図

```
呼び出し元
    │
    └─ TaskDialog(Of T).New()
           │
           ├─ TaskDialogBaseForm.New()
           │      ├─ InitializeComponent() - UI初期化
           │      ├─ ApplyTheme() - テーマ適用
           │      └─ イベントハンドラ設定
           │
           ├─ AddCommand() / AddButton() - 選択肢追加
           │
           └─ Show() ──▶ Init()
                  │       ├─ アイコン設定
                  │       ├─ コマンドボタン生成
                  │       ├─ 標準ボタン生成
                  │       └─ タイムアウト設定
                  │
                  └─ ShowDialog()
                         │
                         ├─ CommandClick ──▶ SelectedValue設定
                         │                   Close()
                         │
                         ├─ ButtonClick ──▶ SelectedValue設定
                         │                  Close()
                         │
                         ├─ blDetails_Click ──▶ 詳細表示切替
                         │
                         └─ OnResize / AdjustSize ──▶ サイズ調整
```

### データフロー図

```
[入力]                      [処理]                        [出力]

Title ────────────────▶ TitleLabel ──────────────▶ 表示
Content ──────────────▶ ContentLabel ────────────▶ 表示
ExpandedContent ──────▶ ExpandedContentLabel ───▶ 表示（展開時）
Icon ─────────────────▶ pbIcon.Image ────────────▶ 表示

CommandDefinitions ───▶ CommandButton ───────────▶ クリック
                              │
                              ▼
                       SelectedValue ────────────▶ 戻り値
                       SelectedText

ButtonDefinitions ────▶ ButtonEx ────────────────▶ クリック
                              │
                              ▼
                       SelectedValue ────────────▶ 戻り値
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TaskDialogBaseForm.vb | `Source/UI/TaskDialogBaseForm.vb` | ソース | 基底フォームロジック |
| TaskDialogBaseForm.Designer.vb | `Source/UI/TaskDialogBaseForm.Designer.vb` | ソース | UI定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | ジェネリックダイアログクラス |
| FormBase.vb | `Source/UI/FormBase.vb` | ソース | フォーム基底クラス |
| StockIcon.vb | `Source/UI/StockIcon.vb` | ソース | システムアイコン取得 |
| FontManager.vb | `Source/UI/FontManager.vb` | ソース | フォント管理 |
| ThemeManager.vb | `Source/UI/ThemeManager.vb` | ソース | テーマ管理 |
| ButtonEx.vb | `Source/UI/ButtonEx.vb` | ソース | 拡張ボタン |
| ButtonLabel.vb | `Source/UI/ButtonLabel.vb` | ソース | リンクスタイルラベルボタン |
| StackPanel.vb | `Source/UI/StackPanel.vb` | ソース | スタックパネルレイアウト |
