# 画面設計書: ProcessingForm（処理画面）

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 3 |
| 画面名 | ProcessingForm |
| 画面名（日本語） | 処理画面 |
| ソースファイル | `Source/Forms/ProcessingForm.vb` |
| 継承元クラス | FormBase |
| 画面種別 | モーダレスダイアログ |

## 2. 画面概要

エンコード処理中の進捗表示と制御を行う画面。処理ログの表示、プロセスの中断・スキップ・一時停止、プロセス優先度の変更、完了後のシャットダウン設定などの機能を提供する。タスクバープログレス表示やシステムトレイ最小化にも対応。

## 3. 画面レイアウト

### 3.1 レイアウト構成

```
+------------------------------------------------------------------+
| flpNav（ナビゲーションパネル）                                     |
+------------------------------------------------------------------+
|                                                                    |
| pnLogHost（ログ表示パネル）                                        |
|                                                                    |
|                      [処理ログ表示領域]                            |
|                                                                    |
|                                                                    |
+------------------------------------------------------------------+
| pnStatusHost（ステータスパネル）                                   |
+------------------------------------------------------------------+
| flpButtons（ボタンパネル）                                         |
| [When finished:] [Shutdown▼] [Abort(ESC)] [Jobs(F6)] [Log(F8)] [≡] |
+------------------------------------------------------------------+
```

### 3.2 主要コントロール一覧

| コントロール名 | 種類 | 説明 |
|--------------|------|------|
| tlpMain | TableLayoutPanel | メインレイアウト |
| flpNav | FlowLayoutPanel | ナビゲーションパネル |
| pnLogHost | PanelEx | ログ表示ホストパネル |
| pnStatusHost | PanelEx | ステータス表示ホストパネル |
| flpButtons | FlowLayoutPanel | ボタン配置パネル |
| laWhenfinisheddo | LabelEx | 「When finished do:」ラベル |
| mbShutdown | MenuButton | シャットダウン設定メニュー |
| bnAbort | ButtonEx | 中断ボタン（ESC） |
| bnJobs | ButtonEx | ジョブ管理ボタン（F6） |
| bnLog | ButtonEx | ログ表示ボタン（F8） |
| bnMenu | ButtonEx | メニューボタン |
| NotifyIcon | NotifyIcon | システムトレイアイコン |

## 4. 機能仕様

### 4.1 画面機能一覧

| 機能ID | 機能名 | 説明 |
|--------|--------|------|
| F001 | 処理ログ表示 | エンコード処理のログをリアルタイム表示 |
| F002 | 処理中断 | 全ジョブ処理を中断 |
| F003 | 処理スキップ | 現在のジョブをスキップして次へ |
| F004 | プロセス一時停止 | 現在のプロセスを一時停止 |
| F005 | プロセス再開 | 一時停止したプロセスを再開 |
| F006 | プロセス優先度変更 | 処理プロセスの優先度を変更 |
| F007 | シャットダウン設定 | 処理完了後のシャットダウンモード設定 |
| F008 | 現在ジョブ後停止 | 現在のジョブ完了後に処理を停止 |
| F009 | 出力ハイライト | ログ出力のハイライト表示切替 |
| F010 | 進捗ハイライト | 進捗表示のハイライト設定 |
| F011 | 進捗再フォーマット | 進捗表示の再フォーマット切替 |
| F012 | テーマ変更 | 一時的なテーマ変更 |
| F013 | ジョブ管理画面表示 | JobsFormを表示 |
| F014 | ログファイル表示 | ログファイルを外部で表示 |
| F015 | システムトレイ最小化 | 最小化時にシステムトレイへ格納 |
| F016 | タスクバープログレス | タスクバーに進捗を表示 |

### 4.2 イベント処理

| イベント | 処理内容 |
|---------|---------|
| bnAbort_Click | Abort()を呼び出し、確認後に全処理を中断 |
| bnJobs_Click | JobsForm.ShowForm()を呼び出し |
| bnLog_Click | g.DefaultCommands.ShowLogFile()を呼び出し |
| bnMenu_Click | コンテキストメニューを表示 |
| mbShutdown_ValueChangedUser | シャットダウンモードをレジストリに保存 |
| NotifyIcon_MouseClick | フォームを復元表示 |
| OnResize | 最小化時にトレイへ格納（設定による） |
| WndProc | SC_CLOSEをAbortにリダイレクト、タスクバーボタン作成 |

### 4.3 キーボードショートカット

| キー | 機能 |
|------|------|
| Escape | 処理中断（Abort） |
| F6 | ジョブ管理画面表示 |
| F8 | ログファイル表示 |
| F1 | ヘルプ表示 |
| Ctrl+O | 出力ハイライト切替 |
| Ctrl+P | 進捗再フォーマット切替 |

### 4.4 コンテキストメニュー構成

| メニュー項目 | 機能 |
|-------------|------|
| Suspend | プロセス一時停止 |
| Resume | プロセス再開 |
| Priority > | プロセス優先度選択（Realtime/High/Above Normal/Normal/Below Normal/Idle） |
| Abort | 全処理中断 |
| Skip | 現在のジョブをスキップ |
| Stop After Current Job | 現在ジョブ後に停止 |
| Output Highlighting | 出力ハイライト切替 |
| Progress Reformatting | 進捗再フォーマット切替 |
| Progress Highlighting > | 進捗ハイライト色選択 |
| Temporary Theme > | テーマ選択 |
| Jobs | ジョブ管理画面 |
| Log | ログファイル表示 |
| Help | ヘルプ表示 |

### 4.5 シャットダウンモード

mbShutdownで選択可能なモード（ShutdownMode列挙型）：
- Nothing（何もしない）
- Close（アプリケーションを閉じる）
- Standby（スタンバイ）
- Hibernate（休止状態）
- Shutdown（シャットダウン）
- など

## 5. データバインディング

### 5.1 関連データ

| データ項目 | バインド先 | 説明 |
|-----------|-----------|------|
| g.IsJobProcessing | 各コントロールのEnabled | ジョブ処理中フラグ |
| g.StopAfterCurrentJob | StopAfterCurrentJobMenuItem.Checked | 現在ジョブ後停止フラグ |
| s.OutputHighlighting | OutputHighlightingMenuItem.Checked | 出力ハイライト設定 |
| s.ProgressHighlighting | 進捗ハイライト設定 | 進捗ハイライト有効フラグ |
| s.ProgressHighlightingColorName | 進捗ハイライト色 | ハイライト色名 |
| s.ProgressReformatting | ProgressReformattingMenuItem.Checked | 進捗再フォーマット設定 |
| Registry ShutdownMode | mbShutdown.Value | シャットダウンモード |

## 6. 画面遷移

### 6.1 遷移元

| 遷移元 | トリガー |
|--------|---------|
| MainForm | エンコード処理開始 |
| JobsForm | ジョブ実行開始 |

### 6.2 遷移先

| 遷移先 | トリガー | 条件 |
|--------|---------|------|
| JobsForm | bnJobs クリック / F6 | - |
| HelpForm | F1 / ヘルプメニュー | - |
| MainForm | 処理完了/中断後 | - |

## 7. 内部クラス・メソッド

### 7.1 主要プロパティ

| プロパティ | 型 | 説明 |
|-----------|-----|------|
| Taskbar | Taskbar | タスクバープログレス表示用 |
| WasHandleCreated | Boolean | ハンドル作成済みフラグ（共有） |

### 7.2 主要メソッド

| メソッド | 説明 |
|---------|------|
| Abort() | 処理中断（確認ダイアログあり） |
| Skip() | 現在ジョブのスキップ（確認ダイアログあり） |
| StopAfterCurrentJob() | 現在ジョブ後停止の切替 |
| SetOutputHighlighting() | 出力ハイライトの切替 |
| SetProgressHighlighting() | 進捗ハイライトの設定 |
| SetProgressReformatting() | 進捗再フォーマットの切替 |
| ShowForm() | フォーム表示・アクティブ化 |
| HideForm() | フォーム非表示 |
| UpdateControls() | コントロール状態の更新 |
| ApplyTheme() | テーマの適用 |

## 8. バリデーション

| 項目 | ルール | エラーメッセージ |
|------|--------|----------------|
| 処理中断 | 確認ダイアログ | Abort processing? |
| スキップ | 確認ダイアログ | Skip current process? |

## 9. 非機能要件

### 9.1 パフォーマンス

- ログ表示: リアルタイム更新
- タスクバープログレス: リアルタイム更新

### 9.2 UI/UX

- DPIスケーリング対応（AutoScaleMode.Dpi）
- テーマ切り替え対応（ThemeManager）
- システムトレイ最小化対応
- タスクバープログレス表示
- ウィンドウ閉じるボタン = 中断（SC_CLOSEリダイレクト）

### 9.3 プロセス制御

- ProcController経由でのプロセス制御
- プロセス優先度変更（Realtime〜Idle）
- プロセス一時停止/再開

## 10. コードリーディングガイド

### 10.1 関連ファイル一覧

| ファイル | 役割 |
|---------|------|
| `Source/Forms/ProcessingForm.vb` | 処理フォーム実装（行1-452） |
| `Source/UI/FormBase.vb` | 基底フォームクラス |
| `Source/ProcController.vb` | プロセス制御クラス |
| `Source/Taskbar.vb` | タスクバープログレス |
| `Source/Log.vb` | ログ管理 |
| `Source/Settings.vb` | 設定（s.OutputHighlighting等） |
| `Source/GlobalVariables.vb` | グローバル変数（g.IsJobProcessing等） |

### 10.2 プログラム呼び出し階層図

```
ProcessingForm (FormBase)
├── New() [行211-258]
│   ├── InitializeComponent() [行25-187]
│   ├── mbShutdown設定
│   ├── CMS（コンテキストメニュー）構築
│   └── ApplyTheme()
├── WndProc() [行280-293]
│   ├── SC_CLOSE → Abort
│   └── TaskbarButtonCreated → Taskbar作成
├── 処理制御
│   ├── Abort() [行360-366]
│   │   └── ProcController.Abort()
│   ├── Skip() [行368-374]
│   │   └── ProcController.Skip()
│   └── StopAfterCurrentJob() [行335-337]
├── UI更新
│   ├── UpdateControls() [行388-395]
│   └── ApplyTheme() [行270-278]
├── イベントハンドラ
│   ├── bnAbort_Click [行405-407]
│   ├── bnJobs_Click [行409-411]
│   ├── bnLog_Click [行413-415]
│   └── bnMenu_Click [行417-440]
└── フォーム表示制御
    ├── ShowForm() [行376-380]
    └── HideForm() [行382-386]
```

### 10.3 データフロー図

```
[エンコード処理開始]
       │
       ▼
[ProcessingForm表示]
       │
       ├──► [pnLogHost] ◄── ProcController.Output
       │
       ├──► [pnStatusHost] ◄── 進捗情報
       │
       └──► [Taskbar] ◄── 進捗パーセント

[ユーザー操作]
       │
       ├──► [Abort] ──► ProcController.Abort() ──► 処理終了
       │
       ├──► [Skip] ──► ProcController.Skip() ──► 次ジョブ
       │
       └──► [Suspend/Resume] ──► ProcController.Suspend/Resume
```

### 10.4 読み解きの推奨順序

1. **データ構造の理解**: `ProcController`クラスの役割
2. **エントリーポイント**: コンストラクタ `New()` [行211]
3. **UI構築**: `InitializeComponent()` [行25] とCMSメニュー構築
4. **処理制御**: `Abort()`, `Skip()`, `StopAfterCurrentJob()`
5. **WndProc**: ウィンドウメッセージ処理 [行280]
6. **状態管理**: `UpdateControls()` [行388]
