# 画面設計書: JobsForm（ジョブ管理画面）

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 4 |
| 画面名 | JobsForm |
| 画面名（日本語） | ジョブ管理画面 |
| ソースファイル | `Source/Forms/JobsForm.vb` |
| 継承元クラス | DialogBase |
| 画面種別 | モーダルダイアログ |

## 2. 画面概要

エンコードジョブの管理画面。ジョブの一覧表示、実行順序の変更、ジョブの追加・削除・編集、バッチ実行などの機能を提供する。FileSystemWatcherによりジョブファイルの変更を監視し、自動的に一覧を更新する。

## 3. 画面レイアウト

### 3.1 レイアウト構成

```
+------------------------------------------------------------------+
| lv（ジョブリストビュー）                                           |
|                                                                    |
|                    [ジョブ一覧表示]                                |
|                    - チェックボックス付き                          |
|                    - 複数選択対応                                  |
|                                                                    |
+------------------------------------------------------------------+
| tlpButtonsLeft              | tlpButtonsRight                     |
| [Start]           [Up]      | [Down] [Menu] [Remove] [Load]       |
+------------------------------------------------------------------+
```

### 3.2 主要コントロール一覧

| コントロール名 | 種類 | 説明 |
|--------------|------|------|
| tlpMain | TableLayoutPanel | メインレイアウト |
| lv | ListViewEx | ジョブリスト（チェックボックス付き） |
| tlpButtonsLeft | TableLayoutPanel | 左側ボタン配置 |
| tlpButtonsRight | TableLayoutPanel | 右側ボタン配置 |
| bnStart | ButtonEx | ジョブ開始ボタン |
| bnUp | ButtonEx | 上へ移動ボタン |
| bnDown | ButtonEx | 下へ移動ボタン |
| bnMenu | ButtonEx | メニューボタン |
| bnRemove | ButtonEx | 削除ボタン |
| bnLoad | ButtonEx | 読み込みボタン |

## 4. 機能仕様

### 4.1 画面機能一覧

| 機能ID | 機能名 | 説明 |
|--------|--------|------|
| F001 | ジョブ一覧表示 | 登録済みジョブの一覧表示 |
| F002 | ジョブ開始 | 選択/有効なジョブの実行開始 |
| F003 | ジョブ削除 | 選択したジョブの削除 |
| F004 | ジョブ読み込み | 選択したジョブをメインフォームに読み込み |
| F005 | 順序変更（上へ） | 選択ジョブを上に移動 |
| F006 | 順序変更（下へ） | 選択ジョブを下に移動 |
| F007 | 先頭/末尾へ移動 | 選択ジョブを先頭/末尾に移動 |
| F008 | 全選択/選択解除 | 全ジョブの選択/選択解除 |
| F009 | チェック/チェック解除 | ジョブの有効/無効切替 |
| F010 | アルファベット順ソート | ジョブをソート |
| F011 | 自動リロード | ジョブファイル変更時の自動更新 |

### 4.2 イベント処理

| イベント | 処理内容 |
|---------|---------|
| bnStart_Click | g.ProcessJobs()を呼び出しジョブ処理開始 |
| bnLoad_Click | 選択ジョブをメインフォームに読み込み |
| lv.ItemsChanged | SaveJobs()を呼び出しジョブを保存 |
| lv.ItemRemoved | バッチプロジェクトの場合ファイル削除 |
| FileWatcher.Changed/Created | ジョブ一覧を再読み込み |
| OnActivated | コントロール状態更新、ProcController連携 |

### 4.3 キーボードショートカット

| キー | 機能 |
|------|------|
| Ctrl+S | 全選択 |
| Shift+S | 選択解除 |
| Space | 選択チェック/チェック解除 |
| Shift+C | 選択をチェック |
| Ctrl+C | 全チェック |
| Shift+U | 選択のチェック解除 |
| Ctrl+U | 全チェック解除 |
| Ctrl+Up | 上へ移動 |
| Ctrl+Down | 下へ移動 |
| Ctrl+Home | 先頭へ移動 |
| Ctrl+End | 末尾へ移動 |
| Ctrl+Shift+S | アルファベット順ソート |
| Delete | 選択削除 |
| Ctrl+L | 読み込み |

### 4.4 コンテキストメニュー構成

| メニュー項目 | 機能 |
|-------------|------|
| Select All | 全ジョブを選択 |
| Select None | 選択解除 |
| Check Selection | 選択ジョブをチェック |
| Check All | 全ジョブをチェック |
| Uncheck Selection | 選択ジョブのチェック解除 |
| Uncheck All | 全チェック解除 |
| Move Selection Up | 上へ移動 |
| Move Selection Down | 下へ移動 |
| Move Selection To Top | 先頭へ移動 |
| Move Selection To Bottom | 末尾へ移動 |
| Sort Alphabetically | アルファベット順ソート |
| Remove Selection | 選択削除 |
| Load Selection | 選択読み込み |

## 5. データバインディング

### 5.1 関連データ

| データ項目 | バインド先 | 説明 |
|-----------|-----------|------|
| JobManager.GetJobs() | lv.Items | ジョブ一覧 |
| Job.Active | lv.CheckBox | ジョブ有効フラグ |
| Job.Path | lv.Item.Tag | ジョブファイルパス |

## 6. 画面遷移

### 6.1 遷移元

| 遷移元 | トリガー |
|--------|---------|
| MainForm | ジョブ管理メニュー |
| ProcessingForm | bnJobsボタン/F6 |

### 6.2 遷移先

| 遷移先 | トリガー | 条件 |
|--------|---------|------|
| MainForm | bnLoadクリック | 選択ジョブあり |
| ProcessingForm | bnStartクリック | 有効ジョブあり |

## 7. 内部クラス・メソッド

### 7.1 主要プロパティ

| プロパティ | 型 | 説明 |
|-----------|-----|------|
| FileWatcher | FileSystemWatcher | ジョブファイル監視 |
| IsLoading | Boolean | 読み込み中フラグ |
| BlockSave | Boolean | 保存ブロックフラグ |

### 7.2 主要メソッド

| メソッド | 説明 |
|---------|------|
| Reload() | ジョブ一覧の再読み込み |
| SaveJobs() | ジョブ一覧の保存 |
| UpdateControls() | コントロール状態の更新 |
| SelectAll()/SelectNone() | 全選択/選択解除 |
| CheckAll()/UncheckAll() | 全チェック/全解除 |
| CheckSelection()/UncheckSelection() | 選択チェック/解除 |
| ShowForm() | ダイアログ表示（静的） |

## 8. バリデーション

| 項目 | ルール | エラーメッセージ |
|------|--------|----------------|
| ジョブ開始 | g.VerifyRequirements | 要件未充足時は処理中断 |

## 9. 非機能要件

### 9.1 パフォーマンス

- FileSystemWatcherによるリアルタイム更新

### 9.2 UI/UX

- DPIスケーリング対応
- テーマ切り替え対応
- リストボックスモードによる操作性向上

## 10. コードリーディングガイド

### 10.1 関連ファイル一覧

| ファイル | 役割 |
|---------|------|
| `Source/Forms/JobsForm.vb` | ジョブフォーム実装（行1-451） |
| `Source/JobManager.vb` | ジョブ管理クラス |
| `Source/Job.vb` | ジョブクラス |
| `Source/UI/ListViewEx.vb` | 拡張リストビュー |

### 10.2 プログラム呼び出し階層図

```
JobsForm (DialogBase)
├── New() [行190-254]
│   ├── InitializeComponent() [行24-181]
│   ├── lv設定（ボタン連携、チェックボックス）
│   └── CMS（コンテキストメニュー）構築
├── OnLoad() [行431-444]
│   └── FileWatcher設定・起動
├── ジョブ操作
│   ├── bnStart_Click [行389-404]
│   │   └── g.ProcessJobs()
│   ├── bnLoad_Click [行406-412]
│   │   └── g.MainForm.LoadProject()
│   └── SaveJobs() [行371-387]
│       └── JobManager.SaveJobs()
├── 選択/チェック操作
│   ├── SelectAll()/SelectNone()
│   └── CheckAll()/UncheckAll()
└── Reload() [行351-362]
    └── JobManager.GetJobs()
```

### 10.3 データフロー図

```
[Jobs.dat ファイル]
       │
       ▼
[FileSystemWatcher] ──► [Reload()] ──► [lv更新]
       │
       ▼
[JobManager.GetJobs()]
       │
       ▼
[ListViewEx表示]
       │
       ├──► [bnStart] ──► g.ProcessJobs() ──► ProcessingForm
       │
       └──► [bnLoad] ──► g.MainForm.LoadProject() ──► MainForm
```

### 10.4 読み解きの推奨順序

1. **データ構造の理解**: `Job`クラス、`JobManager`クラス
2. **エントリーポイント**: コンストラクタ `New()` [行190]
3. **UI構築**: `InitializeComponent()` [行24]とCMSメニュー構築
4. **ジョブ読み込み**: `OnLoad()` [行431]とFileWatcher設定
5. **ジョブ操作**: `bnStart_Click`, `bnLoad_Click`
6. **自動更新**: `Reload()` [行351]
