# 画面設計書: CropForm（クロップ画面）

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 5 |
| 画面名 | CropForm |
| 画面名（日本語） | クロップ画面 |
| ソースファイル | `Source/Forms/CropForm.vb` |
| 継承元クラス | DialogBase |
| 画面種別 | モーダレスダイアログ |

## 2. 画面概要

動画のクロップ（トリミング）設定を行う画面。上下左右の境界をマウスやキーボードで調整し、不要な黒帯を除去できる。自動クロップ検出、スマートクロップ（アスペクト比維持）機能も提供。リアルタイムでクロップ結果をプレビュー表示する。

## 3. 画面レイアウト

### 3.1 レイアウト構成

```
+------------------------------------------------------------------+
| pnTopActive（上辺境界表示）                                        |
+------------------------------------------------------------------+
| pnLeftActive |        pnVideo         | pnRightActive            |
| （左辺境界）  |   [動画プレビュー]     | （右辺境界）              |
|              |                        |                          |
|              |   [クロップ範囲表示]   |                          |
+------------------------------------------------------------------+
| pnBottomActive（下辺境界表示）                                     |
+------------------------------------------------------------------+
| tbPosition（フレーム位置トラックバー）                             |
+------------------------------------------------------------------+
| StatusStrip [laStatus: フレーム/時間/サイズ情報] [tsbMenu: Menu]   |
+------------------------------------------------------------------+
```

### 3.2 主要コントロール一覧

| コントロール名 | 種類 | 説明 |
|--------------|------|------|
| pnVideo | PanelEx | 動画プレビューパネル |
| pnLeftActive | PanelEx | 左辺境界パネル |
| pnTopActive | PanelEx | 上辺境界パネル |
| pnRightActive | PanelEx | 右辺境界パネル |
| pnBottomActive | PanelEx | 下辺境界パネル |
| tbPosition | TrackBar | フレーム位置スライダー |
| StatusStrip | StatusStrip | ステータスバー |
| laStatus | ToolStripStatusLabel | ステータス情報表示 |
| tsbMenu | ToolStripDropDownButton | メニューボタン |

## 4. 機能仕様

### 4.1 画面機能一覧

| 機能ID | 機能名 | 説明 |
|--------|--------|------|
| F001 | クロッププレビュー | リアルタイムでクロップ結果を表示 |
| F002 | マウスクロップ | マウスドラッグでクロップ値を調整 |
| F003 | キーボードクロップ | キーでクロップ値を増減 |
| F004 | マウスホイールクロップ | ホイールでクロップ値を調整 |
| F005 | 辺選択 | アクティブなクロップ辺を選択 |
| F006 | 自動クロップ | 黒帯を自動検出してクロップ値設定 |
| F007 | スマートクロップ | アスペクト比を維持したクロップ |
| F008 | クロップリセット | クロップ値をゼロにリセット |
| F009 | フレームナビゲーション | フレーム位置の移動 |
| F010 | クロップ色変更 | クロップ表示色の変更 |
| F011 | クロップオプション | オプション設定ダイアログ表示 |

### 4.2 イベント処理

| イベント | 処理内容 |
|---------|---------|
| pnVideo.MouseMove | マウス位置から辺選択またはクロップ調整 |
| pnVideo.MouseDown | アクティブ辺決定、クロップ開始 |
| tbPosition.Scroll | フレーム位置変更 |
| OnMouseWheel | アクティブ辺のクロップ値調整 |
| OnSizeChanged | レンダラー再描画 |

### 4.3 キーボードショートカット

| キー | 機能 |
|------|------|
| N | クロップリセット（0,0,0,0） |
| A | 自動クロップ |
| S | スマートクロップ |
| +/- | アクティブ辺を2ピクセル増減 |
| Shift++/- | アクティブ辺を8ピクセル増減 |
| Ctrl++/- | アクティブ辺と反対辺を2ピクセル増減 |
| Ctrl+Shift++/- | アクティブ辺と反対辺を8ピクセル増減 |
| F | フレーム指定ダイアログ |
| T | 時間指定ダイアログ |
| Ctrl+Left | 先頭へジャンプ |
| Ctrl+Right | 末尾へジャンプ |
| PageUp | 100フレーム後退 |
| PageDown | 100フレーム前進 |
| Ctrl+PageUp | 1000フレーム後退 |
| Ctrl+PageDown | 1000フレーム前進 |
| O | クロップオプション |
| M | メニュー編集 |
| F1 | ヘルプ |
| Escape | 閉じる |

### 4.4 コンテキストメニュー構成

| メニュー項目 | 機能 |
|-------------|------|
| No Crop | クロップリセット |
| Auto Crop | 自動クロップ |
| Smart Crop | スマートクロップ |
| Increase/Decrease Active Side | アクティブ辺の増減 |
| Increase/Decrease Active And Opposite Side | 両辺の増減 |
| Navigation > | ナビゲーション機能 |
| Crop Color > | クロップ色選択 |
| Crop Options... | オプション設定 |
| Edit Menu... | メニュー編集 |
| Help... | ヘルプ |
| Exit | 終了 |

## 5. データバインディング

### 5.1 関連データ

| データ項目 | バインド先 | 説明 |
|-----------|-----------|------|
| p.CropLeft | Renderer.CropLeft | 左クロップ値 |
| p.CropTop | Renderer.CropTop | 上クロップ値 |
| p.CropRight | Renderer.CropRight | 右クロップ値 |
| p.CropBottom | Renderer.CropBottom | 下クロップ値 |
| s.LastPosition | Renderer.Position | 最後のフレーム位置 |
| s.CropColor | Renderer.CropColor | クロップ表示色 |

## 6. 画面遷移

### 6.1 遷移元

| 遷移元 | トリガー |
|--------|---------|
| MainForm | クロップ設定リンク/メニュー |

### 6.2 遷移先

| 遷移先 | トリガー | 条件 |
|--------|---------|------|
| HelpForm | F1キー/ヘルプメニュー | - |
| OptionsDialog | Oキー/オプションメニュー | - |

## 7. 内部クラス・メソッド

### 7.1 主要プロパティ

| プロパティ | 型 | 説明 |
|-----------|-----|------|
| FrameServer | IFrameServer | フレームサーバー |
| Renderer | VideoRenderer | 動画レンダラー |
| Side | AnchorStyles | 現在のアクティブ辺 |
| ActiveCropSide | AnchorStyles | マウスドラッグ中の辺 |
| BorderColor | ColorHSL | 境界色 |
| BorderSelectedColor | ColorHSL | 選択境界色 |

### 7.2 主要メソッド

| メソッド | 説明 |
|---------|------|
| SetPos() | フレーム位置設定 |
| UpdateAll() | クロップ値適用・表示更新 |
| CropActiveSideInternal() | アクティブ辺のクロップ調整 |
| MouseCrop() | マウスによるクロップ |
| SelectBorder() | アクティブ辺の選択 |
| RunAutoCrop() | 自動クロップ実行 |
| RunSmartCrop() | スマートクロップ実行 |
| SetCropValues() | クロップ値の直接設定 |
| FixMod() | MOD2補正 |

## 8. バリデーション

| 項目 | ルール | エラーメッセージ |
|------|--------|----------------|
| クロップ値 | 最大80%まで | （自動補正） |
| MOD値 | AutoCorrectCropValues有効時MOD2 | （自動補正） |
| スクリプトエラー | 閉じる前にエラーチェック | Script Error: [内容] |

## 9. 非機能要件

### 9.1 パフォーマンス

- リアルタイムプレビュー更新

### 9.2 UI/UX

- DPIスケーリング対応
- テーマ切り替え対応
- マウスホイールによる直感的操作
- 境界色でアクティブ辺を視覚的に識別

## 10. コードリーディングガイド

### 10.1 関連ファイル一覧

| ファイル | 役割 |
|---------|------|
| `Source/Forms/CropForm.vb` | クロップフォーム実装（行1-747） |
| `Source/VideoRenderer.vb` | 動画レンダラー |
| `Source/FrameServer.vb` | フレームサーバー |
| `Source/Project.vb` | プロジェクト（p.CropLeft等） |
| `Source/Calc.vb` | 計算ユーティリティ |

### 10.2 プログラム呼び出し階層図

```
CropForm (DialogBase)
├── New() [行153-211]
│   ├── InitializeComponent() [行22-137]
│   ├── CustomMenu構築
│   └── 境界パネル配置
├── OnLoad() [行241-300]
│   ├── ウィンドウサイズ計算
│   ├── スクリプト作成
│   ├── FrameServer/Renderer作成
│   └── UpdateAll()
├── クロップ処理
│   ├── CropActiveSideInternal() [行349-378]
│   ├── MouseCrop() [行406-427]
│   └── SetCropValues() [行598-611]
├── 描画・更新
│   ├── UpdateAll() [行467-515]
│   └── SelectBorder() [行433-448]
├── 自動クロップ
│   ├── RunAutoCrop() [行637-653]
│   │   └── g.RunAutoCrop()
│   └── RunSmartCrop() [行655-659]
│       └── g.SmartCrop()
└── OnFormClosing() [行304-328]
    └── クリーンアップ
```

### 10.3 データフロー図

```
[ユーザー操作（マウス/キー/ホイール）]
              │
              ▼
[CropActiveSideInternal() / MouseCrop()]
              │
              ▼
[p.CropLeft/Top/Right/Bottom 更新]
              │
              ▼
[UpdateAll()]
              │
              ├──► [Renderer.CropXxx 更新]
              │
              ├──► [Renderer.Draw()]
              │
              └──► [laStatus 更新]
                     - Frame / Time / Size / X / Y / Mod / Error / DAR
```

### 10.4 読み解きの推奨順序

1. **データ構造の理解**: `p.CropLeft/Top/Right/Bottom`の役割
2. **エントリーポイント**: コンストラクタ `New()` [行153]
3. **初期化処理**: `OnLoad()` [行241]
4. **クロップ処理**: `CropActiveSideInternal()` [行349]
5. **更新処理**: `UpdateAll()` [行467]
6. **マウス操作**: `pVideo_MouseMove`, `pVideo_MouseDown`
7. **自動機能**: `RunAutoCrop()`, `RunSmartCrop()`
