# 画面設計書: AudioForm（オーディオ画面）

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 6 |
| 画面名 | AudioForm |
| 画面名（日本語） | オーディオ画面 |
| ソースファイル | `Source/Forms/AudioForm.vb` |
| 継承元クラス | DialogBase |
| 画面種別 | モーダルダイアログ |

## 2. 画面概要

オーディオトラックの詳細設定を行うダイアログ。コーデック、エンコーダー、デコーダー、ビットレート、品質、チャンネル数、サンプリングレート、言語、ゲイン、ディレイなど、音声エンコードに必要な設定項目を提供する。また、正規化やトラックフラグの設定も可能。

## 3. 画面レイアウト

### 3.1 レイアウト構成

```
+------------------------------------------------------------------+
| gbBasic（基本設定）                                                |
| +--------------------------------------------------------------+ |
| | Codec:      [mbCodec▼]     | Bitrate:   [numBitrate]        | |
| | Decoder:    [mbDecoder▼]   | Quality:   [numQuality]        | |
| | Encoder:    [mbEncoder▼]   | Gain:      [numGain]           | |
| | Channels:   [mbChannels▼]  | Delay:     [numDelay]          | |
| | Sample Rate:[mbSamplingRate▼]                                | |
| | Language:   [mbLanguage▼]                                    | |
| | Profile Name: [tbProfileName___________________]             | |
| | Track Name:   [tbStreamName____________________]             | |
| | Custom:       [tbCustom________________________]             | |
| | [x] Normalize                                                | |
| | [x] Center/Speech optimized Stereo                          | |
| | [x] Default Track                                           | |
| | [x] Forced Track                                            | |
| | [x] Commentary Track                                        | |
| +--------------------------------------------------------------+ |
+------------------------------------------------------------------+
| gbAdvanced（詳細設定）                                             |
| [SimpleUI - エンコーダー固有設定]                                  |
+------------------------------------------------------------------+
| rtbCommandLine（コマンドライン表示）                               |
+------------------------------------------------------------------+
| [OK]  [Cancel]  [Menu]  [Advanced]                                |
+------------------------------------------------------------------+
```

### 3.2 主要コントロール一覧

| コントロール名 | 種類 | 説明 |
|--------------|------|------|
| gbBasic | GroupBoxEx | 基本設定グループ |
| tlpBasic | TableLayoutPanel | 基本設定レイアウト |
| mbCodec | MenuButton | コーデック選択 |
| mbDecoder | MenuButton | デコーダー選択 |
| mbEncoder | MenuButton | エンコーダー選択 |
| mbChannels | MenuButton | チャンネル数選択 |
| mbSamplingRate | MenuButton | サンプリングレート選択 |
| mbLanguage | MenuButton | 言語選択 |
| numBitrate | NumEdit | ビットレート入力 |
| numQuality | NumEdit | 品質入力 |
| numGain | NumEdit | ゲイン入力 |
| numDelay | NumEdit | ディレイ入力 |
| tbProfileName | TextEdit | プロファイル名 |
| tbStreamName | TextEdit | トラック名 |
| tbCustom | TextEdit | カスタム設定 |
| cbNormalize | CheckBoxEx | 正規化フラグ |
| cbCenterOptimizedStereo | CheckBoxEx | センター最適化ステレオ |
| cbDefaultTrack | CheckBoxEx | デフォルトトラック |
| cbForcedTrack | CheckBoxEx | 強制トラック |
| cbCommentaryTrack | CheckBoxEx | コメンタリートラック |
| gbAdvanced | GroupBoxEx | 詳細設定グループ |
| SimpleUI | SimpleUI | エンコーダー固有設定UI |
| rtbCommandLine | CommandLineRichTextBox | コマンドライン表示 |
| bnOK | ButtonEx | OKボタン |
| bnCancel | ButtonEx | キャンセルボタン |
| bnMenu | ButtonEx | メニューボタン |
| bnAdvanced | ButtonEx | 詳細表示切替ボタン |

## 4. 機能仕様

### 4.1 画面機能一覧

| 機能ID | 機能名 | 説明 |
|--------|--------|------|
| F001 | コーデック選択 | 出力オーディオコーデックの選択 |
| F002 | デコーダー選択 | 入力オーディオのデコーダー選択 |
| F003 | エンコーダー選択 | 使用するエンコーダーの選択 |
| F004 | チャンネル設定 | 出力チャンネル数の設定 |
| F005 | サンプリングレート設定 | 出力サンプリングレートの設定 |
| F006 | 言語設定 | オーディオトラックの言語設定 |
| F007 | ビットレート設定 | 出力ビットレートの設定 |
| F008 | 品質設定 | VBR品質値の設定 |
| F009 | ゲイン設定 | 音量ゲインの設定 |
| F010 | ディレイ設定 | 音声遅延の設定 |
| F011 | プロファイル名設定 | プロファイル名の編集 |
| F012 | トラック名設定 | 出力トラック名の設定 |
| F013 | カスタム設定 | カスタムパラメータの入力 |
| F014 | 正規化設定 | 音声正規化の有効/無効 |
| F015 | トラックフラグ設定 | Default/Forced/Commentaryフラグ |
| F016 | 詳細設定表示 | エンコーダー固有の詳細設定 |
| F017 | コマンドライン表示 | 生成されるコマンドラインの表示 |

### 4.2 イベント処理

| イベント | 処理内容 |
|---------|---------|
| mbCodec.ValueChanged | コーデック変更時のUI更新 |
| mbEncoder.ValueChanged | エンコーダー変更時のSimpleUI更新 |
| numBitrate.ValueChanged | ビットレート変更時のコマンドライン更新 |
| bnOK.Click | 設定を保存してダイアログを閉じる |
| bnCancel.Click | 設定を破棄してダイアログを閉じる |
| bnAdvanced.Click | 詳細設定パネルの表示/非表示切替 |

## 5. データバインディング

### 5.1 関連データ

| データ項目 | バインド先 | 説明 |
|-----------|-----------|------|
| AudioProfile.Codec | mbCodec | コーデック |
| AudioProfile.Decoder | mbDecoder | デコーダー |
| AudioProfile.Encoder | mbEncoder | エンコーダー |
| AudioProfile.Channels | mbChannels | チャンネル数 |
| AudioProfile.SamplingRate | mbSamplingRate | サンプリングレート |
| AudioProfile.Language | mbLanguage | 言語 |
| AudioProfile.Bitrate | numBitrate | ビットレート |
| AudioProfile.Quality | numQuality | 品質 |
| AudioProfile.Gain | numGain | ゲイン |
| AudioProfile.Delay | numDelay | ディレイ |
| AudioProfile.Name | tbProfileName | プロファイル名 |
| AudioProfile.StreamName | tbStreamName | トラック名 |
| AudioProfile.Normalize | cbNormalize | 正規化 |
| AudioProfile.Default | cbDefaultTrack | デフォルト |
| AudioProfile.Forced | cbForcedTrack | 強制 |
| AudioProfile.Commentary | cbCommentaryTrack | コメンタリー |

## 6. 画面遷移

### 6.1 遷移元

| 遷移元 | トリガー |
|--------|---------|
| MainForm | オーディオ設定リンクのクリック |

### 6.2 遷移先

| 遷移先 | トリガー | 条件 |
|--------|---------|------|
| (なし - モーダル) | bnOK/bnCancel | - |

## 7. バリデーション

| 項目 | ルール | エラーメッセージ |
|------|--------|----------------|
| ビットレート | 正の整数 | （入力制限） |
| 品質 | 有効範囲内 | （入力制限） |
| プロファイル名 | 空でないこと | （必要に応じて） |

## 8. 非機能要件

### 8.1 UI/UX

- DPIスケーリング対応
- テーマ切り替え対応
- コマンドラインリアルタイム表示

## 9. コードリーディングガイド

### 9.1 関連ファイル一覧

| ファイル | 役割 |
|---------|------|
| `Source/Forms/AudioForm.vb` | オーディオフォーム実装 |
| `Source/Audio/AudioProfile.vb` | オーディオプロファイルクラス |
| `Source/UI/SimpleUI.vb` | 動的UI生成 |

### 9.2 プログラム呼び出し階層図

```
AudioForm (DialogBase)
├── New()
│   ├── InitializeComponent()
│   └── コントロール初期化
├── コーデック/エンコーダー選択
│   └── SimpleUI更新
├── 値変更イベント
│   └── コマンドライン更新
└── OK/Cancel処理
    └── 設定保存/破棄
```
