# 画面設計書: AppsForm（アプリケーション設定画面）

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 7 |
| 画面名 | AppsForm |
| 画面名（日本語） | アプリケーション設定画面 |
| ソースファイル | `Source/Forms/AppsForm.vb` |
| 継承元クラス | SizeSavingDialogBase |
| 画面種別 | モーダレスダイアログ |
| インターフェース | IUpdateUI |

## 2. 画面概要

外部ツール（エンコーダー、デコーダー、フィルター等）の管理画面。ツールのインストール状況確認、パス設定、バージョン管理、自動更新機能を提供。TreeView形式でツールをカテゴリ別に表示し、選択したツールの詳細情報をFlowLayoutPanelに動的に表示する。ドラッグ＆ドロップによるツール更新にも対応。

## 3. 画面レイアウト

### 3.1 レイアウト構成

```
+------------------------------------------------------------------+
| tlpMain (TableLayoutPanel - 2列)                                   |
| +------------------------+---------------------------------------+ |
| | SearchTextBox          | ToolStrip                             | |
| | [検索ボックス]         | [Launch][Explore][Web][Download]      | |
| |                        | [Version][Tools▼][Help]               | |
| +------------------------+---------------------------------------+ |
| | tv (TreeViewEx)        | flpOuter (FlowLayoutPanel)            | |
| | ├─ Apps                | +-----------------------------------+ | |
| | │  ├─ ffmpeg           | | flp (詳細表示パネル)              | | |
| | │  ├─ x264             | | [Title: ツール名]                 | | |
| | │  └─ ...              | | [Status: OK/Missing/Wrong Ver]    | | |
| | ├─ AviSynth            | | [Install ボタン]                  | | |
| | │  ├─ plugin1          | | [Location: パス]                  | | |
| | │  └─ ...              | | [Version: バージョン情報]         | | |
| | └─ VapourSynth         | | [Filters: フィルター一覧]         | | |
| |    ├─ plugin1          | | [Description: 説明]               | | |
| |    └─ ...              | | [Website: URL]                    | | |
| |                        | | [Help: URL]                       | | |
| |                        | | [Download: URL]                   | | |
| |                        | +-----------------------------------+ | |
| +------------------------+---------------------------------------+ |
+------------------------------------------------------------------+
```

### 3.2 主要コントロール一覧

| コントロール名 | 種類 | 説明 |
|--------------|------|------|
| tlpMain | TableLayoutPanel | メインレイアウト（2列3行） |
| tv | TreeViewEx | ツール一覧TreeView |
| SearchTextBox | SearchTextBox | ツール検索ボックス |
| ToolStrip | ToolStrip | ツールバー |
| tsbLaunch | ToolStripButton | 起動ボタン |
| tsbExplore | ToolStripButton | エクスプローラーで開く |
| tsbWebsite | ToolStripButton | Webサイト表示 |
| tsbDownload | ToolStripButton | ダウンロードページ表示 |
| tsbVersion | ToolStripButton | バージョン編集 |
| ddbTools | ToolStripDropDownButton | ツールメニュー |
| tsbHelp | ToolStripButton | ヘルプ表示 |
| flpOuter | FlowLayoutPanel | 詳細表示外枠 |
| flp | FlowLayoutPanel | 詳細情報表示パネル |
| SetupButton | ButtonEx | インストールボタン |

## 4. 機能仕様

### 4.1 画面機能一覧

| 機能ID | 機能名 | 説明 |
|--------|--------|------|
| F001 | ツール一覧表示 | カテゴリ別にツールをTreeViewで表示 |
| F002 | ツール検索 | 名前・説明・バージョン等で検索 |
| F003 | ツール詳細表示 | 選択したツールの詳細情報表示 |
| F004 | ツール起動 | 選択したツールを起動 |
| F005 | フォルダを開く | ツールのフォルダをExplorerで表示 |
| F006 | Webサイト表示 | ツールのWebサイトを開く |
| F007 | ダウンロード | ダウンロードページを開く |
| F008 | バージョン編集 | ツールのバージョン情報を編集 |
| F009 | パス編集 | カスタムパスを設定 |
| F010 | パス検索 | Everything検索でパスを検索 |
| F011 | パスクリア | カスタムパスをクリア |
| F012 | 自動更新 | ツールの自動更新 |
| F013 | ステータスチェック | 全ツールの状態確認 |
| F014 | グリッド表示 | ツール一覧をグリッド形式で表示 |
| F015 | ドラッグ＆ドロップ更新 | ファイルのD&Dでツール更新 |
| F016 | PATH環境変数管理 | PATH変数へのパス追加/削除 |

### 4.2 イベント処理

| イベント | 処理内容 |
|---------|---------|
| tv.AfterSelect | 選択ツールの詳細表示 |
| SearchTextBox.TextChanged | ツールリストのフィルタリング |
| tsbLaunch.Click | ツール起動 |
| tsbExplore.Click | フォルダを開く |
| tsbWebsite.Click | Webサイト表示 |
| tsbDownload.Click | ダウンロードページ表示 |
| tsbVersion.Click | バージョン編集ダイアログ |
| tsbHelp.Click | ヘルプ表示 |
| OnDragDrop | ファイルのドロップでツール更新 |

### 4.3 キーボードショートカット

| キー | 機能 |
|------|------|
| Ctrl+L | ツール起動 |
| Ctrl+E | フォルダを開く |
| Ctrl+W | Webサイト表示 |
| Ctrl+D | ダウンロードページ表示 |
| F12 | バージョン編集 |
| Ctrl+P | パス編集 |
| Ctrl+F | パス検索（Everything） |
| Ctrl+X | パスクリア |
| Ctrl+G | グリッド表示 |
| Ctrl+S | 全ツールステータスチェック |
| Ctrl+Y | 必須ツールのみチェック |
| Ctrl+U | 自動更新 |
| Ctrl+R | 更新リクエスト |
| F10 | 変更履歴編集（開発者のみ） |
| F1 | ヘルプ |

### 4.4 Toolsドロップダウンメニュー構成

| メニュー項目 | 機能 |
|-------------|------|
| Edit Path... | パスをダイアログで編集 |
| Find Path... | Everythingでパス検索 |
| Clear Paths... | カスタムパスをクリア |
| Copy Path | パスをクリップボードにコピー |
| PATH Env Var... | PATH環境変数管理 |
| --- | セパレータ |
| Edit Version | バージョン編集 |
| Edit Changelog | 変更履歴編集 |
| Show Grid | グリッド形式で表示 |
| Check All | 全ツールステータスチェック |
| Check Required Only | 必須ツールのみチェック |
| Auto Update | 自動更新実行 |
| Update Request | 更新リクエストページ |
| Download | ダウンロードページ |
| Website | Webサイト |
| Explore | フォルダを開く |
| Launch | ツール起動 |
| Help | ヘルプ表示 |

## 5. データバインディング

### 5.1 関連データ

| データ項目 | バインド先 | 説明 |
|-----------|-----------|------|
| Package.Items | tv.Nodes | ツールパッケージ一覧 |
| CurrentPackage.Name | Headers("Title") | ツール名 |
| CurrentPackage.GetStatusDisplay() | Contents("Status") | ステータス表示 |
| CurrentPackage.Path | Contents("Location") | パス |
| CurrentPackage.Version | Contents("Version") | バージョン |
| CurrentPackage.Description | Contents("Description") | 説明 |
| CurrentPackage.WebURL | Contents("Website") | Webサイト |
| CurrentPackage.HelpURL | Contents("Help") | ヘルプURL |
| CurrentPackage.DownloadURL | Contents("Download") | ダウンロードURL |
| PluginPackage.AvsFilterNames | Contents("AviSynth Filters") | AVSフィルター名 |
| PluginPackage.VsFilterNames | Contents("VapourSynth Filters") | VSフィルター名 |

## 6. 画面遷移

### 6.1 遷移元

| 遷移元 | トリガー |
|--------|---------|
| MainForm | ツール→Apps メニュー |

### 6.2 遷移先

| 遷移先 | トリガー | 条件 |
|--------|---------|------|
| ブラウザ（外部） | Webサイト/ダウンロード/ヘルプ | - |
| エクスプローラー（外部） | Explore | - |
| 外部ツール（起動） | Launch | LaunchAction定義あり |
| HelpForm | F1キー | - |

## 7. 内部クラス・メソッド

### 7.1 主要プロパティ

| プロパティ | 型 | 説明 |
|-----------|-----|------|
| CurrentPackage | Package | 現在選択中のパッケージ |
| Nodes | List(Of TreeNode) | TreeNodeリスト |
| Headers | Dictionary(Of String, LabelEx) | ヘッダーラベル辞書 |
| Contents | Dictionary(Of String, LabelEx) | コンテンツラベル辞書 |
| SetupButton | ButtonEx | インストールボタン |
| ToolUpdate | ToolUpdate | ツール更新オブジェクト |

### 7.2 主要メソッド

| メソッド | 説明 |
|---------|------|
| ShowActivePackage() | 選択パッケージの詳細表示 |
| ShowPackage(Package) | 指定パッケージを選択・表示 |
| ShowPackage(TreeNode) | TreeNode選択時の表示 |
| AddSection() | 詳細パネルにセクション追加 |
| SearchTextBox_TextChanged() | 検索フィルタリング処理 |
| Everything() | Everythingによるパス検索 |
| UpdateUI() | UI更新（IUpdateUI実装） |
| ApplyTheme() | テーマ適用 |

## 8. バリデーション

| 項目 | ルール | エラーメッセージ |
|------|--------|----------------|
| カスタムパス | 起動フォルダ内は禁止 | Custom paths within the startup folder are not permitted |
| バージョン | セミコロン禁止 | （自動置換） |
| ファイル存在 | パスが存在すること | Not found |

## 9. 非機能要件

### 9.1 パフォーマンス

- 非同期AviSynthパス検索（AviSynthToolPathAsync）
- 検索ボックス入力時のリアルタイムフィルタリング

### 9.2 UI/UX

- DPIスケーリング対応
- テーマ切り替え対応（ThemeManager連携）
- ドラッグ＆ドロップによるツール更新
- 検索ボックスでの上下キーナビゲーション
- TreeViewでの文字キー入力で検索ボックスにフォーカス

### 9.3 外部連携

- voidtools Everything連携（パス検索）
- PowerShell連携（グリッド表示）
- 環境変数PATH管理

## 10. コードリーディングガイド

### 10.1 関連ファイル一覧

| ファイル | 役割 |
|---------|------|
| `Source/Forms/AppsForm.vb` | アプリケーション設定フォーム実装（行1-1199） |
| `Source/Package.vb` | パッケージ基底クラス |
| `Source/PluginPackage.vb` | プラグインパッケージクラス |
| `Source/ToolUpdate.vb` | ツール更新処理 |
| `Source/UI/TreeViewEx.vb` | 拡張TreeView |
| `Source/UI/SearchTextBox.vb` | 検索テキストボックス |

### 10.2 プログラム呼び出し階層図

```
AppsForm (SizeSavingDialogBase, IUpdateUI)
├── New() [行419-472]
│   ├── InitializeComponent() [行48-408]
│   ├── RestoreClientSize()
│   ├── SearchTextBox_TextChanged() [行750-805]
│   ├── AddSection() [行631-659] × 9回
│   │   └── Headers/Contentsに追加
│   └── ApplyTheme() [行484-494]
├── OnShown() [行686-689]
│   └── AviSynthToolPathAsync() [行691-694]
│       └── FrameServerHelp.AviSynthToolPath()
├── tv.AfterSelect [行740-748]
│   └── ShowPackage(TreeNode) [行675-684]
│       └── ShowActivePackage() [行515-628]
├── SearchTextBox_TextChanged() [行750-805]
│   ├── Package.Items.Values フィルタリング
│   ├── tv.AddNode()
│   └── ツリー更新
├── ToolStripボタンクリック
│   ├── tsbLaunch_Click [行807-809]
│   ├── tsbOpenDir_Click [行812-814]
│   ├── tsbHelp_Click [行816-818]
│   ├── tsbWebsite_Click [行820-822]
│   ├── tsbDownload_Click [行824-828]
│   └── tsbVersion_Click [行830-859]
├── Toolsメニュー処理
│   ├── miBrowsePath_Click [行940-965]
│   ├── miFindPath_Click [行988-990]
│   │   └── Everything() [行992-1061]
│   ├── miClearCustomPath_Click [行967-986]
│   ├── miStatus_Click [行900-918]
│   ├── miStatusRequired_Click [行920-938]
│   ├── miAutoUpdate_Click [行1098-1114]
│   └── miShowGridView_Click [行861-898]
├── ドラッグ＆ドロップ
│   ├── OnDragEnter() [行702-710]
│   └── OnDragDrop() [行712-738]
│       └── ToolUpdate.Extract()
└── Dispose() [行474-478]
    └── テーマイベント解除
```

### 10.3 データフロー図

```
[Package.Items.Values（全ツール一覧）]
              │
              ▼
[SearchTextBox_TextChanged()]──► [フィルタリング]
              │
              ▼
[tv.Nodes（TreeView表示）]
              │
              ▼
[tv.AfterSelect]
              │
              ▼
[CurrentPackage = 選択パッケージ]
              │
              ▼
[ShowActivePackage()]
              │
              ├──► Headers/Contents更新
              │
              ├──► SetupButton表示制御
              │
              └──► ToolStrip有効/無効制御
```

### 10.4 読み解きの推奨順序

1. **データ構造の理解**: `Package`, `PluginPackage`の関係
2. **エントリーポイント**: コンストラクタ `New()` [行419]
3. **初期化処理**: `AddSection()`によるUI構築 [行631]
4. **検索処理**: `SearchTextBox_TextChanged()` [行750]
5. **詳細表示**: `ShowActivePackage()` [行515]
6. **ツール操作**: 各ToolStripボタンのクリックハンドラ
7. **外部連携**: `Everything()`による検索 [行992]
8. **更新処理**: `OnDragDrop()`とToolUpdate [行712]
