# 画面設計書: ProfilesForm（プロファイル管理画面）

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 8 |
| 画面名 | ProfilesForm |
| 画面名（日本語） | プロファイル管理画面 |
| ソースファイル | `Source/Forms/ProfilesForm.vb` |
| 継承元クラス | DialogBase |
| 画面種別 | モーダルダイアログ |

## 2. 画面概要

プロファイル（映像・音声・フィルタ等のプリセット設定）を管理するダイアログ。プロファイルの追加、削除、編集、複製、名前変更、並び替え機能を提供。サブメニュー構造への移動やデフォルトプロファイルの復元も可能。汎用的なプロファイル管理画面として設計されており、様々な種類のプロファイルに対応。

## 3. 画面レイアウト

### 3.1 レイアウト構成

```
+------------------------------------------------------------------+
| tlpMain (TableLayoutPanel)                                        |
| +-----------------------+----------------------------------------+|
| | pnListBox             | flpRight（ボタンパネル）               ||
| | +-------------------+ | +------------------------------------+ ||
| | | lbMain (ListBox)  | | | [Add...]        ← プロファイル追加 | ||
| | | ・Profile1        | | | [Remove]        ← 選択削除         | ||
| | | ・Profile2        | | | [Edit...]       ← 編集             | ||
| | | ・SubMenu|Item1   | | | [Rename]        ← 名前変更         | ||
| | | ・SubMenu|Item2   | | |                                    | ||
| | |   :               | | | tlpArrows（矢印ボタン）             | ||
| | |   :               | | | +------+   +------+                | ||
| | |                   | | | | ↑Up  |   | ←Left|                | ||
| | |                   | | | +------+   +------+                | ||
| | |                   | | | +------+   +------+                | ||
| | |                   | | | | ↓Down|   | Right→|               | ||
| | |                   | | | +------+   +------+                | ||
| | |                   | | |                                    | ||
| | |                   | | | [Clone]         ← 複製             | ||
| | |                   | | | [Load]          ← 読み込み         | ||
| | |                   | | | [Restore]       ← デフォルト復元   | ||
| | +-------------------+ | +------------------------------------+ ||
| +-----------------------+----------------------------------------+|
| [OK]                              [Cancel]                        |
+------------------------------------------------------------------+
```

### 3.2 主要コントロール一覧

| コントロール名 | 種類 | 説明 |
|--------------|------|------|
| tlpMain | TableLayoutPanel | メインレイアウト |
| pnListBox | Panel | リストボックスコンテナ |
| lbMain | ListBoxEx | プロファイル一覧（複数選択可） |
| flpRight | FlowLayoutPanel | ボタンパネル |
| bnAdd | ButtonEx | プロファイル追加ボタン |
| bnRemove | ButtonEx | 選択削除ボタン |
| bnEdit | ButtonEx | 編集ボタン |
| bnRename | ButtonEx | 名前変更ボタン |
| tlpArrows | TableLayoutPanel | 矢印ボタンレイアウト |
| bnUp | ButtonEx | 上へ移動ボタン |
| bnDown | ButtonEx | 下へ移動ボタン |
| bnLeft | ButtonEx | 親メニューへ移動ボタン |
| bnRight | ButtonEx | サブメニューへ移動ボタン |
| bnClone | ButtonEx | 複製ボタン |
| bnLoad | ButtonEx | 読み込みボタン |
| bnRestore | ButtonEx | デフォルト復元ボタン |
| bnOK | ButtonEx | OKボタン |
| bnCancel | ButtonEx | キャンセルボタン |
| TipProvider | TipProvider | ツールチップ提供 |

## 4. 機能仕様

### 4.1 画面機能一覧

| 機能ID | 機能名 | 説明 |
|--------|--------|------|
| F001 | プロファイル一覧表示 | 登録済みプロファイルの一覧表示 |
| F002 | プロファイル追加 | 新規プロファイルの追加 |
| F003 | プロファイル削除 | 選択プロファイルの削除（複数可） |
| F004 | プロファイル編集 | プロファイル設定の編集 |
| F005 | 名前変更 | プロファイル名の変更 |
| F006 | 上下移動 | プロファイルの表示順序変更 |
| F007 | サブメニュー移動（Left） | 親メニューへの移動 |
| F008 | サブメニュー作成（Right） | サブメニューへの格納 |
| F009 | 複製 | プロファイルのコピー作成 |
| F010 | 読み込み | プロファイルの即時適用 |
| F011 | デフォルト復元 | デフォルトプロファイルの復元 |
| F012 | ヘルプ表示 | ヘルプフォーム表示 |

### 4.2 イベント処理

| イベント | 処理内容 |
|---------|---------|
| lbMain.SelectedIndexChanged | ボタン有効/無効状態の更新 |
| lbMain.DoubleClick | 編集ダイアログ表示 |
| lbMain.KeyDown | キーボードショートカット処理 |
| bnAdd.Click | プロファイル追加処理 |
| bnRemove.Click | 選択プロファイル削除 |
| bnEdit.Click | プロファイル編集 |
| bnRename.Click | 名前変更ダイアログ表示 |
| bnUp.Click | 選択項目を上へ移動 |
| bnDown.Click | 選択項目を下へ移動 |
| bnLeft.Click | 親メニューへ移動 |
| bnRight.Click | サブメニューへ移動 |
| bnClone.Click | 選択項目を複製 |
| bnLoad.Click | プロファイル読み込み |
| bnRestore.Click | デフォルト復元ダイアログ |
| bnOK.Click | 変更を保存して閉じる |
| bnCancel.Click | 変更を破棄して閉じる |
| Me.HelpRequested | ヘルプフォーム表示 |

### 4.3 キーボードショートカット

| キー | 機能 |
|------|------|
| Delete | 選択プロファイル削除 |
| F2 | 名前変更 |
| Ctrl+Up | 選択項目を上へ移動 |
| Ctrl+Down | 選択項目を下へ移動 |
| F1 | ヘルプ表示 |

### 4.4 サブメニュー構造

プロファイル名に「 | 」（パイプ記号、前後スペース）を含めることでサブメニュー構造を表現。

- 例: `SubMenu | ProfileName` → SubMenuの下にProfileNameが格納される
- Leftボタン: 「 | 」より右の部分を抽出（親メニューへ移動）
- Rightボタン: 入力した名前を「 | 」付きで先頭に追加（サブメニュー作成）

## 5. データバインディング

### 5.1 関連データ

| データ項目 | バインド先 | 説明 |
|-----------|-----------|------|
| Profiles (IList) | lbMain.Items | プロファイル一覧 |
| Profile.Name | lbMain表示テキスト | プロファイル名 |
| Profile.CanEdit | bnEdit.Enabled | 編集可否 |

### 5.2 コンストラクタパラメータ

| パラメータ | 型 | 説明 |
|-----------|-----|------|
| title | String | ダイアログタイトル |
| profiles | IList | 編集対象プロファイルリスト |
| loadAction | Action(Of Profile) | 読み込み処理デリゲート |
| addFunc | Func(Of Profile) | 追加処理デリゲート |
| defaultsFunc | Func(Of IList) | デフォルト取得デリゲート |

## 6. 画面遷移

### 6.1 遷移元

| 遷移元 | トリガー |
|--------|---------|
| MainForm | プロファイル管理メニュー |
| 各設定画面 | プロファイル選択リンク |

### 6.2 遷移先

| 遷移先 | トリガー | 条件 |
|--------|---------|------|
| 各プロファイル編集ダイアログ | Edit | Profile.CanEdit = True |
| InputBox | Add/Rename/Right | - |
| HelpForm | F1キー | - |
| TaskDialog | Restore | デフォルト復元方法選択 |

## 7. 内部クラス・メソッド

### 7.1 主要プロパティ

| プロパティ | 型 | 説明 |
|-----------|-----|------|
| Profiles | IList | 編集対象プロファイルリスト |
| AddProfileMethod | Func(Of Profile) | 追加メソッドデリゲート |
| LoadProfileMethod | Action(Of Profile) | 読み込みメソッドデリゲート |
| DefaultsFunc | Func(Of IList) | デフォルト取得デリゲート |
| TextValues | Dictionary(Of Button, String) | ボタンテキスト保存用 |

### 7.2 主要メソッド

| メソッド | 説明 |
|---------|------|
| UpdateControls() | ボタン有効/無効状態の更新 |
| ApplyTheme() | テーマ適用 |

## 8. バリデーション

| 項目 | ルール | エラーメッセージ |
|------|--------|----------------|
| プロファイル名 | 空でないこと | （入力必須） |
| 名前重複 | 同名プロファイルの上書き確認 | There is already a profile with this name, overwrite? |

## 9. 非機能要件

### 9.1 UI/UX

- DPIスケーリング対応
- テーマ切り替え対応（ThemeManager連携）
- 複数選択対応（SelectionMode.MultiExtended）
- オーナードロー（DrawMode.OwnerDrawFixed）
- ボタンにアイコン表示（Symbol画像）
- ツールチップによる操作説明

### 9.2 デザイン

- 矢印ボタンはシンボル画像使用（Up, Down, Back, Forward）
- 操作ボタンにもシンボル画像使用（Add, Remove, Rename, TwoPage, Repair）

## 10. コードリーディングガイド

### 10.1 関連ファイル一覧

| ファイル | 役割 |
|---------|------|
| `Source/Forms/ProfilesForm.vb` | プロファイル管理フォーム実装（行1-580） |
| `Source/Profile.vb` | プロファイル基底クラス |
| `Source/UI/ListBoxEx.vb` | 拡張リストボックス |
| `Source/UI/TipProvider.vb` | ツールチップ提供 |
| `Source/ObjectHelp.vb` | オブジェクトコピー（GetCopy） |

### 10.2 プログラム呼び出し階層図

```
ProfilesForm (DialogBase)
├── New(title, profiles, loadAction, addFunc, defaultsFunc) [行298-348]
│   ├── InitializeComponent() [行30-288]
│   ├── lbMain.Items.Add() - プロファイルコピー追加
│   ├── UpdateControls() [行372-385]
│   ├── ボタン画像設定（Symbol）
│   ├── TipProvider.SetTip() - ツールチップ設定
│   └── ApplyTheme() [行360-370]
├── lbMain操作
│   ├── lbMain_SelectedIndexChanged() [行410-412]
│   │   └── UpdateControls()
│   ├── lbMain_DoubleClick() [行420-424]
│   │   └── bnEdit.PerformClick()
│   └── lbMain_KeyDown() [行387-408]
│       └── Delete/F2/Ctrl+Up/Down処理
├── ボタン操作
│   ├── bnAdd_Click() [行426-457]
│   │   ├── AddProfileMethod() - プロファイル作成
│   │   ├── InputBox.Show() - 名前入力
│   │   └── 重複チェック・挿入
│   ├── bnRemove_Click() [行459-462]
│   │   └── lbMain.RemoveSelection()
│   ├── bnRename_Click() [行464-473]
│   │   └── InputBox.Show() - 名前入力
│   ├── bnEdit_Click() [行475-482]
│   │   └── Profile.Edit() - 編集ダイアログ
│   ├── bnClone_Click() [行484-486]
│   │   └── ObjectHelp.GetCopy()
│   ├── bnUp_Click() [行488-491]
│   │   └── lbMain.MoveSelectionUp()
│   ├── bnDown_Click() [行493-496]
│   │   └── lbMain.MoveSelectionDown()
│   ├── bnLeft_Click() [行498-513]
│   │   └── 名前から「 | 」を除去
│   ├── bnRight_Click() [行515-531]
│   │   └── 名前に「SubMenu | 」を追加
│   ├── bnLoad_Click() [行414-418]
│   │   └── LoadProfileMethod()
│   └── bnRestore_Click() [行533-554]
│       └── TaskDialog - 復元方法選択
└── OnFormClosed() [行556-568]
    ├── Profiles更新
    └── g.SaveSettings()
```

### 10.3 データフロー図

```
[コンストラクタ]
      │
      ▼
[profiles (IList)]──► [lbMain.Items (コピー)]
      │
      ▼
[ユーザー操作（追加/削除/編集/移動）]
      │
      ▼
[lbMain.Items 更新]
      │
      ▼
[UpdateControls()]──► [ボタン有効/無効制御]
      │
      ▼
[OK クリック]
      │
      ▼
[OnFormClosed()]
      │
      ├──► [Profiles.Clear()]
      │
      ├──► [Profiles.Add() - 全項目]
      │
      └──► [g.SaveSettings()]
```

### 10.4 読み解きの推奨順序

1. **データ構造の理解**: `Profile`クラスの構造（Name, CanEdit, Edit()等）
2. **エントリーポイント**: コンストラクタ `New()` [行298]
3. **初期化処理**: デリゲート設定、リスト初期化、UI設定
4. **状態管理**: `UpdateControls()` [行372]
5. **追加処理**: `bnAdd_Click()` [行426]
6. **移動処理**: `bnLeft_Click()`, `bnRight_Click()`（サブメニュー構造）
7. **復元処理**: `bnRestore_Click()` [行533]
8. **保存処理**: `OnFormClosed()` [行556]
