# 画面設計書: MacrosForm（マクロ画面）

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 9 |
| 画面名 | MacrosForm |
| 画面名（日本語） | マクロ画面 |
| ソースファイル | `Source/Forms/MacrosForm.vb` |
| 継承元クラス | DialogBase |
| 画面種別 | モーダルダイアログ |

## 2. 画面概要

マクロ（動的変数）の一覧表示と検索を行う参照画面。マクロ名、展開後の値、説明を表示し、選択したマクロ名をクリップボードにコピーする機能を提供。スクリプト作成時のマクロ参照用として使用される。

## 3. 画面レイアウト

### 3.1 レイアウト構成

```
+------------------------------------------------------------------+
| tlpMain (TableLayoutPanel - 2列)                                   |
| +---------------------------+------------------------------------+ |
| | tlpLeft (35%)             | tlpRight (65%)                    | |
| | +------------------------+| +--------------------------------+ | |
| | | stb (SearchTextBox)    || | lNameTitle: Name:              | | |
| | | [検索ボックス______]   || | lName: %source_file%           | | |
| | +------------------------+| | [Copy]                         | | |
| | | lv (ListView - Tile)   || | lValueTitle: Value:            | | |
| | | +--------------------+ || | lValue: C:\Videos\sample.mp4   | | |
| | | | %source_file%      | || | lDescriptionTitle: Description:| | |
| | | | %target_file%      | || | lDescription: Source file path | | |
| | | | %source_dir%       | || |                                | | |
| | | | %target_dir%       | || |                                | | |
| | | | %source_name%      | || |                                | | |
| | | | %source_ext%       | || |                                | | |
| | | |   :                | || |                                | | |
| | | +--------------------+ || +--------------------------------+ | |
| | +------------------------+|                                    | |
| +---------------------------+------------------------------------+ |
+------------------------------------------------------------------+
```

### 3.2 主要コントロール一覧

| コントロール名 | 種類 | 説明 |
|--------------|------|------|
| tlpMain | TableLayoutPanel | メインレイアウト（2列） |
| tlpLeft | TableLayoutPanel | 左側パネル（検索+リスト） |
| tlpRight | TableLayoutPanel | 右側パネル（詳細表示） |
| stb | SearchTextBox | マクロ検索ボックス |
| lv | ListViewEx | マクロ一覧（Tileビュー） |
| lNameTitle | LabelEx | 名前ラベルタイトル |
| lName | LabelEx | マクロ名表示 |
| bnCopy | ButtonEx | クリップボードコピーボタン |
| lValueTitle | LabelEx | 値ラベルタイトル |
| lValue | LabelEx | 展開後の値表示 |
| lDescriptionTitle | LabelEx | 説明ラベルタイトル |
| lDescription | LabelEx | マクロ説明表示 |

## 4. 機能仕様

### 4.1 画面機能一覧

| 機能ID | 機能名 | 説明 |
|--------|--------|------|
| F001 | マクロ一覧表示 | 登録済みマクロの一覧表示 |
| F002 | マクロ検索 | マクロ名・説明での絞り込み検索 |
| F003 | マクロ詳細表示 | 選択マクロの名前・値・説明表示 |
| F004 | マクロ値展開 | マクロを実際の値に展開して表示 |
| F005 | クリップボードコピー | マクロ名をクリップボードにコピー |
| F006 | ヘルプ表示 | マクロWikiページ表示 |

### 4.2 イベント処理

| イベント | 処理内容 |
|---------|---------|
| Me.Load | マクロ一覧の初期表示 |
| stb.TextChanged | 検索フィルタリング・一覧更新 |
| lv.SelectedIndexChanged | 選択マクロの詳細表示 |
| lv.MouseDoubleClick | コピー＆閉じる |
| bnCopy.Click | マクロ名をクリップボードにコピー |
| Me.KeyDown | キーボードナビゲーション |
| Me.HelpRequested | WikiヘルプページをBrowserで表示 |

### 4.3 キーボードショートカット

| キー | 機能 |
|------|------|
| Enter | コピーして閉じる |
| Up | 前のマクロを選択 |
| Down | 次のマクロを選択 |
| F1 | ヘルプ（Wikiページ） |

## 5. データバインディング

### 5.1 関連データ

| データ項目 | バインド先 | 説明 |
|-----------|-----------|------|
| Macro.GetMacros() | lv.Items | マクロ一覧 |
| ListViewItem.Text | lName | マクロ名 |
| Macro.Expand(name) | lValue | 展開後の値 |
| ListViewItem.Tag | lDescription | マクロ説明 |

### 5.2 マクロ取得パラメータ

`Macro.GetMacros(True, True, True, True, False)`
- 第1引数: ソース関連マクロ
- 第2引数: ターゲット関連マクロ
- 第3引数: 一般マクロ
- 第4引数: 環境マクロ
- 第5引数: 空マクロを含めるか（False）

## 6. 画面遷移

### 6.1 遷移元

| 遷移元 | トリガー |
|--------|---------|
| MainForm | ヘルプ→Macrosメニュー |
| スクリプトエディタ | マクロ参照ボタン |

### 6.2 遷移先

| 遷移先 | トリガー | 条件 |
|--------|---------|------|
| ブラウザ（Wiki） | F1キー | - |
| (なし - 閉じる) | Enter/ダブルクリック | コピー後 |

## 7. 内部クラス・メソッド

### 7.1 主要メソッド

| メソッド | 説明 |
|---------|------|
| Populate() | マクロ一覧の生成・表示 |
| Match() | 検索文字列とのマッチング判定 |
| ShowDialogForm() | ダイアログ表示（静的メソッド） |
| ApplyTheme() | テーマ適用 |

### 7.2 静的メソッド

| メソッド | 説明 |
|---------|------|
| ShowDialogForm() | MacrosFormをモーダル表示 |

## 8. バリデーション

| 項目 | ルール | エラーメッセージ |
|------|--------|----------------|
| 検索 | 部分一致（大文字小文字無視） | - |
| 選択 | 未選択時は詳細表示クリア | - |

## 9. 非機能要件

### 9.1 パフォーマンス

- BeginUpdate/EndUpdateによるListView更新最適化
- 検索時のリアルタイムフィルタリング

### 9.2 UI/UX

- DPIスケーリング対応
- テーマ切り替え対応（ThemeManager連携）
- Tileビュー表示（View.Tile）
- Explorer風テーマ適用（Native.SetWindowTheme）
- コピー時のボタン太字フィードバック（300ms）
- タイトルラベルは太字表示
- 上下キーでリスト内ナビゲーション

### 9.3 デザイン

- 2カラムレイアウト（35%:65%）
- 左側: 検索＋リスト
- 右側: 詳細表示（名前・コピーボタン・値・説明）

## 10. コードリーディングガイド

### 10.1 関連ファイル一覧

| ファイル | 役割 |
|---------|------|
| `Source/Forms/MacrosForm.vb` | マクロフォーム実装（行1-396） |
| `Source/Macro.vb` | マクロクラス（GetMacros, Expand） |
| `Source/UI/ListViewEx.vb` | 拡張ListView |
| `Source/UI/SearchTextBox.vb` | 検索テキストボックス |
| `Source/StringPairList.vb` | 文字列ペアリスト |

### 10.2 プログラム呼び出し階層図

```
MacrosForm (DialogBase)
├── New() [行229-242]
│   ├── InitializeComponent() [行25-225]
│   ├── ScaleClientSize()
│   ├── lv設定（View.Tile, FullRowSelect等）
│   ├── Native.SetWindowTheme() - Explorerテーマ
│   └── ApplyTheme() [行254-266]
├── MacrosForm_Load() [行390-395]
│   ├── Populate() [行282-312]
│   │   ├── Macro.GetMacros() - マクロ一覧取得
│   │   ├── Match() - 検索フィルタリング
│   │   └── lv.Items.Add() - リスト追加
│   └── タイトルラベル太字設定
├── stb.TextChanged [行314-316]
│   └── Populate() - 再フィルタリング
├── lv.SelectedIndexChanged [行367-380]
│   ├── lName.Text = item.Text
│   ├── lValue.Text = Macro.Expand(item.Text)
│   └── lDescription.Text = item.Tag
├── bnCopy_Click() [行382-388]
│   ├── Clipboard.SetText(lName.Text)
│   ├── bnCopy.SetFontStyle(FontStyle.Bold)
│   ├── Thread.Sleep(300) - フィードバック表示
│   └── bnCopy.SetFontStyle(FontStyle.Regular)
├── lv.MouseDoubleClick [行362-365]
│   ├── bnCopy.PerformClick()
│   └── Close()
├── Me.KeyDown [行322-360]
│   ├── Enter → コピー＆閉じる
│   └── Up/Down → リスト選択移動
└── Me.HelpRequested [行318-320]
    └── g.ShowWikiPage("Macros")
```

### 10.3 データフロー図

```
[Macro.GetMacros()]
      │
      ▼
[StringPairList (Name, Description)]
      │
      ▼
[Match() フィルタリング]──► [stb.Text 検索文字列]
      │
      ▼
[lv.Items (ListViewItem)]
      │
      ├──► Text = マクロ名
      └──► Tag = 説明

[lv選択変更]
      │
      ▼
[lv_SelectedIndexChanged()]
      │
      ├──► lName.Text = マクロ名
      │
      ├──► lValue.Text = Macro.Expand(マクロ名)
      │
      └──► lDescription.Text = 説明

[コピー操作]
      │
      ▼
[Clipboard.SetText(lName.Text)]
```

### 10.4 読み解きの推奨順序

1. **データ構造の理解**: `Macro`クラス（GetMacros, Expand）
2. **エントリーポイント**: コンストラクタ `New()` [行229]
3. **初期化処理**: `MacrosForm_Load()` [行390]
4. **一覧生成**: `Populate()` [行282]
5. **検索処理**: `Match()` [行274], `tbFilter_TextChanged()` [行314]
6. **詳細表示**: `lv_SelectedIndexChanged()` [行367]
7. **コピー処理**: `bnCopy_Click()` [行382]
8. **キーボード操作**: `TaskForm_KeyDown()` [行322]
