---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-MainForm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **画面遷移先の条件**：一部遷移条件が推測
  2. **パフォーマンス要件**：実測値ではなく推定値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/MainForm.vb` 行1-999（InitializeComponent、コンストラクタ）
- E-02: `Source/Forms/MainForm.vb` 行85-959（UIコントロール定義）
- E-03: `Source/Forms/MainForm.vb` 行18-19（クラス定義、継承）
- E-04: `Source/Forms/MainForm.vb` 行919（AllowDrop = True）
- E-05: `Source/Forms/MainForm.vb` 行920-921（AutoScaleMode.Dpi）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面ID、画面名）
- E-07: `docs/code-to-docs/画面遷移図.md`（画面遷移情報）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面IDは1である | E-06 | ○ |
| C-02 | 画面名はMainFormである | E-06, E-03 | ○ |
| C-03 | FormBaseを継承している | E-03 (行19) | ○ |
| C-04 | ソースファイルはSource/Forms/MainForm.vb | E-01 | ○ |
| C-05 | MenuStripを持つ | E-02 (行93, 254-268) | ○ |
| C-06 | lgbSourceグループがある | E-02 (行103, 390-404) | ○ |
| C-07 | lgbTargetグループがある | E-02 (行94, 270-284) | ○ |
| C-08 | lgbFiltersグループがある | E-02 (行137, 821-832) | ○ |
| C-09 | lgbResizeグループがある | E-02 (行115, 543-556) | ○ |
| C-10 | lgbEncoderグループがある | E-02 (行139, 854-866) | ○ |
| C-11 | gbAudioグループがある | E-02 (行91, 220-236) | ○ |
| C-12 | gbAssistantグループがある | E-02 (行88, 176-191) | ○ |
| C-13 | tbSourceFileテキストボックスがある | E-02 (行112, 516-526) | ○ |
| C-14 | tbTargetFileテキストボックスがある | E-02 (行96, 312-323) | ○ |
| C-15 | tbBitrateテキストボックスがある | E-02 (行100, 354-364) | ○ |
| C-16 | FiltersListViewがある | E-02 (行138, 833-853) | ○ |
| C-17 | tbResizeトラックバーがある | E-02 (行132, 766-779) | ○ |
| C-18 | bnNextボタンがある | E-02 (行87, 163-174) | ○ |
| C-19 | ドラッグ&ドロップ対応 | E-04 (行919) | ○ |
| C-20 | DPIスケーリング対応 | E-05 (行920-921) | ○ |
| C-21 | tlpMainテーブルレイアウト使用 | E-02 (行143, 889-915) | ○ |
| C-22 | pnEncoderパネルがある | E-02 (行141, 879-888) | ○ |
| C-23 | llMuxerラベルがある | E-02 (行140, 867-878) | ○ |
| C-24 | 画面遷移先にPreviewFormがある | E-07 | △ |
| C-25 | パフォーマンス要件（1秒以内） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の1秒以内は推定値であり、実測値・要件定義からの根拠なし
  - 候補：性能テスト結果 / 非機能要件定義書 / ユーザー受け入れ基準
- 一部の画面遷移条件は推測に基づく
  - 候補：ユースケース仕様書 / 画面遷移設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UIコントロールの存在確認（コードで確認済み）
- 0: 低リスク - クラス継承関係（コードで確認済み）
- 1: 中リスク - 画面遷移の条件詳細（一部推測）
- 2: 高リスク - パフォーマンス要件（根拠なし）

## 6) レビュアーチェックリスト（最小）
- [ ] MainForm.vbの実装と設計書の整合性確認
- [ ] 画面遷移条件の実装確認（特にPreviewForm、ProcessingFormへの遷移）
- [ ] パフォーマンス要件の妥当性検証
- [ ] 機能一覧の網羅性確認（実装されている機能が漏れなく記載されているか）
- [ ] バリデーションルールの実装確認
