---
generated_at: 2026-01-21 11:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-HelpForm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/HelpForm.vb` 行4-5（クラス定義、継承）
- E-02: `Source/Forms/HelpForm.vb` 行20-44（InitializeComponent）
- E-03: `Source/Forms/HelpForm.vb` 行47-51（コンストラクタ）
- E-04: `Source/Forms/HelpForm.vb` 行55-68（Docプロパティ）
- E-05: `Source/Forms/HelpForm.vb` 行70-84（ShowDialog静的メソッド）
- E-06: `Source/Forms/HelpForm.vb` 行90-100（ブラウザイベント）
- E-07: `Source/Forms/HelpForm.vb` 行108-113（Navigating処理）
- E-08: `Source/General/General.vb` 行439〜（HelpDocumentクラス）
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面ID、画面名）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面IDは10である | E-09 | ○ |
| C-02 | 画面名はHelpFormである | E-09, E-01 | ○ |
| C-03 | FormBaseを継承している | E-01 (行5) | ○ |
| C-04 | WebBrowserコントロールが存在する | E-02 (行18, 21, 24-30) | ○ |
| C-05 | Dock.Fillで全面表示 | E-02 (行26) | ○ |
| C-06 | HelpDocumentで動的HTML生成 | E-04 (行58-60), E-08 | ○ |
| C-07 | 一時ファイルとしてHTM生成 | E-04 (行58) Folder.Temp | ○ |
| C-08 | MainForm.Disposedで一時ファイル削除 | E-04 (行59) | ○ |
| C-09 | ShowDialog静的メソッド | E-05 (行70-84) | ○ |
| C-10 | DocumentCompletedでテキストサイズリセット | E-06 (行90-92) | ○ |
| C-11 | Navigatedでタイトル更新 | E-06 (行94-100) | ○ |
| C-12 | http URLは外部ブラウザで開く | E-07 (行109-111) | ○ |
| C-13 | CenterScreen表示 | E-02 (行41) | ○ |
| C-14 | DPIスケーリング対応 | E-02 (行34-35) | ○ |
| C-15 | ダークテーマベース | E-08 (行462-464) 背景#323232 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目コードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] HelpForm.vbの実装と設計書の整合性確認
- [ ] HelpDocumentクラス（General.vb）との連携確認
- [ ] 一時ファイル管理（生成・削除）の動作確認
- [ ] 外部リンク（http URL）の処理確認
- [ ] テキストサイズリセットの動作確認
