---
generated_at: 2026-01-21 16:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：11-LogForm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/LogForm.vb` 行1-104（LogFormクラス全体）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行12（LogFormエントリ）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行44（機能No.67）
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` 行74-75, 88-89（遷移関係）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LogFormはエンコード処理ログを表示する画面 | E-01 行14, E-02 | ○ |
| C-02 | リッチテキスト形式でログを表示 | E-01 行12-14 | ○ |
| C-03 | MainFormのメニューからアクセス可能 | E-04 行74-75 | ○ |
| C-04 | ProcessingFormからF8キーでアクセス可能 | E-04 行88-89 | ○ |
| C-05 | ログファイルパスはp.Log.GetPathで取得 | E-01 行10, 14 | ○ |
| C-06 | 正規表現でセクション見出しを抽出 | E-01 行17-26 | ○ |
| C-07 | Save As機能でUTF-8保存 | E-01 行32-42 | ○ |
| C-08 | Save Obfuscated As機能で難読化保存 | E-01 行43-53 | ○ |
| C-09 | Open in Text Editor機能 | E-01 行54 | ○ |
| C-10 | Show in File Explorer機能 | E-01 行55 | ○ |
| C-11 | Show History機能 | E-01 行56 | ○ |
| C-12 | セクション選択でスクロール（lb_SelectedIndexChanged） | E-01 行98-103 | ○ |
| C-13 | URLの自動検出無効（DetectUrls = False） | E-01 行15 | ○ |
| C-14 | コードフォント使用（FontManager.GetCodeFont） | E-01 行12 | ○ |
| C-15 | リストボックス行高さはFontHeight * 2 | E-01 行11 | ○ |
| C-16 | テーマ変更対応（ThemeManager） | E-01 行58-60, 69-96 | ○ |
| C-17 | ショートカットキーCtrl+S（Save As） | E-01 行42 | ○ |
| C-18 | ショートカットキーCtrl+H（Show History） | E-01 行56 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：すべての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] LogForm.vbのコンストラクタ処理が設計書と一致しているか
- [x] コンテキストメニュー項目が正しく記載されているか
- [x] 画面遷移元が正しく記載されているか
