---
generated_at: 2026-01-21 16:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-VideoComparisonForm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/VideoComparisonForm.vb` 行1-614（全体）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行13（VideoComparisonForm）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行45-46（機能No.48, 46）
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` 行77（MainForm → VideoComparisonForm）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 複数動画をタブ形式で比較する画面 | E-01 行163, E-02 | ○ |
| C-02 | MainFormのTools > Video Comparisonからアクセス | E-04 行77 | ○ |
| C-03 | ドラッグ&ドロップでファイル追加可能 | E-01 行25-34, 85-118 | ○ |
| C-04 | トラックバーでフレーム位置指定 | E-01 行228-236 | ○ |
| C-05 | マウスホイールで100フレーム移動 | E-01 行265-279 | ○ |
| C-06 | PNG画像として保存可能 | E-01 行195-226 | ○ |
| C-07 | CropZoom機能でクロップ設定 | E-01 行291-331 | ○ |
| C-08 | GoToFrameでフレーム番号へジャンプ | E-01 行333-340 | ○ |
| C-09 | GoToTimeで時間指定ジャンプ | E-01 行342-352 | ○ |
| C-10 | AviSynthパッケージが必要 | E-01 行130 | ○ |
| C-11 | MP4はLSMASHVideoSource使用 | E-01 行427 | ○ |
| C-12 | その他はFFVideoSource使用 | E-01 行429 | ○ |
| C-13 | SetMemoryMax(512)を設定 | E-01 行431, 434 | ○ |
| C-14 | VideoTabはTabPageを継承 | E-01 行354-355 | ○ |
| C-15 | VideoTabはIFrameServerを保持 | E-01 行357 | ○ |
| C-16 | CSVログファイルからフレーム情報読込 | E-01 行464-488 | ○ |
| C-17 | フレーム番号のPrefix/Suffix設定 | E-01 行199-206 | ○ |
| C-18 | OnShownでAdd()を呼び出し | E-01 行286-289 | ○ |
| C-19 | ソースファイル自動追加 | E-01 行135-137 | ○ |
| C-20 | テーマ変更対応（ThemeManager） | E-01 行57-83 | ○ |
| C-21 | HelpFormへ遷移可能（F1） | E-01 行47, 238-245 | ○ |
| C-22 | 比較プレビュー機能（機能No.48） | E-03 行45 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：すべての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] VideoTabクラスの構造が設計書と一致しているか
- [x] ファイル種別ごとのスクリプト生成処理が正確か
- [x] PNG保存のファイル名形式が正確か
