---
generated_at: 2026-01-21 16:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-SimpleSettingsForm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/SimpleSettingsForm.vb` 行1-174（全体）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行14（SimpleSettingsForm）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 汎用的な設定ダイアログ | E-02 | ○ |
| C-02 | DialogBaseを継承 | E-01 行5 | ○ |
| C-03 | SimpleUIコンポーネントを使用 | E-01 行49-56 | ○ |
| C-04 | タイトルとヘルプ情報をコンストラクタで受け取り | E-01 行120 | ○ |
| C-05 | SetMinimumSize(33, 25)で最小サイズ設定 | E-01 行122 | ○ |
| C-06 | ScaleClientSize(40, 32.75)でサイズ設定 | E-01 行123 | ○ |
| C-07 | タイトルバー形式 | E-01 行124 | ○ |
| C-08 | HelpParagraphsを保存 | E-01 行118, 125 | ○ |
| C-09 | SimpleUI.Tree.Select()を呼び出し | E-01 行126 | ○ |
| C-10 | F1キーでヘルプ表示 | E-01 行157-172 | ○ |
| C-11 | HelpFormインスタンス作成 | E-01 行158 | ○ |
| C-12 | TipProviderからツールチップ取得 | E-01 行167-169 | ○ |
| C-13 | CancelButtonに設定済み | E-01 行102-103（Designer） | ○ |
| C-14 | テーマ変更対応 | E-01 行127, 129, 138-150 | ○ |
| C-15 | DPI対応（AutoScaleMode.Dpi） | E-01 行101（Designer） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：すべての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] SimpleUIコンポーネントの使用方法が正確か
- [x] HelpRequested処理が正確か
- [x] DialogBaseからの継承が正しいか
