---
generated_at: 2026-01-21 16:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：14-MuxerForm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **ドラッグ&ドロップで行並び替え**：実装詳細未確認
  2. **字幕言語自動検出**：実装詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/MuxerForm.vb` 行1-450（全体）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行15（MuxerForm）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行26-29（機能No.29, 30, 35, 36）
- E-04: `Source/Encoding/Muxer.vb`（Muxerクラス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | マルチプレクサ設定画面である | E-02, E-03 | ○ |
| C-02 | MKV/MP4等へのストリーム結合 | E-04 | ○ |
| C-03 | MainFormのContainerメニューからアクセス | E-02 | ○ |
| C-04 | 動画ストリーム設定機能 | E-01 | ○ |
| C-05 | 音声ストリーム追加・編集・削除 | E-01 | ○ |
| C-06 | 字幕ストリーム追加・編集・削除 | E-01 | ○ |
| C-07 | チャプターファイル指定 | E-01 | ○ |
| C-08 | タグファイル指定 | E-01 | ○ |
| C-09 | コマンドラインプレビュー機能 | E-01 | ○ |
| C-10 | DataGridViewで音声・字幕一覧表示 | E-01 | ○ |
| C-11 | MKV/MP4オプションはSimpleSettingsFormで設定 | E-01 | ○ |
| C-12 | チャプターファイル形式（OGG/TXT/XML） | E-01 | ○ |
| C-13 | タグファイル形式（XML） | E-01 | ○ |
| C-14 | Muxer設定のディープコピー作成 | E-01 | ○ |
| C-15 | EditModeによる編集モード切替 | E-04 | ○ |
| C-16 | テーマ変更対応 | E-01 | ○ |
| C-17 | 字幕対応形式（SUP/SRT/ASS/SSA/IDX/VTT/PGS） | E-01 | ○ |
| C-18 | BatchAudioProfile/GUIAudioProfileの編集ダイアログ | E-01 | ○ |
| C-19 | ドラッグ&ドロップで行並び替え可能 | **根拠なし** | △ |
| C-20 | 字幕言語自動検出 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-19: DataGridView行の並び替え機能の実装箇所が未特定
  - 候補：MuxerForm.vb内のドラッグ関連イベントハンドラ / UI/DataGridViewExtensions
- C-20: 字幕追加時の言語自動検出ロジックの実装箇所が未特定
  - 候補：Subtitle.vb / MediaInfo連携

## 5) リスクフラグ（レビュー観点）
- 1（中リスク）：2件の主張で根拠確認が必要

## 6) レビュアーチェックリスト（最小）
- [x] MuxerForm.vbでDataGridView操作が正確か
- [ ] 行並び替え機能の実装を確認
- [ ] 字幕言語自動検出の実装を確認
- [x] MKV/MP4オプション設定が正確か
