---
generated_at: 2026-01-21 16:50:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-SourceFilesForm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/SourceFilesForm.vb` 行1-148（全体）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行16（SourceFilesForm）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行17-18（機能No.15, 16）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ソースファイル管理画面である | E-02 | ○ |
| C-02 | 複数ソースファイルを管理 | E-01 | ○ |
| C-03 | ドラッグ&ドロップで順序変更 | E-01 行107, E-03 | ○ |
| C-04 | MainFormから遷移 | E-02 | ○ |
| C-05 | Add...ボタンでファイル追加 | E-01 行112-125 | ○ |
| C-06 | Remove...ボタンでファイル削除 | E-01 行127-135 | ○ |
| C-07 | リストボックスにファイル一覧表示 | E-01 行70-83（Designer） | ○ |
| C-08 | ScaleClientSize(30, 15)でサイズ設定 | E-01 行103 | ○ |
| C-09 | ListBoxEx.EnableDragAndDropReorderで有効化 | E-01 行107 | ○ |
| C-10 | 複数ファイル選択対応（OpenFileDialog.Multiselect） | E-01 行118 | ○ |
| C-11 | FilePathsプロパティで結果取得 | E-01 行100-104 | ○ |
| C-12 | テーマ変更対応 | E-01 行108, 137-148 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：すべての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] リストボックスのドラッグ&ドロップ機能が正確か
- [x] ファイル追加・削除処理が正確か
- [x] FilePathsプロパティの実装が正確か
