---
generated_at: 2026-01-21 16:55:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-StreamDemuxForm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/StreamDemuxForm.vb` 行1-211（全体）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行17（StreamDemuxForm）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行19-21（機能No.19, 20, 21）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ストリームデマックス画面である | E-02 | ○ |
| C-02 | 音声・字幕・添付ファイルを抽出 | E-01 行10-20, E-03 | ○ |
| C-03 | MediaInfoでストリーム情報取得 | E-01 行53-54 | ○ |
| C-04 | チェックボックスで選択 | E-01 行30, 41, 47 | ○ |
| C-05 | 音声All/None/English/Native選択 | E-01 行135-165 | ○ |
| C-06 | 字幕All/None/English/Native選択 | E-01 行167-197 | ○ |
| C-07 | 添付ファイルAll/None選択 | E-01 行199-209 | ○ |
| C-08 | チャプターデマックスチェック | E-01 行87 | ○ |
| C-09 | 動画デマックスチェック | E-01 行88 | ○ |
| C-10 | ScaleClientSize(42, 30) | E-01 行24 | ○ |
| C-11 | Owner = g.MainForm | E-01 行25 | ○ |
| C-12 | ListViewExのAutoCheckMode.SingleClick | E-01 行36, 42, 48 | ○ |
| C-13 | HideFocusRectange()でフォーカス矩形非表示 | E-01 行35 | ○ |
| C-14 | 英語以外でネイティブ言語ボタン表示 | E-01 行57-58, 62-63 | ○ |
| C-15 | lvAudio_ItemCheckedでEnabled更新 | E-01 行117-121 | ○ |
| C-16 | lvSubtitles_ItemCheckedでEnabled更新 | E-01 行123-127 | ○ |
| C-17 | lvAttachments_ItemCheckedでEnabled更新 | E-01 行129-133 | ○ |
| C-18 | AudioStreamsプロパティでチェック済み取得 | E-01 行10-14 | ○ |
| C-19 | Subtitlesプロパティでチェック済み取得 | E-01 行16-20 | ○ |
| C-20 | テーマ変更対応 | E-01 行90, 92, 101-115 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：すべての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] MediaInfo連携処理が正確か
- [x] 言語ボタンの有効/無効ロジックが正確か
- [x] AudioStreams/Subtitlesプロパティが正確か
