---
generated_at: 2026-01-21 17:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-eac3toForm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/eac3toForm.vb` 行1-1245（全体）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行18（eac3toForm）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行19, 22-23（機能No.19, 22, 20）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | eac3toデマックス画面である | E-02, E-03 | ○ |
| C-02 | Blu-rayからストリーム抽出 | E-01 行729-735, E-03 | ○ |
| C-03 | Projectオブジェクトを受け取り初期化 | E-01 行590 | ○ |
| C-04 | OnShownでバックグラウンド解析開始 | E-01 行1240-1243 | ○ |
| C-05 | eac3to.exeを起動 | E-01 行738-746 | ○ |
| C-06 | OutputDataReceivedでプログレス表示 | E-01 行769-778 | ○ |
| C-07 | Init()でストリーム情報構築 | E-01 行780-961 | ○ |
| C-08 | 音声出力形式リスト（m4a/ac3等） | E-01 行586 | ○ |
| C-09 | DTS-coreオプション自動付加 | E-01 行1072-1093 | ○ |
| C-10 | Audio Stream Profilesでマッチング | E-01 行895-906 | ○ |
| C-11 | 動画出力形式変更時のリスト更新 | E-01 行1046-1070 | ○ |
| C-12 | GetArgsでコマンドライン生成 | E-01 行967-1030 | ○ |
| C-13 | FolderBrowserDialogで出力先選択 | E-01 行1032-1039 | ○ |
| C-14 | OnFormClosingで設定保存 | E-01 行1208-1237 | ○ |
| C-15 | 3D映像エラー処理 | E-01 行788-790 | ○ |
| C-16 | SizeSavingDialogBase継承 | E-01 行9-10 | ○ |
| C-17 | M2TSStreamオブジェクト構造 | E-01 行822-842 | ○ |
| C-18 | Codecに応じた出力タイプ自動設定 | E-01 行869-893 | ○ |
| C-19 | チャプター設定保存 | E-01 行1234 | ○ |
| C-20 | Haaliパッケージ確認 | E-01 行1230-1232 | ○ |
| C-21 | コンテキストメニュー設定 | E-01 行643-646 | ○ |
| C-22 | テーマ変更対応 | E-01 行650, 652, 655-675 | ○ |
| C-23 | RestoreClientSize(40, 30) | E-01 行593 | ○ |
| C-24 | MsgErrorでエラー表示 | E-01 行751-754, 786-787, 789-790 | ○ |
| C-25 | Cancel()でフォームキャンセル | E-01 行761-767 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：すべての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] eac3to解析処理（StartAnalyze）が正確か
- [x] ストリーム情報パース（Init）が正確か
- [x] 出力形式リストと自動設定が正確か
