---
generated_at: 2026-01-21 17:05:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-CommandLineForm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/CommandLineForm.vb` 行1-619（全体）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行19（CommandLineForm）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行23-28（機能No.23-28）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンドライン設定画面である | E-02 | ○ |
| C-02 | 動画エンコーダのパラメータ設定 | E-03 | ○ |
| C-03 | CommandLineParamsを受け取り初期化 | E-01 行21 | ○ |
| C-04 | SimpleUIでUI要素動的生成 | E-01 行132-318 | ○ |
| C-05 | BoolParam→CheckBox | E-01 行208-221 | ○ |
| C-06 | NumParam→NumEdit | E-01 行222-245 | ○ |
| C-07 | OptionParam→MenuButton | E-01 行247-278 | ○ |
| C-08 | StringParam→TextEdit | E-01 行279-307 | ○ |
| C-09 | ValueChangedでコマンドライン再生成 | E-01 行124-130 | ○ |
| C-10 | 検索機能（cbGoTo_TextChanged） | E-01 行381-489 | ○ |
| C-11 | 2文字以上で検索開始 | E-01 行391 | ○ |
| C-12 | Enterキーで次のマッチへ移動 | E-01 行369-378 | ○ |
| C-13 | Execute Command Line（Ctrl+E） | E-01 行53 | ○ |
| C-14 | Copy Command Line（Ctrl+Shift+C） | E-01 行60 | ○ |
| C-15 | Show Command Line（F4） | E-01 行61 | ○ |
| C-16 | Import Command Line（Ctrl+I） | E-01 行62 | ○ |
| C-17 | Command Line Highlighting（Ctrl+H） | E-01 行72-73 | ○ |
| C-18 | Preview Mouse-Up Search（Ctrl+P） | E-01 行80-81 | ○ |
| C-19 | rtbCommandLine右クリックメニュー | E-01 行553-582 | ○ |
| C-20 | SelectLastPage()で前回ページ復元 | E-01 行120-122 | ○ |
| C-21 | タイトルバー形式 | E-01 行40 | ○ |
| C-22 | ラベルダブルクリックでデフォルト値 | E-01 行244, 266 | ○ |
| C-23 | s.CommandLineHighlightingで設定永続化 | E-01 行68 | ○ |
| C-24 | テーマ変更対応 | E-01 行93, 95, 98-118 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：すべての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] InitUIでのUI要素生成が正確か
- [x] 検索機能の実装が正確か
- [x] コンテキストメニュー項目が正確か
