---
generated_at: 2026-01-21 17:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-CommandLineVideoEncoderForm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/CommandLineVideoEncoderForm.vb` 行1-285（全体）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行20（CommandLineVideoEncoderForm）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行58, 42（機能No.65, 42）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンドライン動画エンコーダ設定画面 | E-02 | ○ |
| C-02 | BatchEncoderを受け取り初期化 | E-01 行214 | ○ |
| C-03 | DialogBaseを継承 | E-01 行4-5 | ○ |
| C-04 | RestoreClientSize(50, 22) | E-01 行217 | ○ |
| C-05 | cbQualityMode設定 | E-01 行220 | ○ |
| C-06 | tbType（出力拡張子）設定 | E-01 行221 | ○ |
| C-07 | EncodingControl.SetCommandLineDefaults() | E-01 行224 | ○ |
| C-08 | CompCheckControl.SetCommandLineDefaults() | E-01 行227 | ○ |
| C-09 | numPercent設定 | E-01 行230 | ○ |
| C-10 | 品質モードON時のUI切替 | E-01 行269-283 | ○ |
| C-11 | RowStyles(2).Height = 0（品質モードON時） | E-01 行273 | ○ |
| C-12 | CompCheckControl.Visible設定 | E-01 行278 | ○ |
| C-13 | laPercent/numPercent.Visible設定 | E-01 行281-282 | ○ |
| C-14 | OnFormClosedでEncoder更新 | E-01 行259-267 | ○ |
| C-15 | numPercent.Maximum = 200 | E-01 行72 | ○ |
| C-16 | numPercent.Increment = 5 | E-01 行69 | ○ |
| C-17 | TipProviderでツールチップ設定 | E-01 行232 | ○ |
| C-18 | テーマ変更対応 | E-01 行234, 237, 243-257 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：すべての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] コンストラクタの初期化処理が正確か
- [x] 品質モード切替のUI処理が正確か
- [x] OnFormClosedでの保存処理が正確か
