---
generated_at: 2026-01-21 10:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：2-PreviewForm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：リアルタイム応答の定義が曖昧

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/PreviewForm.vb` 行9-10（クラス定義、継承）
- E-02: `Source/Forms/PreviewForm.vb` 行31-231（InitializeComponent）
- E-03: `Source/Forms/PreviewForm.vb` 行253-285（コンストラクタ）
- E-04: `Source/Forms/PreviewForm.vb` 行303-346（Open メソッド）
- E-05: `Source/Forms/PreviewForm.vb` 行410-462（ナビゲーションボタン）
- E-06: `Source/Forms/PreviewForm.vb` 行652-711（カット範囲設定）
- E-07: `Source/Forms/PreviewForm.vb` 行978-1035（GetDefaultMenu）
- E-08: `Source/Forms/PreviewForm.vb` 行493-558（トラックバー描画）
- E-09: `Source/Forms/PreviewForm.vb` 行235（Instances共有リスト）
- E-10: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面ID、画面名）
- E-11: `docs/code-to-docs/画面遷移図.md`（画面遷移情報）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面IDは2である | E-10 | ○ |
| C-02 | 画面名はPreviewFormである | E-10, E-01 | ○ |
| C-03 | DialogBaseを継承している | E-01 (行10) | ○ |
| C-04 | pnVideoパネルが存在する | E-02 (行43, 170-189) | ○ |
| C-05 | pnTrackパネルが存在する | E-02 (行45, 198-208) | ○ |
| C-06 | ナビゲーションボタンが10個存在する | E-02 (行33-46) | ○ |
| C-07 | bnLeft3は100フレーム後退 | E-02 (行168), E-05 (行452-456) | ○ |
| C-08 | bnLeft2は10フレーム後退 | E-02 (行132), E-05 (行434-438) | ○ |
| C-09 | bnLeft1は1フレーム後退 | E-02 (行84), E-05 (行416-420) | ○ |
| C-10 | bnRight1は1フレーム前進 | E-02 (行72), E-05 (行410-414) | ○ |
| C-11 | bnRight2は10フレーム前進 | E-02 (行120), E-05 (行440-444) | ○ |
| C-12 | bnRight3は100フレーム前進 | E-02 (行155), E-05 (行458-462) | ○ |
| C-13 | カット範囲設定機能がある | E-06 (行652-691) | ○ |
| C-14 | フルスクリーン切替機能がある | E-03 (行370-395, 598-610) | ○ |
| C-15 | 複数インスタンス対応 | E-09 (行235) | ○ |
| C-16 | Homeキーでカット開始設定 | E-07 (行1001) | ○ |
| C-17 | Endキーでカット終了設定 | E-07 (行1002) | ○ |
| C-18 | Enterキーでフルスクリーン切替 | E-07 (行1013) | ○ |
| C-19 | F1キーでヘルプ表示 | E-07 (行1031) | ○ |
| C-20 | SaveBitmapメソッドがある | E-07 (行864-885) | ○ |
| C-21 | SavePngメソッドがある | E-07 (行887-908) | ○ |
| C-22 | SaveJPGメソッドがある | E-07 (行910-931) | ○ |
| C-23 | コンテキストメニューがある | E-02 (行44, 191-196) | ○ |
| C-24 | トラックバーでカット範囲が緑色表示 | E-08 (行504-520) | ○ |
| C-25 | マウスホイールでフレーム移動 | E-07 (行1155-1173) | ○ |
| C-26 | ダブルクリックでフルスクリーン切替 | E-07 (行1283-1285) | ○ |
| C-27 | アスペクト比維持リサイズ | E-07 (行1196-1221) | ○ |
| C-28 | パフォーマンス要件（リアルタイム応答） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の「リアルタイム応答」は推定値
  - 候補：性能テスト結果 / 非機能要件定義書 / ユーザー受け入れ基準

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UIコントロールの存在確認（コードで確認済み）
- 0: 低リスク - ナビゲーション機能（コードで確認済み）
- 0: 低リスク - キーボードショートカット（コードで確認済み）
- 1: 中リスク - パフォーマンス要件（根拠なし）

## 6) レビュアーチェックリスト（最小）
- [ ] PreviewForm.vbの実装と設計書の整合性確認
- [ ] ナビゲーションボタンの機能が正しく記載されているか確認
- [ ] キーボードショートカットの網羅性確認
- [ ] カット機能のロジックが正確に記載されているか確認
- [ ] 複数インスタンス対応の動作確認
