---
generated_at: 2026-01-21 16:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：21-コマンドラインデマックス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **画面へのアクセス方法の具体的パス**：PreprocessingControlからの遷移経路について要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/CommandLineDemuxForm.vb` - 329-350行目（コンストラクタ）
- E-02: `Source/Forms/CommandLineDemuxForm.vb` - 35-321行目（InitializeComponent）
- E-03: `Source/Forms/CommandLineDemuxForm.vb` - 386-398行目（OnFormClosed）
- E-04: `Source/Forms/CommandLineDemuxForm.vb` - 400-406行目（tbCommand_DoubleClick）
- E-05: `Source/Forms/CommandLineDemuxForm.vb` - 416-418行目（MacrosToolStripMenuItem_Click）
- E-06: `Source/Forms/CommandLineDemuxForm.vb` - 420-431行目（HelpToolStripMenuItem_Click）
- E-07: `Source/Forms/CommandLineDemuxForm.vb` - 374-384行目（ConvertFormat）
- E-08: `Source/General/Demux.vb` - 111-179行目（CommandLineDemuxer）
- E-09: `Source/General/Demux.vb` - 123-127行目（ShowConfigDialog）
- E-10: `Source/General/Demux.vb` - 70-107行目（GetDefaults定義例）
- E-11: `docs/code-to-docs/画面一覧/画面一覧.csv` - 22行目
- E-12: `docs/code-to-docs/画面遷移図.md` - デマックス関連セクション

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CommandLineDemuxFormはコマンドラインベースのカスタムデマルチプレクサを設定するダイアログ | E-08, E-09, E-11 | ○ |
| C-02 | デマクサ名の設定が可能 | E-01, E-02 (tbName) | ○ |
| C-03 | 入力ファイルタイプの設定が可能 | E-01, E-02 (tbInput) | ○ |
| C-04 | 出力ファイルタイプの設定が可能 | E-01, E-02 (tbVideoOut) | ○ |
| C-05 | 入力フォーマットの設定が可能 | E-01, E-02 (tbInputFormats) | ○ |
| C-06 | ソースフィルタの設定が可能 | E-01, E-02 (tbSourceFilters) | ○ |
| C-07 | 実行コマンドの設定が可能 | E-01, E-02 (tbCommand) | ○ |
| C-08 | コマンドライン引数の設定が可能（マルチライン） | E-01 (343行目), E-02 (tbArguments) | ○ |
| C-09 | OKボタンでDialogResult.OKを返す | E-02 (139-143行目) | ○ |
| C-10 | OnFormClosedでTargetオブジェクトに値を反映 | E-03 | ○ |
| C-11 | 入力値はスペース/カンマ/セミコロンで分割 | E-03 (389行目) | ○ |
| C-12 | ConvertFormatでMPEG Video→mpeg2等の正規化 | E-07 | ○ |
| C-13 | 参照ボタンでOpenFileDialog表示 | E-04 | ○ |
| C-14 | Argumentsダブルクリックでマクロフォーム表示 | E-05 (408-410行目) | ○ |
| C-15 | Macrosメニューでマクロフォーム表示 | E-05 | ○ |
| C-16 | Helpメニューでパッケージヘルプ表示 | E-06 | ○ |
| C-17 | パッケージ不一致時に警告メッセージ表示 | E-06 (429-430行目) | ○ |
| C-18 | F1でHelpForm表示 | E-02 (433-438行目) | ○ |
| C-19 | DialogBaseを継承 | E-02 (4行目) | ○ |
| C-20 | ThemeManagerでテーマ変更対応 | E-01 (349行目), E-02 (362-372行目) | ○ |
| C-21 | CommandLineDemuxerはCommandプロパティを持つ | E-08 (114行目) | ○ |
| C-22 | CommandLineDemuxerはArgumentsプロパティを持つ | E-08 (115行目) | ○ |
| C-23 | DGIndex用の設定例が存在 | E-10 (85-93行目) | ○ |
| C-24 | D2V Witch用の設定例が存在 | E-10 (94-103行目) | ○ |
| C-25 | 画面一覧でNo.21として定義 | E-11 | ○ |
| C-26 | ObjectHelpでコピーを作成して編集 | E-01 (334行目) | ○ |
| C-27 | TableLayoutPanelで8行3列レイアウト | E-02 (172-180行目) | ○ |
| C-28 | PreprocessingControlからアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- PreprocessingControlからCommandLineDemuxFormへの具体的な呼び出し経路
  - 候補：PreprocessingControl.vb / MainForm.vb / デマクサ選択コンボボックスのイベント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほぼすべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] PreprocessingControlからの遷移経路を実際のUIで確認
- [ ] マクロ（%source_file%等）が引数フィールドで正しく展開されることを確認
- [ ] 各入力フィールドのバリデーション動作を確認
