---
generated_at: 2026-01-21 16:50:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-コード編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張が根拠付き）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/CodeForm.vb` - 全体（1-93行目）
- E-02: `Source/Forms/CodeForm.Designer.vb` - 全体（1-42行目）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 25行目
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 63-65行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CodeFormはスクリプトコードを表示・閲覧する画面 | E-01, E-03 | ○ |
| C-02 | FormBaseを継承 | E-02 (5行目) | ○ |
| C-03 | RichTextBoxExで内容表示 | E-02 (15, 41行目) | ○ |
| C-04 | Findプロパティで検索文字列保持 | E-01 (7行目) | ○ |
| C-05 | Contentプロパティで内容保持 | E-01 (8行目) | ○ |
| C-06 | コンストラクタでtext/find/wordwrap受け取り | E-01 (10行目) | ○ |
| C-07 | RestoreClientSizeでウィンドウサイズ復元 | E-01 (14行目) | ○ |
| C-08 | rtb.ReadOnly = Trueで読み取り専用 | E-01 (16行目) | ○ |
| C-09 | rtb.WordWrapでワードラップ設定 | E-01 (17行目) | ○ |
| C-10 | FontManager.GetCodeFont()でフォント設定 | E-01 (18行目) | ○ |
| C-11 | ThemeManager.CurrentThemeChangedを監視 | E-01 (25行目) | ○ |
| C-12 | Disposeでイベントハンドラ解除 | E-01 (28-31行目) | ○ |
| C-13 | ApplyThemeでRichTextBoxの色を更新 | E-01 (42-49行目) | ○ |
| C-14 | Shownイベントで初期検索実行 | E-01 (51-55行目) | ○ |
| C-15 | FindByIndexで再帰的検索 | E-01 (57-86行目) | ○ |
| C-16 | rtb.Findで検索実行 | E-01 (62行目) | ○ |
| C-17 | ScrollToCaretでスクロール | E-01 (63行目) | ○ |
| C-18 | 行頭から15文字以上離れていたら次を検索 | E-01 (82-84行目) | ○ |
| C-19 | ESCキーでフォームをクローズ | E-01 (88-92行目) | ○ |
| C-20 | RichTextBoxのBorderStyleはNone | E-02 (20行目) | ○ |
| C-21 | RichTextBoxはDockStyleFill | E-02 (21行目) | ○ |
| C-22 | ShowIcon = False | E-02 (36行目) | ○ |
| C-23 | 機能No.73コードエディタに対応 | E-04 (63行目) | ○ |
| C-24 | AviSynth/VapourSynth連携 | E-04 (64-65行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 大きなスクリプトファイルでのパフォーマンスを確認
- [ ] 検索結果が見つからない場合の挙動を確認
- [ ] 各テーマでの表示が正しいことを確認
