---
generated_at: 2026-01-21 17:10:00
metrics:
  claims_total: 23
  claims_with_evidence: 23
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-メニューテンプレート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：23 / 23、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張が根拠付き）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/UI/MenuTemplateForm.vb` - 全体（1-160行目）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 29行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MenuTemplateFormはメニューテンプレート選択ダイアログ | E-01, E-02 | ○ |
| C-02 | DialogBaseを継承 | E-01 (4行目) | ○ |
| C-03 | Namespace UI内に定義 | E-01 (2行目) | ○ |
| C-04 | TreeViewExでメニュー構造表示 | E-01 (8, 9行目) | ○ |
| C-05 | TreeNodeプロパティで選択ノード保持 | E-01 (99行目) | ○ |
| C-06 | コンストラクタでCustomMenuItem受け取り | E-01 (101行目) | ○ |
| C-07 | PopulateTreeViewでツリー構築 | E-01 (103, 131-144行目) | ○ |
| C-08 | tv.ExpandAll()で全展開 | E-01 (104行目) | ○ |
| C-09 | ApplyTheme()でテーマ適用 | E-01 (106行目) | ○ |
| C-10 | ThemeManager.CurrentThemeChanged監視 | E-01 (107行目) | ○ |
| C-11 | Disposeでイベントハンドラ解除 | E-01 (110-112行目) | ○ |
| C-12 | BackColorをテーマ色に更新 | E-01 (128行目) | ○ |
| C-13 | PopulateTreeViewは再帰処理 | E-01 (140-142行目) | ○ |
| C-14 | newNode.Tag = itemでCustomMenuItem保持 | E-01 (133行目) | ○ |
| C-15 | tv_AfterSelectで選択処理 | E-01 (146-151行目) | ○ |
| C-16 | bnOK.Enabled = Not Parent Is Nothing | E-01 (149行目) | ○ |
| C-17 | MenuTemplateForm_HelpRequestedでヘルプ表示 | E-01 (153-158行目) | ○ |
| C-18 | ヘルプにクローン説明メッセージ | E-01 (156行目) | ○ |
| C-19 | AcceptButton = bnOK | E-01 (77行目) | ○ |
| C-20 | CancelButton = bnCancel | E-01 (80行目) | ○ |
| C-21 | tv.DockはFill | E-01 (20行目) | ○ |
| C-22 | pnTreeViewでPanelラップ | E-01 (13, 63-73行目) | ○ |
| C-23 | タイトルに"Default Menu"を含む | E-01 (86行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 深いメニュー階層でのツリー展開を確認
- [ ] 選択されたノードのTagからCustomMenuItemが正しく取得できるか確認
- [ ] ルートノード選択時にOKボタンが無効になることを確認
