---
generated_at: 2026-01-21 17:15:00
metrics:
  claims_total: 32
  claims_with_evidence: 32
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-タスクダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：32 / 32、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張が根拠付き）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/UI/TaskDialogBaseForm.vb` - 全体（1-293行目）
- E-02: `Source/UI/TaskDialogBaseForm.Designer.vb` - 全体（1-242行目）
- E-03: `Source/UI/TaskDialog.vb` - 全体（1-601行目）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 30行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TaskDialogBaseFormはタスクダイアログ風UI基底フォーム | E-01, E-04 | ○ |
| C-02 | FormBaseを継承 | E-02 (5行目) | ○ |
| C-03 | TaskDialog(Of T)がジェネリッククラス | E-03 (8行目) | ○ |
| C-04 | TitleLabel/pbIcon/paMainを含む | E-02 (18-20行目) | ○ |
| C-05 | spBottomにInputTextEdit/MenuButton/CheckBox含む | E-02 (22-24, 124-127行目) | ○ |
| C-06 | flpButtonsで標準ボタン配置 | E-02 (25, 172-182行目) | ○ |
| C-07 | blDetails/blCopyMessageボタンラベル | E-02 (26-27, 184-206行目) | ○ |
| C-08 | コンストラクタでApplyTheme呼び出し | E-01 (12行目) | ○ |
| C-09 | InputTextEditのKeyDownハンドリング | E-01 (14行目) | ○ |
| C-10 | ThemeManager.CurrentThemeChanged監視 | E-01 (15行目) | ○ |
| C-11 | ApplyThemeでBackColor/ForeColor設定 | E-01 (38-42行目) | ○ |
| C-12 | blDetails_Clickで詳細切り替え | E-01 (273-286行目) | ○ |
| C-13 | Show Details / Hide Detailsテキスト切り替え | E-01 (276-280行目) | ○ |
| C-14 | InputTextEditTextBoxKeyDownでEnter処理 | E-01 (288-292行目) | ○ |
| C-15 | TaskDialogPanel内部クラス定義 | E-01 (61-116行目) | ○ |
| C-16 | CommandButton内部クラス定義 | E-01 (118-271行目) | ○ |
| C-17 | CommandButtonはTitle+Description表示 | E-01 (254-263行目) | ○ |
| C-18 | SetWindowLongPtrで32/64bit対応 | E-01 (45-59行目) | ○ |
| C-19 | TaskIcon列挙型定義 | E-03 (580-587行目) | ○ |
| C-20 | TaskButton列挙型定義（フラグ形式） | E-03 (589-601行目) | ○ |
| C-21 | Init()でダイアログ初期化 | E-03 (43-271行目) | ○ |
| C-22 | StockIconでアイコン取得 | E-03 (81-92行目) | ○ |
| C-23 | AddCommand/AddButtonメソッド | E-03 (273-311行目) | ○ |
| C-24 | CommandClick/ButtonClickハンドラ | E-03 (325-338行目) | ○ |
| C-25 | タイムアウト機能実装 | E-03 (183-232行目) | ○ |
| C-26 | ShowCopyButtonでコピー機能設定 | E-03 (454-467行目) | ○ |
| C-27 | GetTextでダイアログ内容取得 | E-03 (479-491行目) | ○ |
| C-28 | AdjustSizeオーバーライド | E-03 (340-401行目) | ○ |
| C-29 | OnLoadでボタンサイズ調整 | E-03 (510-546行目) | ○ |
| C-30 | Show()でダイアログ表示・値返却 | E-03 (552-564行目) | ○ |
| C-31 | CommandDefinition/ButtonDefinitionクラス | E-03 (566-577行目) | ○ |
| C-32 | MaximizeBox/MinimizeBox = False | E-02 (215-216行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み
- 注意: タイムアウト機能の別スレッド処理でUIスレッドとの同期に注意が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各TaskIconがStockIconから正しく取得されることを確認
- [ ] タイムアウト機能のスレッド安全性を確認
- [ ] 詳細表示切り替え時のレイアウト更新が正しく動作することを確認
- [ ] 各テーマでの表示が正しいことを確認
