---
generated_at: 2026-01-21 10:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：3-ProcessingForm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：リアルタイム更新の定義が曖昧

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/ProcessingForm.vb` 行5-6（クラス定義、継承）
- E-02: `Source/Forms/ProcessingForm.vb` 行25-187（InitializeComponent）
- E-03: `Source/Forms/ProcessingForm.vb` 行211-258（コンストラクタ）
- E-04: `Source/Forms/ProcessingForm.vb` 行280-293（WndProc）
- E-05: `Source/Forms/ProcessingForm.vb` 行360-374（Abort, Skip）
- E-06: `Source/Forms/ProcessingForm.vb` 行190-197（_priorities定義）
- E-07: `Source/Forms/ProcessingForm.vb` 行221-252（CMSメニュー構築）
- E-08: `Source/Forms/ProcessingForm.vb` 行295-305（OnResize、トレイ最小化）
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面ID、画面名）
- E-10: `docs/code-to-docs/画面遷移図.md`（画面遷移情報）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面IDは3である | E-09 | ○ |
| C-02 | 画面名はProcessingFormである | E-09, E-01 | ○ |
| C-03 | FormBaseを継承している | E-01 (行6) | ○ |
| C-04 | pnLogHostパネルが存在する | E-02 (行36, 138-148) | ○ |
| C-05 | pnStatusHostパネルが存在する | E-02 (行37, 149-159) | ○ |
| C-06 | bnAbortボタンが存在する | E-02 (行27, 43-51) | ○ |
| C-07 | bnJobsボタンが存在する | E-02 (行30, 67-75) | ○ |
| C-08 | bnLogボタンが存在する | E-02 (行33, 101-109) | ○ |
| C-09 | mbShutdownメニューボタンが存在する | E-02 (行32, 94-99) | ○ |
| C-10 | NotifyIconが存在する | E-02 (行29) | ○ |
| C-11 | プロセス優先度選択肢が6種類ある | E-06 (行190-197) | ○ |
| C-12 | Suspendメニュー項目がある | E-07 (行223) | ○ |
| C-13 | Resumeメニュー項目がある | E-07 (行224) | ○ |
| C-14 | Abort()で確認ダイアログを表示 | E-05 (行361) | ○ |
| C-15 | Skip()で確認ダイアログを表示 | E-05 (行369) | ○ |
| C-16 | ESCキーでAbort | E-07 (行231) | ○ |
| C-17 | F6キーでJobs | E-07 (行248) | ○ |
| C-18 | F8キーでLog | E-07 (行249) | ○ |
| C-19 | SC_CLOSEでAbortにリダイレクト | E-04 (行283-286) | ○ |
| C-20 | タスクバープログレス対応 | E-04 (行288-289) | ○ |
| C-21 | システムトレイ最小化対応 | E-08 (行298-304) | ○ |
| C-22 | テーマ変更対応 | E-03 (行243-245, 257) | ○ |
| C-23 | Ctrl+Oで出力ハイライト切替 | E-07 (行235) | ○ |
| C-24 | パフォーマンス要件（リアルタイム更新） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の「リアルタイム更新」は推定値
  - 候補：性能テスト結果 / 非機能要件定義書 / ユーザー受け入れ基準

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UIコントロールの存在確認（コードで確認済み）
- 0: 低リスク - メニュー項目の確認（コードで確認済み）
- 0: 低リスク - キーボードショートカット（コードで確認済み）
- 1: 中リスク - パフォーマンス要件（根拠なし）

## 6) レビュアーチェックリスト（最小）
- [ ] ProcessingForm.vbの実装と設計書の整合性確認
- [ ] コンテキストメニュー項目の網羅性確認
- [ ] プロセス制御機能（ProcController連携）の動作確認
- [ ] シャットダウンモードの動作確認
- [ ] タスクバープログレス/システムトレイの動作確認
