---
generated_at: 2026-01-21 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-JobsForm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/JobsForm.vb` 行7-8（クラス定義、継承）
- E-02: `Source/Forms/JobsForm.vb` 行24-181（InitializeComponent）
- E-03: `Source/Forms/JobsForm.vb` 行190-254（コンストラクタ）
- E-04: `Source/Forms/JobsForm.vb` 行186-188（FileWatcher定義）
- E-05: `Source/Forms/JobsForm.vb` 行227-244（コンテキストメニュー）
- E-06: `Source/Forms/JobsForm.vb` 行389-412（イベントハンドラ）
- E-07: `Source/Forms/JobsForm.vb` 行351-362（Reload）
- E-08: `Source/Forms/JobsForm.vb` 行431-444（OnLoad）
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面ID、画面名）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面IDは4である | E-09 | ○ |
| C-02 | 画面名はJobsFormである | E-09, E-01 | ○ |
| C-03 | DialogBaseを継承している | E-01 (行8) | ○ |
| C-04 | lvリストビューが存在する | E-02 (行29, 74-86) | ○ |
| C-05 | bnStartボタンが存在する | E-02 (行27, 58-64) | ○ |
| C-06 | bnUpボタンが存在する | E-02 (行26, 49-56) | ○ |
| C-07 | bnDownボタンが存在する | E-02 (行25, 40-47) | ○ |
| C-08 | bnRemoveボタンが存在する | E-02 (行33, 138-144) | ○ |
| C-09 | bnLoadボタンが存在する | E-02 (行28, 66-72) | ○ |
| C-10 | FileSystemWatcherを使用 | E-04 (行186) | ○ |
| C-11 | Ctrl+Sで全選択 | E-05 (行227) | ○ |
| C-12 | Deleteで削除 | E-05 (行243) | ○ |
| C-13 | Ctrl+Upで上へ移動 | E-05 (行236) | ○ |
| C-14 | bnStart_ClickでProcessJobs呼び出し | E-06 (行389-404) | ○ |
| C-15 | bnLoad_ClickでLoadProject呼び出し | E-06 (行406-412) | ○ |
| C-16 | FileWatcher.Changedでリロード | E-08 (行439) | ○ |
| C-17 | FileWatcher.CreatedでReload | E-08 (行440) | ○ |
| C-18 | チェックボックス付きリスト | E-03 (行206) | ○ |
| C-19 | Job.Activeプロパティをチェックにバインド | E-03 (行208) | ○ |
| C-20 | テーマ切り替え対応 | E-03 (行252-253) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目コードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] JobsForm.vbの実装と設計書の整合性確認
- [ ] キーボードショートカットの動作確認
- [ ] FileSystemWatcherによる自動更新の動作確認
- [ ] ジョブの保存/読み込み機能の確認
