---
generated_at: 2026-01-21 10:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-CropForm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/CropForm.vb` 行6-7（クラス定義、継承）
- E-02: `Source/Forms/CropForm.vb` 行22-137（InitializeComponent）
- E-03: `Source/Forms/CropForm.vb` 行153-211（コンストラクタ）
- E-04: `Source/Forms/CropForm.vb` 行241-300（OnLoad）
- E-05: `Source/Forms/CropForm.vb` 行349-378（CropActiveSideInternal）
- E-06: `Source/Forms/CropForm.vb` 行406-427（MouseCrop）
- E-07: `Source/Forms/CropForm.vb` 行467-515（UpdateAll）
- E-08: `Source/Forms/CropForm.vb` 行554-596（GetDefaultMenuCrop）
- E-09: `Source/Forms/CropForm.vb` 行637-659（自動クロップ）
- E-10: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面ID、画面名）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面IDは5である | E-10 | ○ |
| C-02 | 画面名はCropFormである | E-10, E-01 | ○ |
| C-03 | DialogBaseを継承している | E-01 (行7) | ○ |
| C-04 | pnVideoパネルが存在する | E-02 (行27, 68-74) | ○ |
| C-05 | 境界パネル4つが存在する | E-02 (行23-26, 36-66) | ○ |
| C-06 | tbPositionトラックバーが存在する | E-02 (行28, 76-86) | ○ |
| C-07 | StatusStripが存在する | E-02 (行29-31, 88-112) | ○ |
| C-08 | Nキーでクロップリセット | E-08 (行559) | ○ |
| C-09 | Aキーで自動クロップ | E-08 (行560) | ○ |
| C-10 | Sキーでスマートクロップ | E-08 (行561) | ○ |
| C-11 | +/-キーでクロップ増減 | E-08 (行563-564) | ○ |
| C-12 | RunAutoCropメソッドが存在する | E-09 (行637-653) | ○ |
| C-13 | RunSmartCropメソッドが存在する | E-09 (行655-659) | ○ |
| C-14 | MouseCropメソッドが存在する | E-06 (行406-427) | ○ |
| C-15 | UpdateAllメソッドが存在する | E-07 (行467-515) | ○ |
| C-16 | laStatusにフレーム/時間/サイズ表示 | E-07 (行506-514) | ○ |
| C-17 | テーマ切り替え対応 | E-03 (行208-210) | ○ |
| C-18 | MOD2自動補正機能 | E-05 (行459-465) | ○ |
| C-19 | クロップ値最大80% | E-07 (行468-485) | ○ |
| C-20 | F1でヘルプ | E-08 (行592) | ○ |
| C-21 | Escapeで終了 | E-08 (行593) | ○ |
| C-22 | Oキーでオプション | E-08 (行590) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目コードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] CropForm.vbの実装と設計書の整合性確認
- [ ] キーボードショートカットの動作確認
- [ ] 自動クロップ・スマートクロップの動作確認
- [ ] MOD2補正の動作確認
- [ ] クロップ値の範囲制限（80%）の確認
