---
generated_at: 2026-01-21 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-AudioForm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/AudioForm.vb` 行10-11（クラス定義、継承）
- E-02: `Source/Forms/AudioForm.vb` 行63-500+（InitializeComponent）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面ID、画面名）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面IDは6である | E-03 | ○ |
| C-02 | 画面名はAudioFormである | E-03, E-01 | ○ |
| C-03 | DialogBaseを継承している | E-01 (行11) | ○ |
| C-04 | gbBasicグループが存在する | E-02 (行65, 120-134) | ○ |
| C-05 | mbCodecメニューボタンが存在する | E-02 (行70, 228-235) | ○ |
| C-06 | mbEncoderが存在する | E-02 (行78, 309-316) | ○ |
| C-07 | mbDecoderが存在する | E-02 (行88, 419-426) | ○ |
| C-08 | mbChannelsが存在する | E-02 (行80, 329-336) | ○ |
| C-09 | mbSamplingRateが存在する | E-02 (行72, 247-253) | ○ |
| C-10 | mbLanguageが存在する | E-02 (行71, 238-244) | ○ |
| C-11 | numBitrateが存在する | E-02 (行76, 289-296) | ○ |
| C-12 | numQualityが存在する | E-02 (行90, 441-447) | ○ |
| C-13 | numGainが存在する | E-02 (行92, 461-468) | ○ |
| C-14 | numDelayが存在する | E-02 (行96, 488-495) | ○ |
| C-15 | cbNormalizeが存在する | E-02 (行93, 470-477) | ○ |
| C-16 | cbDefaultTrackが存在する | E-02 (行85, 380-387) | ○ |
| C-17 | cbForcedTrackが存在する | E-02 (行86, 389-396) | ○ |
| C-18 | rtbCommandLineが存在する | E-02 (行110) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目コードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] AudioForm.vbの実装と設計書の整合性確認
- [ ] 各コントロールのデータバインディング確認
- [ ] コマンドライン生成ロジックの確認
