---
generated_at: 2026-01-21 11:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-AppsForm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/AppsForm.vb` 行10-12（クラス定義、継承、インターフェース）
- E-02: `Source/Forms/AppsForm.vb` 行48-408（InitializeComponent）
- E-03: `Source/Forms/AppsForm.vb` 行419-472（コンストラクタ）
- E-04: `Source/Forms/AppsForm.vb` 行515-628（ShowActivePackage）
- E-05: `Source/Forms/AppsForm.vb` 行750-805（SearchTextBox_TextChanged）
- E-06: `Source/Forms/AppsForm.vb` 行992-1061（Everything検索）
- E-07: `Source/Forms/AppsForm.vb` 行702-738（ドラッグ＆ドロップ）
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面ID、画面名）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面IDは7である | E-08 | ○ |
| C-02 | 画面名はAppsFormである | E-08, E-01 | ○ |
| C-03 | SizeSavingDialogBaseを継承している | E-01 (行11) | ○ |
| C-04 | IUpdateUIを実装している | E-01 (行12) | ○ |
| C-05 | tvツリービューが存在する | E-02 (行17, 50, 84-104) | ○ |
| C-06 | SearchTextBoxが存在する | E-02 (行23, 79, 362-369) | ○ |
| C-07 | ToolStripが存在する | E-02 (行18, 51, 106-120) | ○ |
| C-08 | tsbLaunchボタンが存在する | E-02 (行19, 52, 122-129) | ○ |
| C-09 | tsbExploreボタンが存在する | E-02 (行47, 53, 131-138) | ○ |
| C-10 | tsbWebsiteボタンが存在する | E-02 (行24, 54, 140-147) | ○ |
| C-11 | tsbDownloadボタンが存在する | E-02 (行26, 55, 149-156) | ○ |
| C-12 | tsbVersionボタンが存在する | E-02 (行27, 56, 158-165) | ○ |
| C-13 | ddbToolsドロップダウンが存在する | E-02 (行28, 57, 167-177) | ○ |
| C-14 | flpFlowLayoutPanelが存在する | E-02 (行21, 77, 338-348) | ○ |
| C-15 | Ctrl+Lでツール起動 | E-02 (行315) | ○ |
| C-16 | Ctrl+Eでフォルダを開く | E-02 (行306) | ○ |
| C-17 | Ctrl+Wでウェブサイト表示 | E-02 (行297) | ○ |
| C-18 | Ctrl+Dでダウンロード | E-02 (行288) | ○ |
| C-19 | F12でバージョン編集 | E-02 (行228) | ○ |
| C-20 | Ctrl+Pでパス編集 | E-02 (行182) | ○ |
| C-21 | Ctrl+Fでパス検索 | E-02 (行191) | ○ |
| C-22 | ShowActivePackageメソッドが存在する | E-04 (行515-628) | ○ |
| C-23 | SearchTextBox_TextChangedでフィルタリング | E-05 (行750-805) | ○ |
| C-24 | ドラッグ＆ドロップ対応 | E-07 (行702-738), E-02 (行392) | ○ |
| C-25 | Everything連携機能 | E-06 (行992-1061) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目コードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] AppsForm.vbの実装と設計書の整合性確認
- [ ] Package/PluginPackageクラスとの連携確認
- [ ] ToolUpdate処理の動作確認
- [ ] Everything検索機能の動作確認
- [ ] PATH環境変数操作の動作確認
