---
generated_at: 2026-01-21 11:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-ProfilesForm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/ProfilesForm.vb` 行4-5（クラス定義、継承）
- E-02: `Source/Forms/ProfilesForm.vb` 行30-288（InitializeComponent）
- E-03: `Source/Forms/ProfilesForm.vb` 行298-348（コンストラクタ）
- E-04: `Source/Forms/ProfilesForm.vb` 行372-385（UpdateControls）
- E-05: `Source/Forms/ProfilesForm.vb` 行387-408（lbMain_KeyDown）
- E-06: `Source/Forms/ProfilesForm.vb` 行498-531（Left/Right処理）
- E-07: `Source/Forms/ProfilesForm.vb` 行533-554（bnRestore_Click）
- E-08: `Source/Forms/ProfilesForm.vb` 行556-568（OnFormClosed）
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面ID、画面名）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面IDは8である | E-09 | ○ |
| C-02 | 画面名はProfilesFormである | E-09, E-01 | ○ |
| C-03 | DialogBaseを継承している | E-01 (行5) | ○ |
| C-04 | lbMainリストボックスが存在する | E-02 (行10, 37, 103-115) | ○ |
| C-05 | bnAddボタンが存在する | E-02 (行15, 39, 125-133) | ○ |
| C-06 | bnRemoveボタンが存在する | E-02 (行14, 34, 75-83) | ○ |
| C-07 | bnEditボタンが存在する | E-02 (行16, 41, 145-153) | ○ |
| C-08 | bnRenameボタンが存在する | E-02 (行28, 40, 135-143) | ○ |
| C-09 | bnUp/Downボタンが存在する | E-02 (行12-13, 32-33, 56-73) | ○ |
| C-10 | bnLeft/Rightボタンが存在する | E-02 (行18-19, 35-36, 85-101) | ○ |
| C-11 | bnCloneボタンが存在する | E-02 (行17, 42, 155-163) | ○ |
| C-12 | bnLoadボタンが存在する | E-02 (行11, 38, 117-123) | ○ |
| C-13 | bnRestoreボタンが存在する | E-02 (行20, 43, 165-173) | ○ |
| C-14 | Deleteキーで削除 | E-05 (行389-392) | ○ |
| C-15 | F2キーで名前変更 | E-05 (行393-396) | ○ |
| C-16 | Ctrl+Upで上へ移動 | E-05 (行397-401) | ○ |
| C-17 | Ctrl+Downで下へ移動 | E-05 (行402-406) | ○ |
| C-18 | サブメニュー構造（パイプ記号） | E-06 (行505-506, 524) | ○ |
| C-19 | デフォルト復元（Clean/Overwrite） | E-07 (行534-551) | ○ |
| C-20 | 複数選択対応 | E-02 (行113) SelectionMode.MultiExtended | ○ |
| C-21 | オーナードロー | E-02 (行106) DrawMode.OwnerDrawFixed | ○ |
| C-22 | OK時にProfiles保存 | E-08 (行559-567) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目コードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ProfilesForm.vbの実装と設計書の整合性確認
- [ ] Profileクラスとの連携確認
- [ ] サブメニュー構造（パイプ記号による階層化）の動作確認
- [ ] デフォルト復元機能（Clean/Overwrite）の動作確認
- [ ] 複数選択時の移動・削除動作確認
