---
generated_at: 2026-01-21 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-MacrosForm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/MacrosForm.vb` 行6-7（クラス定義、継承）
- E-02: `Source/Forms/MacrosForm.vb` 行25-225（InitializeComponent）
- E-03: `Source/Forms/MacrosForm.vb` 行229-242（コンストラクタ）
- E-04: `Source/Forms/MacrosForm.vb` 行282-312（Populate）
- E-05: `Source/Forms/MacrosForm.vb` 行367-380（lv_SelectedIndexChanged）
- E-06: `Source/Forms/MacrosForm.vb` 行382-388（bnCopy_Click）
- E-07: `Source/Forms/MacrosForm.vb` 行322-360（KeyDown）
- E-08: `Source/Forms/MacrosForm.vb` 行318-320（HelpRequested）
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面ID、画面名）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面IDは9である | E-09 | ○ |
| C-02 | 画面名はMacrosFormである | E-09, E-01 | ○ |
| C-03 | DialogBaseを継承している | E-01 (行7) | ○ |
| C-04 | lvリストビューが存在する | E-02 (行10, 26, 43-53) | ○ |
| C-05 | stb検索ボックスが存在する | E-02 (行11, 27, 55-64) | ○ |
| C-06 | lName/lValue/lDescriptionラベルが存在する | E-02 (行12-14, 28-30, 66-90, 166-176) | ○ |
| C-07 | bnCopyボタンが存在する | E-02 (行17, 33, 129-136) | ○ |
| C-08 | Tileビュー表示 | E-03 (行232) View.Tile | ○ |
| C-09 | Explorerテーマ適用 | E-03 (行236) Native.SetWindowTheme | ○ |
| C-10 | Populateでマクロ一覧取得 | E-04 (行288) Macro.GetMacros | ○ |
| C-11 | 検索フィルタリング機能 | E-04 (行293) Match() | ○ |
| C-12 | マクロ値展開 | E-05 (行373) Macro.Expand | ○ |
| C-13 | クリップボードコピー | E-06 (行383) Clipboard.SetText | ○ |
| C-14 | コピー時太字フィードバック | E-06 (行384-387) SetFontStyle, Sleep(300) | ○ |
| C-15 | Enterでコピー＆閉じる | E-07 (行324-326) | ○ |
| C-16 | Up/Downでリスト選択移動 | E-07 (行337-358) | ○ |
| C-17 | ダブルクリックでコピー＆閉じる | 行362-365 | ○ |
| C-18 | F1でWikiヘルプ表示 | E-08 (行319) g.ShowWikiPage | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目コードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] MacrosForm.vbの実装と設計書の整合性確認
- [ ] Macroクラス（GetMacros, Expand）との連携確認
- [ ] 検索フィルタリングの動作確認
- [ ] クリップボードコピーのフィードバック表示確認
- [ ] キーボードナビゲーション（Enter/Up/Down）の動作確認
