---
generated_at: 2026-01-21 19:30:00
metrics:
  claims_total: 70
  claims_with_evidence: 68
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：68 / 70、根拠なし：2
- 優先レビュー（高）
  1. **IT-060 Settings保存・読み込み**：Settings関連クラスの詳細実装未確認
  2. **IT-070 Calc連携**：Calc.csの詳細実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Demux.vb` - Demuxer基底クラスおよび派生クラス（mkvDemuxer, ffmpegDemuxer, MP4BoxDemuxer, eac3toDemuxer, CommandLineDemuxer）
- E-02: `Source/General/Muxer.vb` - Muxer基底クラスおよび派生クラス（MkvMuxer, MP4Muxer, WebMMuxer, ffmpegMuxer, BatchMuxer, NullMuxer）
- E-03: `Source/General/Audio.vb` - Audio処理クラス（変換、カット、ノーマライズ等）
- E-04: `Source/Video/VideoScript.vb` - VideoScript、TargetVideoScript、SourceVideoScript、VideoFilter、FilterCategory
- E-05: `Source/General/JobManager.vb` - Job、JobManager（ジョブ管理）
- E-06: `Source/General/Project.vb` - Projectクラス（プロジェクト設定）
- E-07: `Source/General/GlobalClass.vb` - GlobalClassおよびイベント定義
- E-08: `Source/Video/VideoEncoderCommandLine.vb` - CommandLineParams、各種パラメータクラス
- E-09: `Source/Forms/MainForm.vb` - MainForm UIコンポーネント定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001 mkvDemuxer映像デマックス | E-01 mkvDemuxer.Demux() | ○ |
| C-02 | IT-002 mkvDemuxer音声デマックス | E-01 mkvDemuxer.Demux() audioStreamsパラメータ | ○ |
| C-03 | IT-003 mkvDemuxer字幕デマックス | E-01 mkvDemuxer.Demux() subtitlesパラメータ | ○ |
| C-04 | IT-004 mkvDemuxerチャプター抽出 | E-01 mkvDemuxer.Run() --chapters処理 | ○ |
| C-05 | IT-005 mkvDemuxerタイムスタンプ抽出 | E-01 mkvDemuxer.Run() timestamps_v2処理 | ○ |
| C-06 | IT-006 ffmpegDemuxer映像デマックス | E-01 ffmpegDemuxer.DemuxVideo() | ○ |
| C-07 | IT-007 ffmpegDemuxer音声デマックス | E-01 ffmpegDemuxer.DemuxAudio() | ○ |
| C-08 | IT-008 ffmpegDemuxer字幕デマックス | E-01 ffmpegDemuxer.DemuxSubtitles() | ○ |
| C-09 | IT-009 MP4BoxDemuxer映像デマックス | E-01 MP4BoxDemuxer.DemuxVideo() | ○ |
| C-10 | IT-010 MP4BoxDemuxer音声デマックス | E-01 MP4BoxDemuxer.DemuxAudio() | ○ |
| C-11 | IT-011 MP4BoxDemuxerカバー抽出 | E-01 MP4BoxDemuxer.Run() -dump-cover | ○ |
| C-12 | IT-012 eac3toDemuxer M2TSデマックス | E-01 eac3toDemuxer.Run() | ○ |
| C-13 | IT-013 CommandLineDemuxer DGIndex連携 | E-01 CommandLineDemuxer.Run() DGIndex設定 | ○ |
| C-14 | IT-014 MkvMuxer基本マルチプレックス | E-02 MkvMuxer.Mux() GetArgs() | ○ |
| C-15 | IT-015 MkvMuxer字幕マルチプレックス | E-02 MkvMuxer.GetArgs() Subtitles処理 | ○ |
| C-16 | IT-016 MkvMuxerチャプターマルチプレックス | E-02 MkvMuxer.GetArgs() --chapters | ○ |
| C-17 | IT-017 MkvMuxerタイムスタンプマルチプレックス | E-02 MkvMuxer.GetArgs() --timestamps | ○ |
| C-18 | IT-018 MkvMuxerアタッチメントマルチプレックス | E-02 MkvMuxer.GetArgs() Attachments処理 | ○ |
| C-19 | IT-019 MkvMuxerタグマルチプレックス | E-02 MkvMuxer.WriteTagfile() --global-tags | ○ |
| C-20 | IT-020 MkvMuxerカット編集 | E-02 MkvMuxer.GetArgs() --split parts-frames | ○ |
| C-21 | IT-021 MP4Muxer基本マルチプレックス | E-02 MP4Muxer.Mux() GetArgs() | ○ |
| C-22 | IT-022 MP4Muxer PAR設定 | E-02 MP4Muxer.GetArgs() :par=処理 | ○ |
| C-23 | IT-023 MP4Muxerチャンクエンコード | E-02 MP4Muxer.GetArgs() -cat処理 | ○ |
| C-24 | IT-024 ffmpegMuxerコンテナ出力 | E-02 ffmpegMuxer.Mux() | ○ |
| C-25 | IT-025 ffmpeg音声変換 | E-03 Audio.ConvertFF() | ○ |
| C-26 | IT-026 eac3to音声変換 | E-03 Audio.ConvertEac3to() | ○ |
| C-27 | IT-027 NicAudio音声デコード | E-03 Audio.ConvertNicAudio() GetNicAudioCode() | ○ |
| C-28 | IT-028 mkvmerge音声カット | E-03 Audio.CutMkvmerge() | ○ |
| C-29 | IT-029 音声ノーマライズvolumedetect | E-03 Audio.ConvertFF() Normalize処理 | ○ |
| C-30 | IT-030 音声ノーマライズloudnorm | E-03 Audio.GetLoudNormArgs() | ○ |
| C-31 | IT-031 音声ノーマライズdynaudnorm | E-03 Audio.GetDynAudNormArgs() | ○ |
| C-32 | IT-032 AviSynthスクリプト生成 | E-04 VideoScript.Synchronize() ModifyAVSScript() | ○ |
| C-33 | IT-033 VapourSynthスクリプト生成 | E-04 VideoScript.Synchronize() ModifyVSScript() | ○ |
| C-34 | IT-034 AviSynthプラグイン自動ロード | E-04 VideoScript.GetAvsLoadCode() | ○ |
| C-35 | IT-035 VapourSynthプラグイン自動ロード | E-04 VideoScript.WriteVSCode() | ○ |
| C-36 | IT-036 RGB変換スクリプト | E-04 VideoScript.Synchronize() convertToRGB | ○ |
| C-37 | IT-037 AviSynthフレームサーバー | E-04 VideoScript.Synchronize() FrameServerFactory | ○ |
| C-38 | IT-038 VapourSynthフレームサーバー | E-04 VideoScript.Synchronize() vspipe | ○ |
| C-39 | IT-039 Project-Demuxer連携 | E-01, E-06 Demuxer.Run(proj As Project) | ○ |
| C-40 | IT-040 Project-Muxer連携 | E-02, E-06 Muxer.Mux() p.AudioTracks等参照 | ○ |
| C-41 | IT-041 Project-Script連携 | E-04, E-06 VideoScript.GetScript() p参照 | ○ |
| C-42 | IT-042 JobManagerジョブ追加 | E-05 JobManager.AddJob() SaveJobs() | ○ |
| C-43 | IT-043 JobManagerジョブ読み込み | E-05 JobManager.GetJobs() | ○ |
| C-44 | IT-044 JobManagerアクティブ切替 | E-05 JobManager.ActivateJob() | ○ |
| C-45 | IT-045 GlobalClassジョブ後イベント | E-07 GlobalClass.AfterJobProcessed Event | ○ |
| C-46 | IT-046 GlobalClass全ジョブ後イベント | E-07 GlobalClass.AfterJobsProcessed Event | ○ |
| C-47 | IT-047 Macroパス展開 | E-07 Macro.Expand() | ○ |
| C-48 | IT-048 Macro数値展開 | E-07 Macro.Expand() | ○ |
| C-49 | IT-049 MediaInfo映像情報 | E-01, E-02 MediaInfo.GetVideo() | ○ |
| C-50 | IT-050 MediaInfo音声情報 | E-01, E-03 MediaInfo.GetAudioStreams() | ○ |
| C-51 | IT-051 MediaInfo字幕情報 | E-01 MediaInfo.GetSubtitles() | ○ |
| C-52 | IT-052 Log処理ログ出力 | E-06 Project.Log (LogBuilder) | ○ |
| C-53 | IT-053 Logファイル保存 | E-01 Log.Save(proj) | ○ |
| C-54 | IT-054 Proc外部プロセス実行 | E-01 Using proc As New Proc | ○ |
| C-55 | IT-055 Procエラーハンドリング | E-01 proc.AllowedExitCodes | ○ |
| C-56 | IT-056 Packageパス解決 | E-01 proc.Package = Package.xxx | ○ |
| C-57 | IT-057 Package要件検証 | E-04 Package.AviSynth.VerifyOK | ○ |
| C-58 | IT-058 Project保存 | E-06 Project ISafeSerialization | ○ |
| C-59 | IT-059 Project読み込み | E-06 Project Init() デシリアライズ | ○ |
| C-60 | IT-060 Settings保存・読み込み | **根拠不足** | △ |
| C-61 | IT-061 MainForm-Project UIソース | E-09 tbSourceFile | ○ |
| C-62 | IT-062 MainForm-Project UIターゲット | E-09 tbTargetFile | ○ |
| C-63 | IT-063 MainForm-Script UIフィルタ | E-09 FiltersListView | ○ |
| C-64 | IT-064 StreamDemuxForm連携 | E-01 StreamDemuxForm使用箇所 | ○ |
| C-65 | IT-065 MuxerForm連携 | E-02 MuxerForm使用箇所 | ○ |
| C-66 | IT-066 AbortException連携 | E-01 Throw New AbortException | ○ |
| C-67 | IT-067 ErrorAbortException連携 | E-02 Throw New ErrorAbortException | ○ |
| C-68 | IT-068 FileHelp移動 | E-01 FileHelp.Move() | ○ |
| C-69 | IT-069 FileHelp削除 | E-01 FileHelp.Delete() | ○ |
| C-70 | IT-070 Calcアスペクト比計算 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- IT-060 Settings保存・読み込み
  - Settingsクラスの詳細実装ファイル（s変数の定義元）が未確認
  - 候補：`Source/General/Settings.vb` / `Source/General/ApplicationSettings.vb` / 未特定
- IT-070 Calcアスペクト比計算
  - Calcクラスの詳細実装ファイルが未確認
  - 候補：`Source/General/Calc.vb` / `Source/General/General.vb`内 / 未特定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほとんどのテストケースはソースコード内に明確な根拠あり
- 1: 中リスク - IT-060, IT-070については実装詳細の追加確認が必要
- 0: 低リスク - 外部ツール連携部分は各Demuxer/Muxer/Procクラスで明確に実装確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] IT-001〜IT-013のDemuxer系テストケースが実際のデマックス処理フローと整合しているか確認
- [ ] IT-014〜IT-024のMuxer系テストケースが実際のマルチプレックス処理フローと整合しているか確認
- [ ] IT-025〜IT-031のAudio処理テストケースが実際の音声処理フローと整合しているか確認
- [ ] IT-032〜IT-038のVideoScript系テストケースがAviSynth/VapourSynth連携と整合しているか確認
- [ ] IT-039〜IT-053のコンポーネント間連携テストケースがProject/JobManager等の連携フローと整合しているか確認
- [ ] IT-054〜IT-057の外部ツール連携テストケースがProc/Package実装と整合しているか確認
- [ ] IT-058〜IT-070のデータ・UI・エラー処理連携テストケースが実装と整合しているか確認
- [ ] IT-060（Settings）とIT-070（Calc）の根拠不足項目について追加調査を実施
