---
generated_at: 2026-01-21 16:30:00
metrics:
  claims_total: 108
  claims_with_evidence: 108
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：108 / 108、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての通知定義がソースコードから直接抽出されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/General.vb` - MsgInfo, MsgError, MsgWarn, MsgQuestion, MsgOK, Msg関数の定義
- E-02: `Source/UI/TaskDialog.vb` - TaskDialogクラス、TaskIcon、TaskButton列挙型の定義
- E-03: `Source/General/GlobalClass.vb` - 各種通知の使用箇所（プロジェクト/ソースファイル関連エラー等）
- E-04: `Source/General/ToolUpdate.vb` - ダウンロード/更新関連の通知使用箇所
- E-05: `Source/General/StaxRipUpdate.vb` - アプリケーション更新関連の通知使用箇所
- E-06: `Source/Forms/MainForm.vb` - メインフォームでの各種通知使用箇所
- E-07: `Source/Forms/AppsForm.vb` - ツール管理画面での通知使用箇所
- E-08: `Source/Forms/PreviewForm.vb` - プレビュー画面でのエラー通知使用箇所
- E-09: `Source/Forms/AudioForm.vb` - オーディオ設定画面での通知使用箇所
- E-10: `Source/Forms/ProcessingForm.vb` - 処理フォームでの確認ダイアログ使用箇所
- E-11: `Source/Forms/eac3toForm.vb` - eac3toツール関連の通知使用箇所
- E-12: `Source/Forms/UpdateForm.vb` - 更新フォームでの通知使用箇所
- E-13: `Source/Video/VideoScript.vb` - ビデオスクリプト関連のエラー通知使用箇所
- E-14: `Source/Video/VideoEncoderCommandLine.vb` - エンコーダオプション関連のエラー通知
- E-15: `Source/Video/FrameServer.vb` - ファイル操作関連のエラー通知
- E-16: `Source/General/Project.vb` - プロジェクト管理関連の通知使用箇所
- E-17: `Source/General/Extras.vb` - HDRメタデータ関連の通知使用箇所
- E-18: `Source/General/Proc.vb` - プロセス実行関連のエラー通知
- E-19: `Source/General/Documentation.vb` - ヒント/チップ通知の使用箇所
- E-20: `Source/General/GlobalCommands.vb` - グローバルコマンド関連の通知使用箇所
- E-21: `Source/UI/CustomMenuEditor.vb` - メニューエディタでの通知使用箇所
- E-22: `Source/UI/ExtenderProviders.vb` - 入力検証関連の警告通知
- E-23: `Source/UI/ImageUtils.vb` - フォント関連の警告通知
- E-24: `Source/UI/Menu.vb` - メニュー操作関連の通知使用箇所
- E-25: `Source/Controls/CommandLineControl.vb` - コマンドライン制御での通知使用箇所
- E-26: `Source/Forms/CommandLineForm.vb` - コマンドラインフォームでの通知使用箇所
- E-27: `Source/Forms/CommandLineDemuxForm.vb` - デマクサ設定フォームでの警告通知
- E-28: `Source/Forms/CommandLineAudioEncoderForm.vb` - オーディオエンコーダフォームでの通知
- E-29: `Source/Forms/MainForm_ShowSettings.vb` - 設定画面での通知使用箇所
- E-30: `Source/Forms/MainForm_ShowOptions.vb` - オプション画面での警告通知
- E-31: `Source/Forms/MainForm_Assistant.vb` - アシスタント機能での通知使用箇所
- E-32: `Source/Forms/CodeEditor.vb` - コードエディタでの通知使用箇所
- E-33: `Source/Forms/ProfilesForm.vb` - プロファイル管理での確認ダイアログ
- E-34: `Source/Forms/SourceFilesForm.vb` - ソースファイルフォームでの確認ダイアログ
- E-35: `Source/Forms/VideoComparisonForm.vb` - ビデオ比較フォームでのエラー通知
- E-36: `Source/Forms/CropForm.vb` - クロップフォームでのエラー通知
- E-37: `Source/UI/Controls/ListViewEx.vb` - リストビュー操作での確認ダイアログ
- E-38: `Source/Controls/FiltersListView.vb` - フィルタリストでの確認ダイアログ
- E-39: `Source/Controls/PreprocessingControl.vb` - 前処理制御での確認ダイアログ
- E-40: `Source/General/Misc.vb` - MsgIcon列挙型の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MsgInfo - 汎用情報メッセージ表示 | E-01 (行1216-1220) | ○ |
| C-02 | MsgError - エラーメッセージ表示 | E-01 (行1222-1241) | ○ |
| C-03 | MsgWarn - 警告メッセージ表示 | E-01 (行1245-1255) | ○ |
| C-04 | MsgQuestion - 質問ダイアログ表示 | E-01 (行1261-1272) | ○ |
| C-05 | MsgOK - OK/Cancel確認ダイアログ | E-01 (行1257-1259) | ○ |
| C-06 | Msg - 汎用メッセージダイアログ | E-01 (行1274-1282) | ○ |
| C-07 | Download Complete通知 | E-12 (行21) | ○ |
| C-08 | Download failed!通知 | E-05 (行148) | ○ |
| C-09 | Download was canceled or failed.通知 | E-04 (行62) | ○ |
| C-10 | Downloaded file is missing.通知 | E-04 (行58) | ○ |
| C-11 | Extraction failed通知 | E-04 (行84) | ○ |
| C-12 | File missing after extraction.通知 | E-04 (行120) | ○ |
| C-13 | Update was canceled.通知 | E-04 (行154, 180) | ○ |
| C-14 | No update available.通知 | E-05 (行133, 136) | ○ |
| C-15 | Already Running the Latest Version!通知 | E-12 (行27, 33) | ○ |
| C-16 | Script Error通知 | E-03, E-06, E-08, E-32 | ○ |
| C-17 | The first filter must be a source filter.通知 | E-13 (行774) | ○ |
| C-18 | Could not move file通知 | E-15 (行529) | ○ |
| C-19 | Project file not found!通知 | E-03 (行482) | ○ |
| C-20 | Source file not found!通知 | E-03 (行494, 504) | ○ |
| C-21 | No active filter of category 'Source' found.警告 | E-03 (行809) | ○ |
| C-22 | Unicode filenames are not supported by AviSynth通知 | E-03 (行829) | ○ |
| C-23 | Unable to play audio.通知 | E-03 (行841) | ○ |
| C-24 | Failed to create a temp directory.警告 | E-03 (行1361) | ○ |
| C-25 | Windows Terminal not found!警告 | E-03 (行1398) | ○ |
| C-26 | Failed to load source.警告 | E-03 (行1427) | ○ |
| C-27 | Long Path Support was not enabled!通知 | E-03 (行1780, 1784) | ○ |
| C-28 | option not found通知 | E-14 (行105) | ○ |
| C-29 | No chapter file found.通知 | E-08 (行957) | ○ |
| C-30 | Follow assistant message通知 | E-08 (行720) | ○ |
| C-31 | All Good!通知 | E-20 (行271) | ○ |
| C-32 | Will be reseted on next startup.通知 | E-20 (行935) | ○ |
| C-33 | Functionality is no longer available.通知 | E-20 (行941) | ○ |
| C-34 | Filename contains invalid characters.警告 | E-16 (行292) | ○ |
| C-35 | Only idx, srt and ass file types are supported.通知 | E-16 (行313) | ○ |
| C-36 | Only idx, srt, ass and sup file types are supported.通知 | E-16 (行350) | ○ |
| C-37 | No HDR Metadata Key was Found通知 | E-17 (行179) | ○ |
| C-38 | Command already exists.警告 | E-01 (行1106) | ○ |
| C-39 | Parameter mismatch, for the command通知 | E-01 (行1134) | ○ |
| C-40 | Message was copied to clipboard.通知 | E-02 (行462) | ○ |
| C-41 | Key detached and assigned通知 | E-21 (行917) | ○ |
| C-42 | is no valid input.警告 | E-22 (行40) | ○ |
| C-43 | Correct font was not found警告 | E-23 (行38) | ○ |
| C-44 | Tip通知 | E-19 (行429) | ○ |
| C-45 | eac3to failed with error code通知 | E-11 (行752) | ○ |
| C-46 | eac3to output was empty警告 | E-11 (行786) | ○ |
| C-47 | 3D demuxing isn't supported.通知 | E-11 (行789) | ○ |
| C-48 | Command Line was copied.通知 | E-26 (行57) | ○ |
| C-49 | Please restart StaxRip.通知 | E-29 (行515) | ○ |
| C-50 | The profile was saved.通知 | E-09, E-28 (行1151, 531) | ○ |
| C-51 | Project file not found.警告 | E-06 (行1636) | ○ |
| C-52 | No playlist directory found.警告 | E-06 (行2320, 2374) | ○ |
| C-53 | Recovery not saved!警告 | E-06 (行2446) | ○ |
| C-54 | The file VIDEO_TS.VOB can't be opened.警告 | E-06 (行2468) | ○ |
| C-55 | Opening files from an optical drive requires temp folder警告 | E-06 (行2669) | ○ |
| C-56 | A template cannot be created警告 | E-06 (行3791, 3837) | ○ |
| C-57 | Please follow the assistant.警告 | E-06 (行4208) | ○ |
| C-58 | Assistant warning cannot be skipped.警告 | E-06 (行4086) | ○ |
| C-59 | Job added通知 | E-06 (行4217) | ○ |
| C-60 | Defaults were restored.通知 | E-06, E-24, E-25 | ○ |
| C-61 | The category was recreated.警告 | E-06 (行4315) | ○ |
| C-62 | No subtitles found.通知 | E-06 (行4468) | ○ |
| C-63 | Error parsing argument警告 | E-06 (行4943) | ○ |
| C-64 | Manual Merging通知 | E-06 (行5131) | ○ |
| C-65 | The temp folder could not be created.通知 | E-06 (行5260) | ○ |
| C-66 | Only fixed local drives are supported as temp dir.通知 | E-06 (行5266) | ○ |
| C-67 | Invalid format警告 | E-06 (行5641) | ○ |
| C-68 | Source filter returned invalid parameters通知 | E-06 (行5693) | ○ |
| C-69 | AviSynth installation not found通知 | E-06 (行5934) | ○ |
| C-70 | VapourSynth installation not found通知 | E-06 (行5939) | ○ |
| C-71 | Compatibility problem!警告 | E-06 (行6089) | ○ |
| C-72 | All tools have OK status!通知 | E-07 (行914) | ○ |
| C-73 | All required tools have OK status!通知 | E-07 (行934) | ○ |
| C-74 | Custom paths within the startup folder are not permitted通知 | E-07 (行955, 1048) | ○ |
| C-75 | No custom paths defined.通知 | E-07 (行984) | ○ |
| C-76 | File not found通知 | E-07 (行1055) | ○ |
| C-77 | Nothing found.通知 | E-07 (行1059) | ○ |
| C-78 | auto update feature does not support MediaFire通知 | E-07 (行1106) | ○ |
| C-79 | The path was copied to the clipboard.通知 | E-07 (行1152) | ○ |
| C-80 | Folder was added to PATH通知 | E-07 (行1177) | ○ |
| C-81 | Folder was removed from PATH通知 | E-07 (行1183) | ○ |
| C-82 | Folder is already in PATH通知 | E-07 (行1173) | ○ |
| C-83 | Folder is not in PATH通知 | E-07 (行1185) | ○ |
| C-84 | demuxer name does not match警告 | E-27 (行429) | ○ |
| C-85 | Are you sure you want to reset your settings?確認 | E-03 (行104) | ○ |
| C-86 | Delete current files?確認 | E-04 (行134) | ○ |
| C-87 | Copy new files?確認 | E-04 (行167) | ○ |
| C-88 | Do you want to open the log file?確認 | E-03 (行1625) | ○ |
| C-89 | Do you want to report an issue or bug?確認 | E-03 (行1632) | ○ |
| C-90 | The input format isn't supported警告 | E-09 (行1657) | ○ |
| C-91 | Source file is missing!警告 | E-09 (行1668) | ○ |
| C-92 | Remove Selection?確認 | E-37 (行452) | ○ |
| C-93 | Include sub folders?確認 | E-34 (行250) | ○ |
| C-94 | file type will be deleted警告 | E-30 (行904) | ○ |
| C-95 | Restore the default templates?確認 | E-06 (行1482) | ○ |
| C-96 | Are you sure you want to open the file確認 | E-06 (行2462) | ○ |
| C-97 | active job for this project already exists確認 | E-06 (行4111) | ○ |
| C-98 | Abort processing?確認 | E-10 (行361) | ○ |
| C-99 | Skip current process?確認 | E-10 (行369) | ○ |
| C-100 | overwrite?確認 | E-33 (行438) | ○ |
| C-101 | confirm to reset the entire menu確認 | E-21 (行961) | ○ |
| C-102 | Restore defaults?確認 | E-25, E-24, E-39 | ○ |
| C-103 | Remove?確認 | E-32 (行118) | ○ |
| C-104 | Find Path feature requires Everything確認 | E-07 (行1017) | ○ |
| C-105 | Experimental feature not working for all tools確認 | E-07 (行1110) | ○ |
| C-106 | Import command line from clipboard?確認 | E-26 (行62) | ○ |
| C-107 | Confirm to process the track.確認 | E-06 (行5837) | ○ |
| C-108 | Confirm to process ALL audio tracks.確認 | E-06 (行5857) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての通知定義がソースコードから直接抽出されました
- プロジェクト内で定義されている通知関数（MsgInfo, MsgError, MsgWarn, MsgQuestion, MsgOK, Msg）とその使用箇所を網羅的に調査しました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての通知定義がソースコード内で確認済み
- 注意点：
  - TaskDialog クラスを使用したカスタム通知が他にも存在する可能性があります
  - MessageBox.Show を直接使用している箇所が1件確認されました（ToolUpdate.vb:49-51）

## 6) レビュアーチェックリスト（最小）
- [ ] 通知カテゴリ（情報/エラー/警告/質問/確認）の分類が適切か確認
- [ ] 通知名がソースコードのメッセージ内容と一致しているか確認
- [ ] 各通知の使用箇所（備考欄）が正確か確認
- [ ] MessageBox.Show を使用した通知が漏れていないか確認
- [ ] TaskDialog を直接使用したカスタム通知が漏れていないか確認
