# 通知設計書 1-MsgInfo

## 概要

本ドキュメントは、StaxRipアプリケーションにおける汎用情報メッセージ通知「MsgInfo」の設計仕様を定義する。MsgInfoは、ユーザーに対して情報レベルのメッセージをタスクダイアログ形式で表示するための基本的な通知機能である。

### 本通知の処理概要

MsgInfo通知は、アプリケーション内で発生する様々な情報イベントをユーザーに伝達するための汎用的な通知メカニズムである。

**業務上の目的・背景**：アプリケーションの操作結果や処理完了、ステータス変更などの重要な情報をユーザーにフィードバックするために必要である。これにより、ユーザーは現在の処理状況や操作結果を把握し、次のアクションを判断できる。例えば、設定の保存完了、更新確認の結果、クリップボードへのコピー完了など、様々な場面で使用される。

**通知の送信タイミング**：ユーザー操作の完了時、処理の正常終了時、または情報提供が必要な任意のタイミングで送信される。具体的には、MsgInfo関数が呼び出された瞬間に同期的に表示される。

**通知の受信者**：現在アプリケーションを操作しているユーザー。タスクダイアログはモーダルダイアログとして表示されるため、ユーザーは必ずこの通知を確認することになる。

**通知内容の概要**：タイトルとオプションのコンテンツ（詳細メッセージ）で構成される。Infoアイコン（青い情報マーク）が表示され、OKボタンのみが配置される。

**期待されるアクション**：ユーザーはメッセージ内容を確認し、OKボタンをクリックしてダイアログを閉じる。特別なアクションは不要だが、メッセージ内容に応じて次の操作を決定する参考情報となる。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

現在のフォアグラウンドウィンドウのオーナーとして表示される。アプリケーションのメインスレッドで実行され、呼び出し元のフォームを親ウィンドウとしてモーダル表示される。

## 通知テンプレート

### メール通知の場合

該当なし（アプリ内通知のため）

### 本文テンプレート

```
[タイトル]
{title パラメータの値}

[コンテンツ]（オプション）
{content パラメータの値}

[アイコン]
Info（青い情報アイコン）

[ボタン]
OK
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| title | 通知のタイトルテキスト | 呼び出し元から渡されるObject型（ToString変換） | Yes |
| content | 通知の詳細テキスト | 呼び出し元から渡されるObject型（ToString変換） | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | MsgInfo関数の呼び出し | なし（常に表示） | コード内でMsgInfo()が呼び出された時点で即座に表示 |
| 画面操作 | 更新確認完了 | 更新が存在しない場合 | StaxRipUpdate.CheckForUpdateAsyncで更新なし時に"No update available."を表示 |
| 画面操作 | クリップボードコピー完了 | コピー成功時 | TaskDialogのCopyMessage機能で"Message was copied to clipboard."を表示 |
| 画面操作 | ダウンロード完了 | ダウンロード成功時 | StaxRipUpdate.OnDownloadCompleteで"Download succeeded!"を表示 |
| 画面操作 | 更新キャンセル | ユーザーによるキャンセル時 | ToolUpdate.DeleteOldFiles/CopyFilesで"Update was canceled."を表示 |
| 画面操作 | ダウンロードキャンセル | ダウンロード失敗/キャンセル時 | ToolUpdate.Downloadで"Download was canceled or failed."を表示 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | MsgInfoは呼び出し時に常に表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[MsgInfo呼び出し] --> B[パラメータ検証]
    B --> C[titleをString変換]
    C --> D[contentをString変換]
    D --> E[Msg関数呼び出し]
    E --> F[TaskDialogインスタンス生成]
    F --> G[Icon = TaskIcon.Info設定]
    G --> H[Title設定]
    H --> I[Content設定]
    I --> J[Buttons = TaskButton.OK設定]
    J --> K[Show呼び出し]
    K --> L[ダイアログ表示]
    L --> M{ユーザー操作}
    M -->|OK| N[ダイアログクローズ]
    N --> O[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（MsgInfoはデータベースを参照しない）

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

該当なし

#### 送信ログテーブル

該当なし（MsgInfoは送信ログを記録しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 表示失敗 | ウィンドウハンドル取得失敗 | スクリーン中央に表示 |
| パラメータエラー | titleがnull | ToString()でnull文字列として処理 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（アプリケーション動作中は常に表示可能）

## セキュリティ考慮事項

- 表示される情報に個人情報や機密情報が含まれないよう、呼び出し元での配慮が必要
- ダイアログはモーダル表示のため、他の操作を一時的にブロックする

## 備考

- MsgInfoはMainModuleに定義されたグローバル関数であり、アプリケーション全体から呼び出し可能
- 内部的にはMsg関数を経由してTaskDialog(Of DialogResult)を使用
- Visual Basicの型変換により、任意のオブジェクトをタイトルやコンテンツとして渡すことが可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

MsgInfoは単純な関数呼び出しで動作するため、主要なデータ構造はTaskDialog(Of T)クラスとTaskIcon/TaskButton列挙型である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | TaskDialog.vb | `Source/UI/TaskDialog.vb` | TaskDialog(Of T)クラスの構造、TaskIcon列挙型（行580-587）、TaskButton列挙型（行589-601）を確認 |

**読解のコツ**: TaskDialogはジェネリッククラスとして実装されており、戻り値の型をTで指定できる。MsgInfoではDialogResultを使用。

#### Step 2: エントリーポイントを理解する

MsgInfo関数の定義と、内部で呼び出されるMsg関数の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | General.vb | `Source/General/General.vb` | MsgInfo関数の定義（行1216-1220）、Msg関数の定義（行1274-1282） |

**主要処理フロー**:
1. **行1216-1220**: MsgInfo関数 - title/contentをString変換し、Msg関数を呼び出し
2. **行1217**: title?.ToStringでnull安全な文字列変換
3. **行1218**: content?.ToStringでnull安全な文字列変換
4. **行1219**: Msg関数呼び出し（TaskIcon.Info, TaskButton.OK指定）

#### Step 3: TaskDialogの初期化と表示処理を理解する

TaskDialogクラスのInit()メソッドとShow()メソッドの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TaskDialog.vb | `Source/UI/TaskDialog.vb` | Init()メソッド（行43-271）、Show()メソッド（行552-564） |

**主要処理フロー**:
- **行43-54**: ウィンドウ幅とタイトル/コンテンツの初期設定
- **行77-92**: アイコン設定（TaskIcon.Infoの場合、StockIcon.Infoを使用）
- **行152-178**: ボタン定義の処理とFlowLayoutPanelへの追加
- **行552-564**: Show()メソッドでInit()呼び出し後、ShowDialog()でモーダル表示

### プログラム呼び出し階層図

```
MsgInfo(title, content)  [General.vb:1216]
    |
    +-- Msg(title, content, TaskIcon.Info, TaskButton.OK)  [General.vb:1274]
           |
           +-- New TaskDialog(Of DialogResult)()  [TaskDialog.vb:8]
           |
           +-- TaskDialog.Show()  [TaskDialog.vb:552]
                  |
                  +-- TaskDialog.Init()  [TaskDialog.vb:43]
                  |      |
                  |      +-- StockIcon.GetImage()  [TaskDialog.vb:87]
                  |      |
                  |      +-- AddButton()  [TaskDialog.vb:295]
                  |
                  +-- ShowDialog()  [TaskDialog.vb:557]
```

### データフロー図

```
[入力]               [処理]                    [出力]

title (Object) ───> ToString()変換 ───> TaskDialog.Title設定
                          |
content (Object) ──> ToString()変換 ───> TaskDialog.Content設定
                          |
TaskIcon.Info ─────> Icon設定 ─────────> pbIcon.Image設定
                          |
TaskButton.OK ─────> Buttons設定 ──────> flpButtons.Controls追加
                          |
                    ShowDialog() ─────> [画面表示] ───> DialogResult.OK
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| General.vb | `Source/General/General.vb` | ソース | MsgInfo/Msg関数の定義（MainModule内） |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | TaskDialog(Of T)クラス、TaskIcon/TaskButton列挙型の定義 |
| TaskDialogBaseForm.vb | `Source/UI/TaskDialogBaseForm.vb` | ソース | TaskDialogの基底フォームクラス |
| StockIcon.vb | `Source/UI/StockIcon.vb` | ソース | システムアイコン取得ユーティリティ |
| StaxRipUpdate.vb | `Source/General/StaxRipUpdate.vb` | ソース | MsgInfoの使用例（更新確認関連） |
| ToolUpdate.vb | `Source/General/ToolUpdate.vb` | ソース | MsgInfoの使用例（ツール更新関連） |
