# 通知設計書 100-プロファイル上書き確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるプロファイル上書き確認（overwrite?）通知の設計仕様を定義する。この通知はProfilesForm画面で同名のプロファイルが既に存在する場合に表示される確認ダイアログである。

### 本通知の処理概要

本通知は、ユーザーがProfilesForm画面で新しいプロファイルを追加しようとした際に、同じ名前のプロファイルが既に存在する場合、既存プロファイルを上書きするかどうかを確認する機能を提供する。

**業務上の目的・背景**：StaxRipはエンコーダやオーディオ設定などのプロファイル機能を持ち、ユーザーは独自の設定をプロファイルとして保存・管理できる。同名のプロファイルを追加すると既存のプロファイルが失われる可能性があるため、上書き前にユーザーへ確認を求める。これにより、意図しないプロファイルの上書きを防止する。

**通知の送信タイミング**：ProfilesForm画面のbnAdd_Clickメソッド内で、入力されたプロファイル名が既存プロファイル一覧に存在する場合に表示される。

**通知の受信者**：StaxRipアプリケーションを操作しているユーザーがダイアログを通じて直接受信する。GUI上のモーダルダイアログとして表示される。

**通知内容の概要**：「There is already a profile with this name, overwrite?」という質問がタスクダイアログで表示される。ユーザーはOKで上書きを続行、Cancelでキャンセルを選択できる。

**期待されるアクション**：ユーザーはOKボタンで既存プロファイルを上書きするか、Cancelボタンでプロファイル追加をキャンセルする。OKを選択した場合、既存プロファイルが削除され、新しいプロファイルがリストに追加される。

## 通知種別

アプリ内通知（Windowsタスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザー応答待ち） |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

現在ProfilesForm画面を操作中のユーザーに対してモーダルダイアログとして直接表示される。

## 通知テンプレート

### ダイアログ表示の場合

| 項目 | 内容 |
|-----|------|
| アイコン | TaskIcon.Question（質問アイコン） |
| タイトル | There is already a profile with this name, overwrite? |
| ボタン | OK / Cancel |

### 本文テンプレート

```
There is already a profile with this name, overwrite?
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | プロファイル追加 | i.Name = pm.Name | 同名のプロファイルが既に存在 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 同名プロファイルが存在しない | 名前が一意の場合は表示されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[追加ボタンクリック] --> B[AddProfileMethod呼び出し]
    B --> C[プロファイルコピー作成]
    C --> D[InputBox.Show名前入力]
    D --> E{名前が入力された?}
    E -->|No| F[処理終了]
    E -->|Yes| G[既存プロファイルループ]
    G --> H{同名プロファイル存在?}
    H -->|No| I[プロファイル追加]
    H -->|Yes| J[MsgOK表示]
    J --> K{ユーザー選択}
    K -->|True/OK| L[既存プロファイルを削除対象に]
    K -->|False/Cancel| F
    L --> M[削除対象を削除]
    M --> I
    I --> N[リストに追加]
    N --> O[UpdateControls]
    O --> F
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし（メモリ上のリストを操作）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キャンセル選択 | ユーザーがCancelを選択 | Exit Subで処理を中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

本通知は固定のメッセージのみを表示し、プロファイル名などの情報は含まれない。セキュリティリスクは低い。

## 備考

- 本通知はProfilesFormクラスのbnAdd_Clickメソッド内で発生する
- MsgOK関数はBoolean戻り値を返し、Trueで上書きを実行
- 上書き対象のプロファイルはremove変数に格納され、後で削除
- プロファイルはObjectHelp.GetCopyでディープコピーされる
- pm.Clean()で新プロファイルのクリーンアップ処理が行われる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プロファイルのデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Profile.vb | `Source/General/Profile.vb` | Profileクラスの基本構造とNameプロパティ |

**読解のコツ**: ProfileクラスはNameプロパティを持ち、これがプロファイルの一意識別子として使用される。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ProfilesForm.vb | `Source/Forms/ProfilesForm.vb` | bnAdd_Clickメソッドがエントリーポイント |

**主要処理フロー**:
1. **行426**: bnAdd_Clickメソッド開始
2. **行427**: AddProfileMethod()で新プロファイル取得
3. **行430**: ObjectHelp.GetCopy()でディープコピー
4. **行431**: InputBox.Show()で名前入力
5. **行433**: 名前が入力された場合の処理開始
6. **行436-444**: 既存プロファイルとの名前比較ループ
7. **行438**: MsgOKダイアログ表示
8. **行439**: 上書き対象をremove変数に格納
9. **行446-448**: 上書き対象の削除
10. **行450-454**: 新プロファイルの追加とUI更新

#### Step 3: 共通ダイアログ関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgOK関数の実装（行1257-1259） |

### プログラム呼び出し階層図

```
ProfilesForm.bnAdd_Click()
    │
    ├─ AddProfileMethod()
    │      └─ 新プロファイル取得
    │
    ├─ ObjectHelp.GetCopy()
    │      └─ ディープコピー
    │
    ├─ InputBox.Show()
    │      └─ 名前入力
    │
    └─ For Each i As Profile In lbMain.Items
           │
           └─ If i.Name = pm.Name Then
                  │
                  └─ MsgOK("There is already a profile...")
                         │
                         ├─ True → remove = i
                         │
                         └─ False → Exit Sub
```

### データフロー図

```
[入力]               [処理]                    [出力]

追加ボタン ───▶ AddProfileMethod() ───▶ 新プロファイル
                       │
                       ▼
               InputBox.Show() ───▶ プロファイル名
                       │
                       ▼
               名前重複チェック ───▶ 確認ダイアログ表示
                       │
                       ▼
               ユーザー選択 ───▶ OK/Cancel
                       │
                       ▼ (OK時)
               既存削除 ───▶ 新規追加 ───▶ リスト更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ProfilesForm.vb | `Source/Forms/ProfilesForm.vb` | ソース | 通知発生元のプロファイル管理画面 |
| General.vb | `Source/General/General.vb` | ソース | 共通ダイアログ関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログの実装 |
| Profile.vb | `Source/General/Profile.vb` | ソース | プロファイル基底クラス |
| ObjectHelp.vb | `Source/General/ObjectHelp.vb` | ソース | オブジェクトコピーヘルパー |
| InputBox.vb | `Source/UI/InputBox.vb` | ソース | 入力ダイアログ |
