# 通知設計書 101-メニューリセット確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるメニューリセット確認（confirm to reset the entire menu）通知の設計仕様を定義する。この通知はCustomMenuEditor画面でメニュー全体をデフォルトにリセットする操作を行う際に表示される確認ダイアログである。

### 本通知の処理概要

メニューリセット確認通知は、カスタムメニューエディターで設定したメニュー構成をすべて破棄し、デフォルトのメニュー構成に戻す操作を実行する前の最終確認を行うための通知機能である。

**業務上の目的・背景**：StaxRipはユーザーがメニュー構成を自由にカスタマイズできる柔軟性を提供しているが、カスタマイズしたメニュー設定を一括リセットする操作は不可逆的であり、長時間かけて構築したメニュー構成が失われる可能性がある。このため、ユーザーが誤ってリセット操作を実行することを防止し、意図的な操作であることを確認する必要がある。本通知により、カスタマイズ作業の保護とユーザーエクスペリエンスの向上を図る。

**通知の送信タイミング**：CustomMenuEditor画面においてユーザーがResetToolStripMenuItemをクリックし、メニュー全体のリセット操作を開始した際に表示される。具体的にはResetToolStripMenuItem_Clickイベントハンドラ内でMsgOK関数が呼び出されるタイミングで発生する。

**通知の受信者**：現在CustomMenuEditorフォームを操作しているユーザー本人が受信者となる。ローカルデスクトップアプリケーションであるため、通知は操作中のユーザーに対してのみモーダルダイアログとして表示される。

**通知内容の概要**：「Please confirm to reset the entire menu.」というメッセージが表示され、メニュー全体をリセットすることの確認を求める。Question（?）アイコンとOK/Cancelボタンが表示される。

**期待されるアクション**：ユーザーはメニューリセットを実行する場合はOKボタンを、操作をキャンセルする場合はCancelボタンをクリックする。OKを選択した場合、TreeViewがクリアされ、GenericMenu.DefaultMenuからデフォルトメニュー構成が読み込まれる。

## 通知種別

アプリ内通知（モーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

CustomMenuEditorフォームを操作中のユーザーに対して、モーダルダイアログとして直接表示される。送信先の決定ロジックは不要であり、現在のアクティブウィンドウのオーナーフォームに対してダイアログが表示される。

## 通知テンプレート

### メール通知の場合

該当なし（アプリ内ダイアログ通知のため）

### 本文テンプレート

```
タイトル: Please confirm to reset the entire menu.
アイコン: Question（?アイコン）
ボタン: OK / Cancel
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本通知では変数を使用しない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ResetToolStripMenuItem.Click | なし（常に表示） | カスタムメニューエディターでリセットメニュー項目をクリック |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 本通知は抑止条件なく常に表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ResetToolStripMenuItem.Click] --> B[MsgOK呼び出し]
    B --> C[TaskDialog表示]
    C --> D{ユーザー選択}
    D -->|OK| E[tv.BeginUpdate]
    D -->|Cancel| F[処理終了]
    E --> G[tv.Nodes.Clear]
    G --> H[PopulateTreeView]
    H --> I[tv.EndUpdate]
    I --> J[tv.ExpandAll]
    J --> K[tv.SelectedNode = tv.Nodes 0]
    K --> L[処理終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 該当なし | ローカルアプリのためDB参照なし | メモリ内のTreeView構造を操作 |

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| 該当なし | - | ローカルアプリのためDB更新なし |

#### 送信ログテーブル

該当なし（ローカルアプリケーションのため送信ログは記録されない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 通常操作 | ユーザーがCancelを選択 | 何も実行せず終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時表示）

## セキュリティ考慮事項

本通知は単純な確認ダイアログであり、個人情報や機密情報を含まない。ローカルアプリケーション内でのみ表示されるため、特別なセキュリティ対策は不要。

## 備考

- CustomMenuEditorはStaxRipのメニューカスタマイズ機能を提供するフォームである
- リセット操作はGenericMenu.DefaultMenuから取得したデフォルトメニュー構成をTreeViewに再読み込みする
- リセット後、ユーザーのカスタマイズ設定はすべて失われる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、MsgOK関数とTaskDialogの基本構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | General.vb | `Source/General/General.vb` | MsgOK関数の定義（行1257-1259） |
| 1-2 | TaskDialog.vb | `Source/UI/TaskDialog.vb` | TaskDialogクラスの構造 |

**読解のコツ**: MsgOKはMsg関数のラッパーであり、TaskIcon.QuestionとTaskButton.OkCancelを固定で指定してDialogResult.OKとの比較結果をBoolean値で返す。

#### Step 2: エントリーポイントを理解する

処理の起点となるCustomMenuEditorのイベントハンドラを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CustomMenuEditor.vb | `Source/UI/CustomMenuEditor.vb` | ResetToolStripMenuItem_Clickハンドラ（行960-968） |

**主要処理フロー**:
1. **行961**: MsgOK("Please confirm to reset the entire menu.")で確認ダイアログを表示
2. **行962**: ユーザーがOKを選択した場合、tv.BeginUpdate()でTreeViewの更新を開始
3. **行963**: tv.Nodes.Clear()でTreeViewのノードをすべてクリア
4. **行964**: PopulateTreeView(GenericMenu.DefaultMenu.Invoke, Nothing)でデフォルトメニューを読み込み
5. **行965**: tv.EndUpdate()でTreeViewの更新を終了
6. **行966**: tv.ExpandAll()で全ノードを展開
7. **行967**: tv.SelectedNode = tv.Nodes(0)で最初のノードを選択

#### Step 3: メッセージダイアログの表示を理解する

MsgOKからTaskDialogまでの呼び出しフローを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgOK関数（行1257-1259） |
| 3-2 | General.vb | `Source/General/General.vb` | Msg関数（行1274-1282） |
| 3-3 | TaskDialog.vb | `Source/UI/TaskDialog.vb` | TaskDialogの初期化とShow |

**主要処理フロー**:
- **行1257-1259**: MsgOKがMsgを呼び出しTaskIcon.Question, TaskButton.OkCancelを渡す
- **行1274-1282**: MsgがTaskDialogを生成しShow()を呼び出して結果を返す

### プログラム呼び出し階層図

```
ResetToolStripMenuItem_Click (CustomMenuEditor.vb:960)
    │
    ├─ MsgOK (General.vb:1257)
    │      └─ Msg (General.vb:1274)
    │             └─ TaskDialog.Show (TaskDialog.vb)
    │
    └─ [ユーザーがOKを選択した場合]
           ├─ tv.BeginUpdate
           ├─ tv.Nodes.Clear
           ├─ PopulateTreeView (GenericMenu.DefaultMenu.Invoke)
           ├─ tv.EndUpdate
           ├─ tv.ExpandAll
           └─ tv.SelectedNode = tv.Nodes(0)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ユーザー操作 ───▶ ResetToolStripMenuItem ───▶ MsgOK表示
(Resetクリック)          │
                         ▼
                    TaskDialog表示
                         │
                         ▼
               ┌─────────┴─────────┐
               │                   │
               ▼                   ▼
         OKボタン              Cancelボタン
               │                   │
               ▼                   ▼
      TreeViewリセット         処理終了
      (デフォルト読込)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CustomMenuEditor.vb | `Source/UI/CustomMenuEditor.vb` | ソース | メニューエディター画面、リセット処理の実装 |
| General.vb | `Source/General/General.vb` | ソース | MsgOK、Msg関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログの実装 |
| Menu.vb | `Source/UI/Menu.vb` | ソース | GenericMenuクラスの定義 |
