# 通知設計書 102-デフォルト復元確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるデフォルト復元確認（Restore defaults?）通知の設計仕様を定義する。この通知は複数の画面（CommandLineControl、PreprocessingControl、Menu、MainForm）でデフォルト設定を復元する操作を行う際に表示される汎用的な確認ダイアログである。

### 本通知の処理概要

デフォルト復元確認通知は、ユーザーがカスタマイズした各種設定をデフォルト値に戻す操作を実行する前の最終確認を行うための通知機能である。複数の異なる画面やコンテキストで共通して使用される汎用的な確認メッセージとなっている。

**業務上の目的・背景**：StaxRipでは、コマンドラインプリセット、前処理デマクサ設定、テキストカスタムメニュー、フィルタプロファイルなど、様々な箇所でユーザーがカスタマイズ可能な設定項目が存在する。これらの設定をデフォルトに戻す操作は不可逆的であり、ユーザーが意図せずに長時間かけて構築した設定を失うことを防止する必要がある。本通知により、復元操作の意図確認とユーザーエクスペリエンスの向上を図る。

**通知の送信タイミング**：以下の4箇所でデフォルト復元操作が実行される際に表示される：
1. CommandLineControl - プリセットメニューエディタの「Restore Defaults...」ボタンクリック時
2. PreprocessingControl - デマクサ設定の「Restore」ボタンクリック時
3. Menu（TextCustomMenu.EditMenu）- テキストカスタムメニューエディタの「Restore Defaults...」ボタンクリック時
4. MainForm - フィルタプロファイルダイアログの「Restore Defaults...」ボタンクリック時

**通知の受信者**：各画面を操作しているユーザー本人が受信者となる。ローカルデスクトップアプリケーションであるため、通知は操作中のユーザーに対してのみモーダルダイアログとして表示される。

**通知内容の概要**：「Restore defaults?」というメッセージが表示され、デフォルト設定を復元することの確認を求める。Question（?）アイコンとOK/Cancelボタンが表示される。

**期待されるアクション**：ユーザーはデフォルト復元を実行する場合はOKボタンを、操作をキャンセルする場合はCancelボタンをクリックする。OKを選択した場合、該当する設定項目がデフォルト値に復元され、「Defaults were restored.」の情報メッセージが表示される。

## 通知種別

アプリ内通知（モーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

各設定画面を操作中のユーザーに対して、モーダルダイアログとして直接表示される。送信先の決定ロジックは不要であり、現在のアクティブウィンドウのオーナーフォームに対してダイアログが表示される。

## 通知テンプレート

### メール通知の場合

該当なし（アプリ内ダイアログ通知のため）

### 本文テンプレート

```
タイトル: Restore defaults?
アイコン: Question（?アイコン）
ボタン: OK / Cancel
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本通知では変数を使用しない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | CommandLineControl.bnContext.Click | RestoreFuncがNothing以外 | コマンドラインプリセットメニューエディタ |
| 画面操作 | PreprocessingControl.bnRestore.Click | なし（常に表示） | デマクサ設定画面 |
| 画面操作 | TextCustomMenu.bnContext.Click | defaultsが空でない | テキストカスタムメニューエディタ |
| 画面操作 | MainForm.bnContext.Click | なし（常に表示） | フィルタプロファイルダイアログ |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| RestoreFunc Is Nothing | CommandLineControlでRestoreFuncが設定されていない場合は表示されない |
| defaults = "" | TextCustomMenuでdefaultsが空の場合は表示されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Restore Defaults ボタンクリック] --> B{ダイアログ関数}
    B -->|MsgOK| C[OK/Cancel確認]
    B -->|MsgQuestion| C
    B -->|Msg| C
    C --> D{ユーザー選択}
    D -->|OK/DialogResult.OK| E[デフォルト値を復元]
    D -->|Cancel| F[処理終了]
    E --> G[MsgInfo Defaults were restored]
    G --> H[処理終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 該当なし | ローカルアプリのためDB参照なし | メモリ内の設定値を操作 |

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| 該当なし | - | ローカルアプリのためDB更新なし |

#### 送信ログテーブル

該当なし（ローカルアプリケーションのため送信ログは記録されない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 通常操作 | ユーザーがCancelを選択 | 何も実行せず終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時表示）

## セキュリティ考慮事項

本通知は単純な確認ダイアログであり、個人情報や機密情報を含まない。ローカルアプリケーション内でのみ表示されるため、特別なセキュリティ対策は不要。

## 備考

- 同一メッセージが複数の画面で使用される汎用的な確認通知である
- 復元成功後は「Defaults were restored.」の情報メッセージが表示される
- MsgOK、MsgQuestion、Msgの3種類の関数が使用されるが、いずれも同様のUI表示となる
- MainFormのフィルタプロファイルダイアログではMsgにTaskIcon.Warningが指定される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、MsgOK、MsgQuestion、Msg関数の基本構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | General.vb | `Source/General/General.vb` | MsgOK関数の定義（行1257-1259） |
| 1-2 | General.vb | `Source/General/General.vb` | MsgQuestion関数の定義（行1261-1266） |
| 1-3 | General.vb | `Source/General/General.vb` | Msg関数の定義（行1274-1282） |

**読解のコツ**: MsgOKとMsgQuestionはいずれもMsg関数のラッパーであり、TaskIcon.QuestionとTaskButton.OkCancelを固定で指定する。MsgOKはBoolean、MsgQuestionはDialogResultを返す。

#### Step 2: 各エントリーポイントを理解する

処理の起点となる各画面のイベントハンドラを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CommandLineControl.vb | `Source/Controls/CommandLineControl.vb` | EditPresets内のbnContext.ClickAction（行128-133） |
| 2-2 | PreprocessingControl.vb | `Source/Controls/PreprocessingControl.vb` | bnRestore_Click（行293-303） |
| 2-3 | Menu.vb | `Source/UI/Menu.vb` | TextCustomMenu.EditMenu内のbnContext.ClickAction（行683-688） |
| 2-4 | MainForm.vb | `Source/Forms/MainForm.vb` | ShowFilterProfilesDialog内のbnContext.ClickAction（行4294-4298） |

**CommandLineControl.vb 主要処理フロー**:
1. **行128-133**: bnContext.ClickActionでMsgOK("Restore defaults?")を呼び出し
2. **行130**: OKの場合、dialog.MacroEditorControl.Value = RestoreFunc.Invoke()
3. **行131**: MsgInfo("Defaults were restored.")を表示

**PreprocessingControl.vb 主要処理フロー**:
1. **行294**: MsgQuestion("Restore defaults?")を呼び出し
2. **行295-301**: DialogResult.OKの場合、lv.Items.Clearしてデフォルトデマクサを追加

**Menu.vb 主要処理フロー**:
1. **行684**: MsgOK("Restore defaults?")を呼び出し
2. **行685**: OKの場合、dialog.MacroEditorControl.Value = defaults
3. **行686**: MsgInfo("Defaults were restored.")を表示

**MainForm.vb 主要処理フロー**:
1. **行4295**: Msg("Restore defaults?", Nothing, TaskIcon.Warning, TaskButton.OkCancel)を呼び出し
2. **行4296**: DialogResult.OKの場合、dialog.MacroEditorControl.Value = g.GetFilterProfilesText(getDefaults())
3. **行4297**: MsgInfo("Defaults were restored.")を表示

### プログラム呼び出し階層図

```
[CommandLineControl]
EditPresets (行119-143)
    └─ bnContext.ClickAction (行128-133)
           └─ MsgOK("Restore defaults?") (General.vb:1257)
                  └─ Msg (General.vb:1274)

[PreprocessingControl]
bnRestore_Click (行293-303)
    └─ MsgQuestion("Restore defaults?") (General.vb:1261)
           └─ Msg (General.vb:1274)

[Menu - TextCustomMenu]
EditMenu (行673-697)
    └─ bnContext.ClickAction (行683-688)
           └─ MsgOK("Restore defaults?") (General.vb:1257)
                  └─ Msg (General.vb:1274)

[MainForm]
ShowFilterProfilesDialog (行4280-4330)
    └─ bnContext.ClickAction (行4294-4298)
           └─ Msg("Restore defaults?", ..., TaskIcon.Warning, ...) (General.vb:1274)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ユーザー操作 ───▶ Restore Defaults ───▶ MsgOK/MsgQuestion/Msg表示
(ボタンクリック)        │
                        ▼
                   TaskDialog表示
                        │
                        ▼
              ┌─────────┴─────────┐
              │                   │
              ▼                   ▼
        OKボタン              Cancelボタン
              │                   │
              ▼                   ▼
     デフォルト値復元         処理終了
              │
              ▼
     MsgInfo("Defaults were restored.")
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CommandLineControl.vb | `Source/Controls/CommandLineControl.vb` | ソース | コマンドラインコントロール、プリセット復元処理 |
| PreprocessingControl.vb | `Source/Controls/PreprocessingControl.vb` | ソース | 前処理コントロール、デマクサ設定復元処理 |
| Menu.vb | `Source/UI/Menu.vb` | ソース | テキストカスタムメニュー編集、メニュー復元処理 |
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | メインフォーム、フィルタプロファイル復元処理 |
| General.vb | `Source/General/General.vb` | ソース | MsgOK、MsgQuestion、Msg関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログの実装 |
| MacroEditorDialog.vb | `Source/Forms/MacroEditorDialog.vb` | ソース | マクロエディタダイアログ |
