# 通知設計書 103-削除確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおける削除確認（Remove?）通知の設計仕様を定義する。この通知はCodeEditor画面でフィルタを削除する操作を行う際に表示される確認ダイアログである。

### 本通知の処理概要

削除確認通知は、CodeEditorでユーザーが作成・編集したフィルタを削除する操作を実行する前の最終確認を行うための通知機能である。フィルタの削除は不可逆的な操作であるため、誤操作防止のための確認ダイアログとして機能する。

**業務上の目的・背景**：StaxRipのCodeEditorでは、ユーザーがAviSynthまたはVapourSynthのフィルタスクリプトを編集できる。フィルタは映像処理のパイプラインを構成する重要な要素であり、誤って削除するとユーザーが設定したフィルタ構成が失われる。本通知により、フィルタ削除操作の意図確認とユーザーの作業保護を図る。

**通知の送信タイミング**：CodeEditor画面においてユーザーがRemoveFilterコマンドを実行した際に表示される。具体的にはRemoveFilterメソッド内でMsgQuestion関数が呼び出されるタイミングで発生する。ActiveTableがNothing以外の場合にのみ表示される。

**通知の受信者**：CodeEditorフォームを操作しているユーザー本人が受信者となる。ローカルデスクトップアプリケーションであるため、通知は操作中のユーザーに対してのみモーダルダイアログとして表示される。

**通知内容の概要**：「Remove?」というシンプルなメッセージが表示され、フィルタを削除することの確認を求める。Question（?）アイコンとOK/Cancelボタンが表示される。

**期待されるアクション**：ユーザーはフィルタ削除を実行する場合はOKボタンを、操作をキャンセルする場合はCancelボタンをクリックする。OKを選択した場合、ActiveTableがMainFlowLayoutPanelから削除され、リソースが解放される。

## 通知種別

アプリ内通知（モーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

CodeEditorフォームを操作中のユーザーに対して、モーダルダイアログとして直接表示される。送信先の決定ロジックは不要であり、現在のアクティブウィンドウのオーナーフォームに対してダイアログが表示される。

## 通知テンプレート

### メール通知の場合

該当なし（アプリ内ダイアログ通知のため）

### 本文テンプレート

```
タイトル: Remove?
アイコン: Question（?アイコン）
ボタン: OK / Cancel
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本通知では変数を使用しない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | RemoveFilterコマンド実行 | ActiveTableがNothing以外 | CodeEditorでフィルタ削除コマンドを実行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ActiveTable Is Nothing | 選択されたフィルタテーブルがない場合は表示されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[RemoveFilterコマンド実行] --> B{ActiveTable Is Nothing?}
    B -->|Yes| C[処理終了]
    B -->|No| D[MsgQuestion Remove? 表示]
    D --> E{ユーザー選択}
    E -->|OK| F{MainFlowLayoutPanel.Controls.Count > 1?}
    E -->|Cancel| G[処理終了]
    F -->|Yes| H[ActiveTable.rtbScript.ContextMenuStrip = Nothing]
    F -->|No| G
    H --> I[MainFlowLayoutPanel.Controls.Remove ActiveTable]
    I --> J[ActiveTable.Dispose]
    J --> K[ActiveTable = Nothing]
    K --> L[処理終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 該当なし | ローカルアプリのためDB参照なし | メモリ内のコントロールを操作 |

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| 該当なし | - | ローカルアプリのためDB更新なし |

#### 送信ログテーブル

該当なし（ローカルアプリケーションのため送信ログは記録されない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 通常操作 | ユーザーがCancelを選択 | 何も実行せず終了 |
| 抑止条件 | コントロール数が1以下 | フィルタ削除を実行しない（最低1つは残す） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時表示）

## セキュリティ考慮事項

本通知は単純な確認ダイアログであり、個人情報や機密情報を含まない。ローカルアプリケーション内でのみ表示されるため、特別なセキュリティ対策は不要。

## 備考

- CodeEditorはStaxRipのフィルタスクリプト編集機能を提供するフォームである
- フィルタの削除はMainFlowLayoutPanelからコントロールを削除し、リソースを解放する処理
- 最低1つのフィルタは残す必要があるため、Controls.Countが1以下の場合は削除処理を行わない
- Command属性「Removes a filter.」で定義されているコマンドである

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、MsgQuestion関数とCodeEditorのフィルタ管理構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | General.vb | `Source/General/General.vb` | MsgQuestion関数の定義（行1261-1266） |
| 1-2 | CodeEditor.vb | `Source/Forms/CodeEditor.vb` | ActiveTableとMainFlowLayoutPanelの構造 |

**読解のコツ**: MsgQuestionはMsg関数のラッパーであり、TaskIcon.QuestionとTaskButton.OkCancelを固定で指定してDialogResultを返す。CodeEditorではActiveTableが現在選択されているフィルタテーブルを指す。

#### Step 2: エントリーポイントを理解する

処理の起点となるRemoveFilterメソッドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CodeEditor.vb | `Source/Forms/CodeEditor.vb` | RemoveFilterメソッド（行115-127） |

**主要処理フロー**:
1. **行115-116**: Command属性「Removes a filter.」で定義
2. **行117**: ActiveTableがNothing以外かチェック
3. **行118**: MsgQuestion("Remove?")で確認ダイアログを表示
4. **行119**: MainFlowLayoutPanel.Controls.Count > 1をチェック
5. **行120**: ActiveTable.rtbScript.ContextMenuStrip = Nothingでメニューを解除
6. **行121**: MainFlowLayoutPanel.Controls.Remove(ActiveTable)でコントロールを削除
7. **行122**: ActiveTable.Dispose()でリソースを解放
8. **行123**: ActiveTable = Nothingで参照をクリア

#### Step 3: メッセージダイアログの表示を理解する

MsgQuestionからTaskDialogまでの呼び出しフローを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgQuestion関数（行1261-1266） |
| 3-2 | General.vb | `Source/General/General.vb` | Msg関数（行1274-1282） |
| 3-3 | TaskDialog.vb | `Source/UI/TaskDialog.vb` | TaskDialogの初期化とShow |

**主要処理フロー**:
- **行1261-1266**: MsgQuestionがMsgを呼び出しTaskIcon.Question, TaskButton.OkCancelを渡す
- **行1274-1282**: MsgがTaskDialogを生成しShow()を呼び出して結果を返す

### プログラム呼び出し階層図

```
RemoveFilter (CodeEditor.vb:115-127)
    │
    ├─ [条件チェック] ActiveTable Is Nothing → Exit Sub
    │
    └─ MsgQuestion("Remove?") (General.vb:1261)
           │
           └─ Msg (General.vb:1274)
                  │
                  └─ TaskDialog.Show (TaskDialog.vb)
                         │
                         ▼
               [ユーザー選択: DialogResult.OK]
                         │
                         ├─ [条件チェック] Controls.Count > 1
                         │
                         ├─ ActiveTable.rtbScript.ContextMenuStrip = Nothing
                         │
                         ├─ MainFlowLayoutPanel.Controls.Remove(ActiveTable)
                         │
                         ├─ ActiveTable.Dispose()
                         │
                         └─ ActiveTable = Nothing
```

### データフロー図

```
[入力]               [処理]                    [出力]

ユーザー操作 ───▶ RemoveFilterコマンド ───▶ 条件チェック
(フィルタ削除)         │
                       ▼
            ┌─ ActiveTable Is Nothing? ─┐
            │                           │
            ▼ Yes                       ▼ No
          終了                  MsgQuestion表示
                                        │
                                        ▼
                              ┌─────────┴─────────┐
                              │                   │
                              ▼                   ▼
                         OKボタン              Cancelボタン
                              │                   │
                              ▼                   ▼
                      Controls.Count > 1?       終了
                              │
                              ▼ Yes
                      フィルタ削除実行
                      (Remove, Dispose)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CodeEditor.vb | `Source/Forms/CodeEditor.vb` | ソース | コードエディター画面、RemoveFilterメソッド実装 |
| CodeEditor.Designer.vb | `Source/Forms/CodeEditor.Designer.vb` | ソース | コードエディターのデザイナーファイル |
| General.vb | `Source/General/General.vb` | ソース | MsgQuestion、Msg関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログの実装 |
