# 通知設計書 104-Everything検索ツール導入確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるEverything検索ツール導入確認（Find Path feature requires Everything）通知の設計仕様を定義する。この通知はAppsForm画面でFind Path機能を使用しようとした際に、voidtools Everythingがインストールされていない場合に表示される確認ダイアログである。

### 本通知の処理概要

Everything検索ツール導入確認通知は、StaxRipのツールパス検索機能（Find Path）がvoidtools Everythingという外部ツールに依存していることをユーザーに通知し、必要なツールのインストールを促すための通知機能である。Everythingはファイル検索を高速に行うWindowsユーティリティであり、StaxRipはこのツールのAPIを利用してツールのパスを自動検出する。

**業務上の目的・背景**：StaxRipは多数の外部ツール（エンコーダー、デマクサー、フィルタ等）を使用するアプリケーションであり、これらのツールのパス設定が必要である。Find Path機能はユーザーのPC上から該当ツールのパスを自動検索する機能であるが、この機能はvoidtools Everythingに依存している。Everythingがインストールされていない場合、ユーザーにツールの導入を促し、StaxRipの利便性を向上させることを目的としている。

**通知の送信タイミング**：AppsForm画面においてユーザーがFind Path機能を実行した際に、Everything.dllの呼び出しで例外が発生した場合に表示される。具体的にはtsbFindPath_ClickAsyncメソッドのCatchブロック内で発生する。

**通知の受信者**：AppsFormを操作しているユーザー本人が受信者となる。ローカルデスクトップアプリケーションであるため、通知は操作中のユーザーに対してのみモーダルダイアログとして表示される。

**通知内容の概要**：「The Find Path feature requires the installation of a tool named voidtools Everything.」というメッセージとともに「Open the voidtools Everything website?」という確認が表示される。Question（?）アイコンとOK/Cancelボタンが表示される。続けて「Would you like to open the website of Everything.NET?」という二次確認も表示される。

**期待されるアクション**：ユーザーはvoidtools Everythingのウェブサイトを開く場合はOKボタンを、スキップする場合はCancelボタンをクリックする。OKを選択した場合、ブラウザでvoidtools.comが開かれる。続けてEverything.NETのウェブサイトを開くかどうかも確認される。

## 通知種別

アプリ内通知（モーダルダイアログ）+ 外部ウェブサイト誘導

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

AppsFormを操作中のユーザーに対して、モーダルダイアログとして直接表示される。送信先の決定ロジックは不要であり、現在のアクティブウィンドウのオーナーフォームに対してダイアログが表示される。

## 通知テンプレート

### メール通知の場合

該当なし（アプリ内ダイアログ通知のため）

### 本文テンプレート

```
【1回目のダイアログ】
タイトル: The Find Path feature requires the installation of a tool named voidtools Everything.

Open the voidtools Everything website?
アイコン: Question（?アイコン）
ボタン: OK / Cancel

【2回目のダイアログ（1回目のOK/Cancel後に表示）】
タイトル: Would you like to open the website of Everything.NET?
コンテンツ: Everything.NET is a voidtools Everything frontend that supports dark mode.
アイコン: Question（?アイコン）
ボタン: OK / Cancel
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本通知では変数を使用しない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | tsbFindPath.Click | Everything.dll呼び出し時に例外発生 | Find Path機能実行時にEverythingが利用不可 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Everythingが正常に動作 | Everything.dllの呼び出しが成功した場合は表示されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[tsbFindPath.Click] --> B[非同期タスク開始]
    B --> C[Everything_SetSearch呼び出し]
    C --> D{例外発生?}
    D -->|No| E[検索結果処理]
    D -->|Yes| F[MsgQuestion voidtools Everything]
    F --> G{ユーザー選択}
    G -->|OK| H[voidtools.com を開く]
    G -->|Cancel| I[スキップ]
    H --> J[MsgQuestion Everything.NET]
    I --> J
    J --> K{ユーザー選択}
    K -->|OK| L[Everything.NET GitHub を開く]
    K -->|Cancel| M[処理終了]
    L --> M
    E --> N[パス選択ダイアログ表示]
    N --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 該当なし | ローカルアプリのためDB参照なし | 外部DLL呼び出しを使用 |

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| 該当なし | - | ローカルアプリのためDB更新なし |

#### 送信ログテーブル

該当なし（ローカルアプリケーションのため送信ログは記録されない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Everything未インストール | Everything.dllが見つからない | 本通知を表示してインストールを促す |
| 通常操作 | ユーザーがCancelを選択 | ウェブサイトを開かずに次の処理へ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時表示）

## セキュリティ考慮事項

本通知は外部ウェブサイト（voidtools.com、github.com/stax76/Everything.NET）へのリンクを含む。これらは公式のツール配布サイトであり、悪意のあるサイトではない。ただし、外部サイトへのリンクを開く前にユーザーの確認を取得している。

## 備考

- voidtools Everythingはファイル検索を高速化するWindowsユーティリティツールである
- Everything.NETはvoidtools Everythingのフロントエンドでダークモードをサポートする
- Find Path機能はEverything.dllのP/Invoke呼び出しを使用している
- Everythingがインストールされていても、サービスが起動していない場合は同様のエラーが発生する可能性がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Everything.dllのP/Invoke定義とMsgQuestion関数の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | Everything DllImport定義（行1063-1092） |
| 1-2 | General.vb | `Source/General/General.vb` | MsgQuestion関数の定義（行1268-1272） |

**読解のコツ**: AppsFormではEverything.dllの各種関数をDllImport属性で宣言している。EVERYTHING_REQUEST_FILE_NAMEとEVERYTHING_REQUEST_PATHの定数も定義されている。MsgQuestionの2引数版はtitleとcontentの両方を指定できる。

#### Step 2: エントリーポイントを理解する

処理の起点となるtsbFindPath_ClickAsyncメソッドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | tsbFindPath_ClickAsync（行985-1061） |

**主要処理フロー**:
1. **行985-993**: tsbFindPathがNothingでない場合に処理開始
2. **行994-1015**: Task.Runで非同期にEverything検索を実行
3. **行1000-1001**: Everything_SetSearch、Everything_SetRequestFlagsを呼び出し
4. **行1002**: Everything_Queryで検索実行
5. **行1016-1026**: Catchブロックで例外発生時に通知表示
6. **行1017-1020**: MsgQuestion("The Find Path feature requires...")でvoidtools.comへの誘導
7. **行1022-1025**: MsgQuestion("Would you like to open the website of Everything.NET?...")でEverything.NETへの誘導

#### Step 3: 例外処理とウェブサイト誘導を理解する

Catchブロック内の処理フローを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | Catchブロック（行1016-1026） |
| 3-2 | GlobalClass.vb | `Source/General/GlobalClass.vb` | g.ShellExecute関数 |

**主要処理フロー**:
- **行1016**: Catch句で例外をキャッチ
- **行1017-1020**: 最初のMsgQuestionでvoidtools Everythingサイトへの誘導
- **行1019**: DialogResult.OKの場合、g.ShellExecute("https://www.voidtools.com")
- **行1022-1025**: 2番目のMsgQuestionでEverything.NETサイトへの誘導
- **行1024**: DialogResult.OKの場合、g.ShellExecute("https://github.com/stax76/Everything.NET")

### プログラム呼び出し階層図

```
tsbFindPath_ClickAsync (AppsForm.vb:985-1061)
    │
    ├─ Task.Run (非同期タスク)
    │      │
    │      ├─ Everything_SetSearch (行1000)
    │      ├─ Everything_SetRequestFlags (行1001)
    │      ├─ Everything_Query (行1002)
    │      │
    │      └─ [例外発生時]
    │             │
    │             ├─ MsgQuestion("The Find Path feature requires...") (行1017-1020)
    │             │      │
    │             │      └─ [OK選択時] g.ShellExecute("https://www.voidtools.com") (行1019)
    │             │
    │             └─ MsgQuestion("Would you like to open...Everything.NET?") (行1022-1025)
    │                    │
    │                    └─ [OK選択時] g.ShellExecute("https://github.com/stax76/Everything.NET") (行1024)
    │
    └─ [正常時] パス選択ダイアログ表示 (行1035-1060)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ユーザー操作 ───▶ tsbFindPath.Click ───▶ 非同期タスク開始
(Find Path)              │
                         ▼
                Everything.dll呼び出し
                         │
                         ▼
              ┌─────────┴─────────┐
              │                   │
              ▼ 成功              ▼ 例外
         検索結果取得        MsgQuestion表示
              │              (voidtools.com)
              ▼                   │
         パス選択ダイアログ        ▼
                          ┌───────┴───────┐
                          │               │
                          ▼               ▼
                        OK            Cancel
                          │               │
                          ▼               ▼
                   ブラウザ起動    MsgQuestion表示
                   voidtools.com  (Everything.NET)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AppsForm.vb | `Source/Forms/AppsForm.vb` | ソース | アプリ管理画面、Find Path機能実装 |
| General.vb | `Source/General/General.vb` | ソース | MsgQuestion関数の定義 |
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | ShellExecute関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログの実装 |
