# 通知設計書 105-実験的機能確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおける実験的機能確認（Experimental feature not working for all tools）通知の設計仕様を定義する。この通知はAppsForm画面でツールの自動更新機能を使用する際に表示される確認ダイアログである。

### 本通知の処理概要

実験的機能確認通知は、StaxRipのツール自動更新機能がすべてのツールで正常に動作するわけではないことをユーザーに警告し、自動更新を実行するかどうかの確認を行うための通知機能である。この機能は実験的（Experimental）な段階にあり、一部のツールでは期待通りに動作しない可能性があることをユーザーに認識させる。

**業務上の目的・背景**：StaxRipは多数の外部ツールを使用するアプリケーションであり、これらのツールを最新バージョンに更新する機能を提供している。しかし、ツールの配布方法やファイル構成は多様であり、すべてのツールに対して自動更新が正常に動作するとは限らない。本通知により、ユーザーに機能の実験的性質を理解させ、問題発生時の対処を促すことを目的としている。

**通知の送信タイミング**：AppsForm画面においてユーザーがAuto Update機能（miAutoUpdate）をクリックした際に表示される。ただし、ダウンロードURLが空でない場合、かつMediaFireからのダウンロードではない場合にのみ表示される。

**通知の受信者**：AppsFormを操作しているユーザー本人が受信者となる。ローカルデスクトップアプリケーションであるため、通知は操作中のユーザーに対してのみモーダルダイアログとして表示される。

**通知内容の概要**：「Experimental feature not working for all tools, continue?」というメッセージが表示され、実験的機能を使用して続行するかの確認を求める。Question（?）アイコンとOK/Cancelボタンが表示される。

**期待されるアクション**：ユーザーは自動更新を実行する場合はOKボタンを、操作をキャンセルする場合はCancelボタンをクリックする。OKを選択した場合、ToolUpdateオブジェクトが生成され、Update()メソッドが実行される。

## 通知種別

アプリ内通知（モーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

AppsFormを操作中のユーザーに対して、モーダルダイアログとして直接表示される。送信先の決定ロジックは不要であり、現在のアクティブウィンドウのオーナーフォームに対してダイアログが表示される。

## 通知テンプレート

### メール通知の場合

該当なし（アプリ内ダイアログ通知のため）

### 本文テンプレート

```
タイトル: Experimental feature not working for all tools, continue?
アイコン: Question（?アイコン）
ボタン: OK / Cancel
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本通知では変数を使用しない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | miAutoUpdate.Click | DownloadURLが空でなく、MediaFireでない | Auto Update機能の実行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| url = "" | ダウンロードURLが空の場合は処理終了 |
| url.Contains("mediafire") | MediaFireからのダウンロードの場合はエラー表示（別の通知） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[miAutoUpdate.Click] --> B{url = "" ?}
    B -->|Yes| C[Exit Sub]
    B -->|No| D{url.Contains mediafire?}
    D -->|Yes| E[MsgError MediaFire非対応]
    D -->|No| F[MsgQuestion Experimental feature...]
    E --> G[Exit Sub]
    F --> H{ユーザー選択}
    H -->|OK| I[ToolUpdate生成]
    H -->|Cancel| J[処理終了]
    I --> K[ToolUpdate.Update実行]
    K --> L[処理終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 該当なし | ローカルアプリのためDB参照なし | CurrentPackageオブジェクトから情報取得 |

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| 該当なし | - | ローカルアプリのためDB更新なし |

#### 送信ログテーブル

該当なし（ローカルアプリケーションのため送信ログは記録されない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ダウンロードURL空 | CurrentPackage.DownloadURLが空 | 何も表示せず終了 |
| MediaFireエラー | URLにmediafireが含まれる | 「auto update feature does not support MediaFire」エラーを表示 |
| 通常操作 | ユーザーがCancelを選択 | 何も実行せず終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時表示）

## セキュリティ考慮事項

本通知は単純な確認ダイアログであり、個人情報や機密情報を含まない。ただし、自動更新機能はインターネットからファイルをダウンロードするため、ダウンロード元のURLの信頼性に注意が必要である。

## 備考

- Auto Update機能は実験的（Experimental）な段階であり、すべてのツールで動作保証されていない
- MediaFireからのダウンロードはサポートされていない（別の通知で処理）
- ToolUpdateクラスがダウンロードと更新処理を担当する
- CHANGELOGにはこの機能が実験的であることが記載されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、MsgQuestion関数とToolUpdateクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | General.vb | `Source/General/General.vb` | MsgQuestion関数の定義（行1261-1266） |
| 1-2 | AppsForm.vb | `Source/Forms/AppsForm.vb` | ToolUpdateフィールドの宣言 |

**読解のコツ**: MsgQuestionはMsg関数のラッパーであり、TaskIcon.QuestionとTaskButton.OkCancelを固定で指定してDialogResultを返す。ToolUpdateはツール更新処理を担当するクラスである。

#### Step 2: エントリーポイントを理解する

処理の起点となるmiAutoUpdate_Clickメソッドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | miAutoUpdate_Click（行1098-1113） |

**主要処理フロー**:
1. **行1099**: CurrentPackage.DownloadURLを取得
2. **行1101-1102**: urlが空の場合はExit Sub
3. **行1105-1107**: urlにmediafireが含まれる場合はMsgErrorを表示してExit Sub
4. **行1110**: MsgQuestion("Experimental feature not working for all tools, continue?")で確認
5. **行1111**: DialogResult.OKの場合、ToolUpdate = New ToolUpdate(CurrentPackage, Me)を生成
6. **行1112**: ToolUpdate.Update()を実行

#### Step 3: 関連する前処理を理解する

MediaFireチェックと条件分岐を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | MediaFireチェック（行1105-1107） |

**主要処理フロー**:
- **行1105**: url.Contains("mediafire")でMediaFireかどうかをチェック
- **行1106**: MsgError("The auto update feature does currently not support MediaFire.")
- **行1107**: Exit Subで処理を終了

### プログラム呼び出し階層図

```
miAutoUpdate_Click (AppsForm.vb:1098-1113)
    │
    ├─ [条件チェック] url = "" → Exit Sub
    │
    ├─ [条件チェック] url.Contains("mediafire")
    │      │
    │      └─ [True] MsgError("...not support MediaFire") → Exit Sub
    │
    └─ MsgQuestion("Experimental feature not working for all tools, continue?") (General.vb:1261)
           │
           └─ Msg (General.vb:1274)
                  │
                  └─ TaskDialog.Show (TaskDialog.vb)
                         │
                         ▼
               [ユーザー選択: DialogResult.OK]
                         │
                         ├─ ToolUpdate = New ToolUpdate(CurrentPackage, Me)
                         │
                         └─ ToolUpdate.Update()
```

### データフロー図

```
[入力]               [処理]                    [出力]

ユーザー操作 ───▶ miAutoUpdate.Click ───▶ URL取得
(Auto Update)           │
                        ▼
                ┌───────┴───────┐
                │               │
           URL空?            URL非空
                │               │
                ▼               ▼
              終了       MediaFireチェック
                                │
                        ┌───────┴───────┐
                        │               │
                   MediaFire         通常URL
                        │               │
                        ▼               ▼
                   MsgError      MsgQuestion表示
                   (非対応)      (Experimental...)
                        │               │
                        ▼               ▼
                      終了        ┌─────┴─────┐
                                  │           │
                                 OK        Cancel
                                  │           │
                                  ▼           ▼
                            ToolUpdate      終了
                            生成・実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AppsForm.vb | `Source/Forms/AppsForm.vb` | ソース | アプリ管理画面、Auto Update機能実装 |
| General.vb | `Source/General/General.vb` | ソース | MsgQuestion関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログの実装 |
| CHANGELOG.md | `CHANGELOG.md` | ドキュメント | 実験的機能であることの記載 |
