# 通知設計書 106-コマンドラインインポート確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるコマンドラインインポート確認（Import command line from clipboard?）通知の設計仕様を定義する。この通知はCommandLineForm画面でクリップボードからコマンドラインをインポートする際に表示される確認ダイアログである。

### 本通知の処理概要

コマンドラインインポート確認通知は、ユーザーがクリップボードにコピーされたコマンドライン文字列をStaxRipのエンコーダー設定にインポートする操作を実行する前の確認を行うための通知機能である。クリップボードの内容を表示してユーザーに確認させ、意図したコマンドラインであることを確認した上でインポートを実行する。

**業務上の目的・背景**：StaxRipでは、x264、x265、AV1などの映像エンコーダーの設定をコマンドライン形式で指定できる。他のツールやウェブサイトで使用されているコマンドラインをStaxRipに取り込むことで、エンコード設定の再利用や共有が可能になる。本通知により、インポート前にコマンドラインの内容を確認し、誤ったインポートを防止することを目的としている。

**通知の送信タイミング**：CommandLineForm画面においてユーザーが「Import Command Line...」メニュー項目をクリックした際、またはCtrl+Iショートカットキーを押した際に表示される。

**通知の受信者**：CommandLineFormを操作しているユーザー本人が受信者となる。ローカルデスクトップアプリケーションであるため、通知は操作中のユーザーに対してのみモーダルダイアログとして表示される。

**通知内容の概要**：「Import command line from clipboard?」というタイトルとともに、クリップボードの内容がコンテンツとして表示される。Question（?）アイコンとOK/Cancelボタンが表示される。

**期待されるアクション**：ユーザーはクリップボードの内容を確認し、インポートを実行する場合はOKボタンを、操作をキャンセルする場合はCancelボタンをクリックする。OKを選択した場合、BasicVideoEncoder.ImportCommandLineメソッドが呼び出され、コマンドラインがパースされてエンコーダー設定に反映される。

## 通知種別

アプリ内通知（モーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

CommandLineFormを操作中のユーザーに対して、モーダルダイアログとして直接表示される。送信先の決定ロジックは不要であり、現在のアクティブウィンドウのオーナーフォームに対してダイアログが表示される。

## 通知テンプレート

### メール通知の場合

該当なし（アプリ内ダイアログ通知のため）

### 本文テンプレート

```
タイトル: Import command line from clipboard?
コンテンツ: [クリップボードの内容]
アイコン: Question（?アイコン）
ボタン: OK / Cancel
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| クリップボードテキスト | インポート対象のコマンドライン | Clipboard.GetText() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | cms.Add("Import Command Line...") | なし（常に表示） | Import Command Lineメニュー項目クリック |
| キーボード | Ctrl+I | なし（常に表示） | ショートカットキー実行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 本通知は抑止条件なく常に表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Import Command Line メニュー / Ctrl+I] --> B[Clipboard.GetText取得]
    B --> C[MsgQuestion表示]
    C --> D{ユーザー選択}
    D -->|OK| E[BasicVideoEncoder.ImportCommandLine]
    D -->|Cancel| F[処理終了]
    E --> G[コマンドラインパース・反映]
    G --> H[処理終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 該当なし | ローカルアプリのためDB参照なし | クリップボードとparamsオブジェクトを操作 |

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| 該当なし | - | ローカルアプリのためDB更新なし |

#### 送信ログテーブル

該当なし（ローカルアプリケーションのため送信ログは記録されない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 通常操作 | ユーザーがCancelを選択 | 何も実行せず終了 |
| パースエラー | コマンドラインの形式が不正 | ImportCommandLineメソッド内でエラー処理 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時表示）

## セキュリティ考慮事項

クリップボードの内容をダイアログに表示するため、機密情報がクリップボードに含まれている場合は注意が必要である。ただし、本機能はユーザーが明示的に操作した場合にのみ実行され、クリップボードの内容は確認用に表示されるのみでログ等に保存されることはない。

## 備考

- ショートカットキーCtrl+Iでも同じ機能を実行可能
- Symbol.Downloadアイコンがメニュー項目に設定されている
- BasicVideoEncoder.ImportCommandLineがコマンドラインのパースと設定反映を担当する
- paramsオブジェクトはエンコーダーのパラメータ設定を保持している

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、MsgQuestion関数とCommandLineFormのparamsオブジェクト構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | General.vb | `Source/General/General.vb` | MsgQuestion関数の定義（行1268-1272） |
| 1-2 | CommandLineForm.vb | `Source/Forms/CommandLineForm.vb` | paramsフィールドの宣言と用途 |

**読解のコツ**: MsgQuestionの2引数版（title, content）はタイトルとコンテンツの両方を指定できる。クリップボードの内容がcontentとして表示される。paramsはBasicVideoEncoderのパラメータを保持するオブジェクトである。

#### Step 2: エントリーポイントを理解する

処理の起点となるメニュー項目の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CommandLineForm.vb | `Source/Forms/CommandLineForm.vb` | コンストラクタ内のcms.Add定義（行62） |

**主要処理フロー**:
1. **行62**: cms.Add("Import Command Line...", Sub() If MsgQuestion(...)のラムダ式でメニュー項目を定義
2. **行62**: MsgQuestion("Import command line from clipboard?", Clipboard.GetText)でダイアログを表示
3. **行62**: DialogResult.OKの場合、BasicVideoEncoder.ImportCommandLine(Clipboard.GetText, params)を実行
4. **行62**: Keys.Control Or Keys.Iでショートカットキーを設定
5. **行62**: SetImage(Symbol.Download)でアイコンを設定

#### Step 3: インポート処理を理解する

BasicVideoEncoder.ImportCommandLineメソッドの処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | VideoEncoderCommandLine.vb | `Source/Video/VideoEncoderCommandLine.vb` | ImportCommandLineメソッドの実装 |

**主要処理フロー**:
- クリップボードから取得したコマンドライン文字列をパースする
- 各パラメータをparamsオブジェクトの対応する設定項目に反映する

### プログラム呼び出し階層図

```
CommandLineForm.New (CommandLineForm.vb)
    │
    └─ cms.Add("Import Command Line...", ...) (行62)
           │
           └─ [ユーザークリック / Ctrl+I]
                  │
                  ├─ Clipboard.GetText()
                  │
                  └─ MsgQuestion("Import command line from clipboard?", Clipboard.GetText)
                         │
                         └─ Msg (General.vb:1274)
                                │
                                └─ TaskDialog.Show (TaskDialog.vb)
                                       │
                                       ▼
                             [ユーザー選択: DialogResult.OK]
                                       │
                                       └─ BasicVideoEncoder.ImportCommandLine(Clipboard.GetText, params)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ユーザー操作 ───▶ Import Command Line ───▶ Clipboard.GetText()
(メニュー/Ctrl+I)       │
                        ▼
             MsgQuestion表示
             (クリップボード内容をコンテンツ表示)
                        │
                        ▼
              ┌─────────┴─────────┐
              │                   │
              ▼                   ▼
         OKボタン              Cancelボタン
              │                   │
              ▼                   ▼
    BasicVideoEncoder           処理終了
    .ImportCommandLine
              │
              ▼
    コマンドラインパース
              │
              ▼
    paramsオブジェクトに
    設定を反映
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CommandLineForm.vb | `Source/Forms/CommandLineForm.vb` | ソース | コマンドライン設定画面、インポートメニュー定義 |
| CommandLineForm.Designer.vb | `Source/Forms/CommandLineForm.Designer.vb` | ソース | コマンドラインフォームのデザイナーファイル |
| General.vb | `Source/General/General.vb` | ソース | MsgQuestion関数の定義 |
| VideoEncoderCommandLine.vb | `Source/Video/VideoEncoderCommandLine.vb` | ソース | BasicVideoEncoder.ImportCommandLineメソッド |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログの実装 |
