# 通知設計書 107-トラック処理確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるトラック処理確認（Confirm to process the track.）通知の設計仕様を定義する。この通知はMainForm画面で個別のオーディオトラックを処理（エンコード）する際に表示される確認ダイアログである。

### 本通知の処理概要

トラック処理確認通知は、ユーザーが個別のオーディオトラックのエンコード処理を実行する前の最終確認を行うための通知機能である。オーディオトラックの処理は一定の時間を要する操作であり、意図しない実行を防止するために確認ダイアログを表示する。

**業務上の目的・背景**：StaxRipでは、映像と音声を別々に処理する機能を提供している。オーディオトラックの処理（デマックス、エンコード等）は時間のかかる操作であり、処理中はシステムリソースを消費する。本通知により、ユーザーが意図的にトラック処理を開始することを確認し、誤操作による不要な処理を防止することを目的としている。

**通知の送信タイミング**：MainForm画面のオーディオトラック領域でコンテキストメニューの「Execute」を選択した際に表示される。具体的にはExecuteAudioメソッド内でMsgQuestion関数が呼び出されるタイミングで発生する。

**通知の受信者**：MainFormを操作しているユーザー本人が受信者となる。ローカルデスクトップアプリケーションであるため、通知は操作中のユーザーに対してのみモーダルダイアログとして表示される。

**通知内容の概要**：「Confirm to process the track.」というメッセージが表示され、トラック処理の実行を確認する。Question（?）アイコンとOK/Cancelボタンが表示される。

**期待されるアクション**：ユーザーはトラック処理を実行する場合はOKボタンを、操作をキャンセルする場合はCancelボタンをクリックする。OKを選択した場合、Audio.Processおよびap.Encode()が実行されてオーディオトラックが処理される。

## 通知種別

アプリ内通知（モーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

MainFormを操作中のユーザーに対して、モーダルダイアログとして直接表示される。送信先の決定ロジックは不要であり、現在のアクティブウィンドウのオーナーフォームに対してダイアログが表示される。

## 通知テンプレート

### メール通知の場合

該当なし（アプリ内ダイアログ通知のため）

### 本文テンプレート

```
タイトル: Confirm to process the track.
アイコン: Question（?アイコン）
ボタン: OK / Cancel
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本通知では変数を使用しない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | cms.Add("Execute", ...) | exist（ファイル存在） | オーディオトラックコンテキストメニューのExecute選択 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | ExecuteAudioメソッドが呼び出されれば常に表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[コンテキストメニュー Execute] --> B[ExecuteAudio ap 呼び出し]
    B --> C[MsgQuestion Confirm to process...]
    C --> D{ユーザー選択}
    D -->|OK| E{p.TempDir = "" ?}
    D -->|Cancel| F[処理終了]
    E -->|Yes| G[p.TempDir = ap.File.Dir]
    E -->|No| H[ap = ObjectHelp.GetCopy ap]
    G --> H
    H --> I[Audio.Process ap]
    I --> J[ap.Encode]
    J --> K{cleanTemp?}
    K -->|Yes| L[p.TempDir = ""]
    K -->|No| M[処理終了]
    L --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 該当なし | ローカルアプリのためDB参照なし | AudioProfileオブジェクトを操作 |

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| 該当なし | - | ローカルアプリのためDB更新なし |

#### 送信ログテーブル

該当なし（ローカルアプリケーションのため送信ログは記録されない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 通常操作 | ユーザーがCancelを選択 | 何も実行せず終了 |
| 処理エラー | Audio.ProcessまたはEncodeで例外発生 | Try-Catch-Finallyで処理し、cleanTempの場合はp.TempDirをクリア |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時表示）

## セキュリティ考慮事項

本通知は単純な確認ダイアログであり、個人情報や機密情報を含まない。ローカルアプリケーション内でのみ表示されるため、特別なセキュリティ対策は不要。

## 備考

- メニュー項目には「Processes the audio profile.」という説明文が設定されている
- Symbol.LightningBoltアイコンがメニュー項目に設定されている
- 処理中に例外が発生してもFinallyブロックでTempDirのクリーンアップが行われる
- ObjectHelp.GetCopyでAudioProfileのコピーを作成してから処理を行う

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、AudioProfileクラスとMsgQuestion関数の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AudioProfile.vb | `Source/General/AudioProfile.vb` | AudioProfileクラスの構造 |
| 1-2 | General.vb | `Source/General/General.vb` | MsgQuestion関数の定義（行1261-1266） |

**読解のコツ**: AudioProfileはオーディオトラックの設定（コーデック、ビットレート、チャンネル等）を保持するクラスである。MsgQuestionはMsg関数のラッパーであり、TaskIcon.QuestionとTaskButton.OkCancelを固定で指定してDialogResultを返す。

#### Step 2: エントリーポイントを理解する

処理の起点となるExecuteAudioメソッドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | ExecuteAudio（行5836-5854） |

**主要処理フロー**:
1. **行5837**: MsgQuestion("Confirm to process the track.")で確認ダイアログを表示
2. **行5838**: cleanTemp = Falseを初期化
3. **行5840-5844**: Try句でp.TempDirが空の場合はap.File.Dirを設定
4. **行5846**: ObjectHelp.GetCopy(ap)でAudioProfileのコピーを作成
5. **行5847**: Audio.Process(ap)でオーディオ処理を実行
6. **行5848**: ap.Encode()でエンコードを実行
7. **行5851**: FinallyでcleanTempがTrueの場合はp.TempDir = ""

#### Step 3: コンテキストメニューの定義を理解する

オーディオトラックのコンテキストメニュー定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MainForm.vb | `Source/Forms/MainForm.vb` | ShowAudioMenu内のcms.Add（行5826） |

**主要処理フロー**:
- **行5826**: cms.Add("Execute", Sub() ExecuteAudio(ap), exist, "Processes the audio profile.").SetImage(Symbol.LightningBolt)

### プログラム呼び出し階層図

```
ShowAudioMenu (MainForm.vb)
    │
    └─ cms.Add("Execute", Sub() ExecuteAudio(ap), ...) (行5826)
           │
           └─ [ユーザークリック]
                  │
                  └─ ExecuteAudio(ap) (行5836-5854)
                         │
                         ├─ MsgQuestion("Confirm to process the track.") (行5837)
                         │      │
                         │      └─ Msg (General.vb:1274)
                         │             │
                         │             └─ TaskDialog.Show (TaskDialog.vb)
                         │
                         └─ [ユーザー選択: DialogResult.OK]
                                │
                                ├─ [p.TempDir = "" の場合]
                                │      └─ p.TempDir = ap.File.Dir
                                │
                                ├─ ap = ObjectHelp.GetCopy(ap)
                                │
                                ├─ Audio.Process(ap) (Audio.vb)
                                │
                                └─ ap.Encode() (AudioProfile.vb)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ユーザー操作 ───▶ コンテキストメニュー ───▶ ExecuteAudio(ap)
(Execute選択)      Execute                     │
                                               ▼
                                    MsgQuestion表示
                                    (Confirm to process...)
                                               │
                                               ▼
                                     ┌─────────┴─────────┐
                                     │                   │
                                     ▼                   ▼
                                OKボタン              Cancelボタン
                                     │                   │
                                     ▼                   ▼
                            TempDir設定            処理終了
                                     │
                                     ▼
                           AudioProfile複製
                                     │
                                     ▼
                           Audio.Process(ap)
                                     │
                                     ▼
                              ap.Encode()
                                     │
                                     ▼
                            [エンコード済み
                             オーディオファイル]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | メインフォーム、ExecuteAudioメソッド実装 |
| AudioProfile.vb | `Source/General/AudioProfile.vb` | ソース | オーディオプロファイルクラス定義 |
| Audio.vb | `Source/General/Audio.vb` | ソース | オーディオ処理ロジック |
| General.vb | `Source/General/General.vb` | ソース | MsgQuestion関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログの実装 |
| Help.vb | `Source/General/Help.vb` | ソース | ObjectHelp.GetCopyメソッド |
