# 通知設計書 108-全トラック処理確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおける全トラック処理確認（Confirm to process ALL audio tracks.）通知の設計仕様を定義する。この通知はMainForm画面で全オーディオトラックを一括処理（エンコード）する際に表示される確認ダイアログである。

### 本通知の処理概要

全トラック処理確認通知は、ユーザーがプロジェクト内のすべてのオーディオトラックを一括でエンコード処理する操作を実行する前の最終確認を行うための通知機能である。複数のオーディオトラックを一度に処理する操作は相当な時間とシステムリソースを要するため、意図しない実行を防止するために確認ダイアログを表示する。

**業務上の目的・背景**：StaxRipでは、映像と音声を別々に処理する機能を提供している。複数のオーディオトラック（主音声、副音声、コメンタリー等）を含むプロジェクトでは、これらを一括で処理する機能が有用である。しかし、全トラック一括処理は個別処理よりも長時間を要し、処理中はシステムリソースを大量に消費する。本通知により、「ALL」であることを明示的に警告し、ユーザーが意図的に一括処理を開始することを確認することを目的としている。

**通知の送信タイミング**：MainForm画面のオーディオトラック領域でコンテキストメニューの「Execute All」を選択した際に表示される。具体的にはExecuteAllAudioメソッド内でMsgQuestion関数が呼び出されるタイミングで発生する。

**通知の受信者**：MainFormを操作しているユーザー本人が受信者となる。ローカルデスクトップアプリケーションであるため、通知は操作中のユーザーに対してのみモーダルダイアログとして表示される。

**通知内容の概要**：「Confirm to process ALL audio tracks.」というメッセージが表示され、全オーディオトラックの処理実行を確認する。メッセージ内の「ALL」は大文字で強調されている。Question（?）アイコンとOK/Cancelボタンが表示される。

**期待されるアクション**：ユーザーは全トラック処理を実行する場合はOKボタンを、操作をキャンセルする場合はCancelボタンをクリックする。OKを選択した場合、p.AudioTracksの各トラックに対してAudio.Processおよびap.Encode()が順次実行される。

## 通知種別

アプリ内通知（モーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

MainFormを操作中のユーザーに対して、モーダルダイアログとして直接表示される。送信先の決定ロジックは不要であり、現在のアクティブウィンドウのオーナーフォームに対してダイアログが表示される。

## 通知テンプレート

### メール通知の場合

該当なし（アプリ内ダイアログ通知のため）

### 本文テンプレート

```
タイトル: Confirm to process ALL audio tracks.
アイコン: Question（?アイコン）
ボタン: OK / Cancel
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本通知では変数を使用しない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | cms.Add("Execute All", ...) | p.AudioTracks.Any(Function(x) x.IsRelevant) | オーディオトラックコンテキストメニューのExecute All選択 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | ExecuteAllAudioメソッドが呼び出されれば常に表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[コンテキストメニュー Execute All] --> B[ExecuteAllAudio呼び出し]
    B --> C[MsgQuestion Confirm to process ALL...]
    C --> D{ユーザー選択}
    D -->|OK| E[For Each track In p.AudioTracks]
    D -->|Cancel| F[処理終了]
    E --> G{track.TextEdit.Text = "" ?}
    G -->|Yes| H[Continue For]
    G -->|No| I{TypeOf NullAudioProfile?}
    H --> E
    I -->|Yes| H
    I -->|No| J{p.TempDir = "" ?}
    J -->|Yes| K[p.TempDir = track.AudioProfile.File.Dir]
    J -->|No| L[ap = ObjectHelp.GetCopy track.AudioProfile]
    K --> L
    L --> M[Audio.Process ap]
    M --> N[ap.Encode]
    N --> O{cleanTemp?}
    O -->|Yes| P[p.TempDir = ""]
    O -->|No| Q[次のトラックへ]
    P --> Q
    Q --> E
    E --> R[処理終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 該当なし | ローカルアプリのためDB参照なし | p.AudioTracksコレクションを操作 |

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| 該当なし | - | ローカルアプリのためDB更新なし |

#### 送信ログテーブル

該当なし（ローカルアプリケーションのため送信ログは記録されない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 通常操作 | ユーザーがCancelを選択 | 何も実行せず終了 |
| 処理エラー | Audio.ProcessまたはEncodeで例外発生 | Try-Catch-Finallyで処理し、cleanTempの場合はp.TempDirをクリア |
| スキップ | track.TextEdit.Textが空 | Continue Forで次のトラックへ |
| スキップ | TypeOf NullAudioProfile | Continue Forで次のトラックへ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時表示）

## セキュリティ考慮事項

本通知は単純な確認ダイアログであり、個人情報や機密情報を含まない。ローカルアプリケーション内でのみ表示されるため、特別なセキュリティ対策は不要。

## 備考

- メニュー項目には「Processes all audio profiles.」という説明文が設定されている
- 「ALL」は大文字で強調され、全トラック一括処理であることを明示している
- NullAudioProfileのトラックはスキップされる
- TextEdit.Textが空のトラック（未設定トラック）はスキップされる
- 各トラックは順次処理され、並列処理ではない
- CHANGELOGには「Add "Execute All" to Audio Tracks」の記載がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、p.AudioTracksコレクションとMsgQuestion関数の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Project.vb | `Source/General/Project.vb` | AudioTracksプロパティの構造 |
| 1-2 | AudioProfile.vb | `Source/General/AudioProfile.vb` | AudioProfileクラス、NullAudioProfileクラス |
| 1-3 | General.vb | `Source/General/General.vb` | MsgQuestion関数の定義（行1261-1266） |

**読解のコツ**: p.AudioTracksはプロジェクト内のすべてのオーディオトラック設定を保持するコレクションである。NullAudioProfileは「処理しない」を表す特殊なプロファイルである。

#### Step 2: エントリーポイントを理解する

処理の起点となるExecuteAllAudioメソッドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | ExecuteAllAudio（行5856-5878） |

**主要処理フロー**:
1. **行5857**: MsgQuestion("Confirm to process ALL audio tracks.")で確認ダイアログを表示
2. **行5858-5876**: For Each track In p.AudioTracksでループ
3. **行5862**: track.TextEdit.Text = ""の場合はContinue For
4. **行5863**: TypeOf NullAudioProfileの場合はContinue For
5. **行5864-5866**: p.TempDirが空の場合はtrack.AudioProfile.File.Dir()を設定
6. **行5869**: ObjectHelp.GetCopy(track.AudioProfile)でコピーを作成
7. **行5870**: Audio.Process(ap)でオーディオ処理を実行
8. **行5871**: ap.Encode()でエンコードを実行
9. **行5874**: FinallyでcleanTempがTrueの場合はp.TempDir = ""

#### Step 3: コンテキストメニューの定義を理解する

オーディオトラックのコンテキストメニュー定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MainForm.vb | `Source/Forms/MainForm.vb` | ShowAudioMenu内のcms.Add（行5827） |

**主要処理フロー**:
- **行5827**: cms.Add("Execute All", Sub() ExecuteAllAudio(), p.AudioTracks.Any(Function(x) x.IsRelevant), "Processes all audio profiles.")

### プログラム呼び出し階層図

```
ShowAudioMenu (MainForm.vb)
    │
    └─ cms.Add("Execute All", Sub() ExecuteAllAudio(), ...) (行5827)
           │
           └─ [ユーザークリック]
                  │
                  └─ ExecuteAllAudio() (行5856-5878)
                         │
                         ├─ MsgQuestion("Confirm to process ALL audio tracks.") (行5857)
                         │      │
                         │      └─ Msg (General.vb:1274)
                         │             │
                         │             └─ TaskDialog.Show (TaskDialog.vb)
                         │
                         └─ [ユーザー選択: DialogResult.OK]
                                │
                                └─ For Each track In p.AudioTracks (行5858)
                                       │
                                       ├─ [track.TextEdit.Text = "" → Continue For]
                                       │
                                       ├─ [TypeOf NullAudioProfile → Continue For]
                                       │
                                       ├─ [p.TempDir = "" の場合]
                                       │      └─ p.TempDir = track.AudioProfile.File.Dir()
                                       │
                                       ├─ ap = ObjectHelp.GetCopy(track.AudioProfile)
                                       │
                                       ├─ Audio.Process(ap) (Audio.vb)
                                       │
                                       └─ ap.Encode() (AudioProfile.vb)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ユーザー操作 ───▶ コンテキストメニュー ───▶ ExecuteAllAudio()
(Execute All)      Execute All                 │
                                               ▼
                                    MsgQuestion表示
                                    (Confirm to process ALL...)
                                               │
                                               ▼
                                     ┌─────────┴─────────┐
                                     │                   │
                                     ▼                   ▼
                                OKボタン              Cancelボタン
                                     │                   │
                                     ▼                   ▼
                         For Each p.AudioTracks     処理終了
                                     │
                    ┌────────────────┼────────────────┐
                    │                │                │
                    ▼                ▼                ▼
              Track 1           Track 2          Track N
                    │                │                │
              ┌─────┴─────┐    ┌─────┴─────┐    ┌─────┴─────┐
              │ スキップ  │    │ スキップ  │    │ スキップ  │
              │ チェック  │    │ チェック  │    │ チェック  │
              └─────┬─────┘    └─────┬─────┘    └─────┬─────┘
                    │                │                │
                    ▼                ▼                ▼
              Audio.Process    Audio.Process    Audio.Process
                    │                │                │
                    ▼                ▼                ▼
              ap.Encode()      ap.Encode()      ap.Encode()
                    │                │                │
                    └────────────────┴────────────────┘
                                     │
                                     ▼
                            [エンコード済み
                             全オーディオファイル]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | メインフォーム、ExecuteAllAudioメソッド実装 |
| Project.vb | `Source/General/Project.vb` | ソース | プロジェクトクラス、AudioTracksプロパティ |
| AudioProfile.vb | `Source/General/AudioProfile.vb` | ソース | オーディオプロファイルクラス、NullAudioProfile |
| Audio.vb | `Source/General/Audio.vb` | ソース | オーディオ処理ロジック |
| General.vb | `Source/General/General.vb` | ソース | MsgQuestion関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログの実装 |
| Help.vb | `Source/General/Help.vb` | ソース | ObjectHelp.GetCopyメソッド |
| CHANGELOG.md | `CHANGELOG.md` | ドキュメント | Execute All機能の追加記録 |
