# 通知設計書 11-抽出失敗通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「抽出失敗通知（Extraction failed with error exit code）」の設計仕様を記述する。

### 本通知の処理概要

この通知は、ツール更新処理においてダウンロードしたアーカイブファイル（7z/zip形式）の抽出処理が失敗した際に、ユーザーに対してエラー情報を表示する機能を提供する。

**業務上の目的・背景**：StaxRipは多数の外部ツール（エンコーダー、フィルターなど）を利用しており、これらのツールの更新機能を提供している。ダウンロードしたアーカイブファイルの抽出が失敗した場合、ユーザーが問題を認識し、適切な対処（再ダウンロード、手動インストールなど）を行えるようにするために本通知が必要である。抽出失敗の原因としては、アーカイブファイルの破損、ディスク容量不足、7-Zipツールの問題などが考えられる。

**通知の送信タイミング**：ToolUpdate.ExtractメソッドでProcess.ExitCodeが0以外の値を返した時点で即座に通知が表示される。具体的には、7-Zipプロセスによるアーカイブ抽出処理が完了し、終了コードが異常（非ゼロ）であった場合にトリガーされる。

**通知の受信者**：StaxRipアプリケーションを操作している現在のユーザー（エンドユーザー）。モーダルダイアログとして表示されるため、ユーザーは必ず通知を確認することになる。

**通知内容の概要**：エラーメッセージとして「Extraction failed with error exit code {終了コード}」という形式で、7-Zipプロセスの終了コードを含むエラー情報が表示される。終了コードにより、ユーザーは問題の種類を特定する手がかりを得ることができる。

**期待されるアクション**：ユーザーはエラーメッセージを確認し、以下のような対処を行うことが期待される。(1) アーカイブファイルを再ダウンロードする、(2) ディスク容量を確認・確保する、(3) 7-Zipツールの状態を確認する、(4) 手動でツールをインストールする。

## 通知種別

アプリ内通知（モーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

現在StaxRipアプリケーションを操作しているユーザーに対して、モーダルダイアログとして直接表示される。ツール更新処理は単一ユーザーのアクションに基づくため、受信者の決定は不要。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| タイトル | Error |
| アイコン | Error |
| ボタン | OK |

### 本文テンプレート

```
Extraction failed with error exit code {ExitCode}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| ExitCode | 7-Zipプロセスの終了コード | Process.ExitCode | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ツール更新実行 | pr.ExitCode <> 0 | 7-Zipによるアーカイブ抽出処理が失敗した場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| pr.ExitCode = 0 | 抽出が正常に完了した場合は通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ToolUpdate.Extract呼び出し] --> B[ダウンロードファイル形式チェック]
    B -->|7z/zip以外| C[処理終了]
    B -->|7z/zip| D[抽出先ディレクトリ設定]
    D --> E[7-Zipプロセス起動]
    E --> F[プロセス完了待機]
    F --> G{終了コードチェック}
    G -->|ExitCode = 0| H[抽出成功処理へ]
    G -->|ExitCode != 0| I[UpdatePackageDialog呼び出し]
    I --> J[MsgError表示]
    J --> K[処理中断]
```

## データベース参照・更新仕様

### 参照テーブル一覧

データベースは使用しない。

### 更新テーブル一覧

データベースは使用しない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 抽出失敗 | 7-Zip終了コードが0以外 | MsgErrorでユーザーに通知し、処理を中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時表示）

## セキュリティ考慮事項

- 終了コードのみを表示し、システムパスなどの機密情報は含まない
- ダウンロードしたファイルのパスは表示されないため、ディレクトリ構造の漏洩リスクは低い

## 備考

- 7-Zipの終了コードの意味については、7-Zipのドキュメントを参照
  - 0: 正常終了
  - 1: 警告
  - 2: 致命的エラー
  - 7: コマンドラインエラー
  - 8: メモリ不足
  - 255: プロセス停止

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ToolUpdateクラスの構造とプロパティを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ToolUpdate.vb | `Source/General/ToolUpdate.vb` | ToolUpdateクラスのプロパティ（Package, DownloadFile, ExtractDir, TargetDir）を理解する |

**読解のコツ**: VB.NETのProperty構文に注目し、クラスが保持する状態を把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるUpdateメソッドとDownloadメソッドを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ToolUpdate.vb | `Source/General/ToolUpdate.vb` | Update()メソッド（行24-45）からDownload()メソッド（行47-66）への呼び出しフロー |

**主要処理フロー**:
1. **行24-45**: HTTPでダウンロードURLから圧縮ファイルのURLを取得
2. **行47-66**: ファイルダウンロードとExtract()の呼び出し

#### Step 3: 抽出処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ToolUpdate.vb | `Source/General/ToolUpdate.vb` | Extract()メソッド（行68-125）の処理フロー、特に行82-86のエラーハンドリング |

**主要処理フロー**:
- **行68-71**: ファイル拡張子チェック（7z/zip以外は処理終了）
- **行73**: 抽出先ディレクトリの設定
- **行75-87**: 7-Zipプロセスの起動と終了コードチェック
- **行82-86**: **通知発生箇所** - ExitCodeが0以外の場合にMsgError呼び出し

### プログラム呼び出し階層図

```
ToolUpdate.Update()
    │
    └─ ToolUpdate.Download()
           │
           └─ DownloadForm.ShowDialog()
                  │
                  └─ ToolUpdate.Extract()
                         │
                         ├─ Process.Start() [7-Zip起動]
                         │
                         ├─ [ExitCode != 0の場合]
                         │      ├─ UpdatePackageDialog()
                         │      └─ MsgError("Extraction failed with error exit code " & pr.ExitCode)
                         │
                         └─ [ExitCode = 0の場合]
                                └─ DeleteOldFiles()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Package.DownloadURL ───▶ HTTPClient.GetStringAsync() ───▶ URLリスト
        │
        ▼
ダウンロードURL ────────▶ DownloadForm ────────────────▶ DownloadFile
        │
        ▼
DownloadFile ──────────▶ 7-Zip Process ────────────────▶ 抽出結果
        │                     │
        │                     └─ [ExitCode != 0] ──────▶ MsgError表示
        │
        ▼
ExtractDir ────────────▶ DeleteOldFiles/CopyFiles ────▶ TargetDir更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ToolUpdate.vb | `Source/General/ToolUpdate.vb` | ソース | ツール更新処理のメインロジック |
| Msg.vb | `Source/UI/Msg.vb` | ソース | MsgError関数の定義（TaskDialogラッパー） |
| Package.vb | `Source/General/Package.vb` | ソース | Packageクラスの定義（ツール情報管理） |
| DownloadForm.vb | `Source/Forms/DownloadForm.vb` | ソース | ダウンロード進捗表示フォーム |
