# 通知設計書 13-更新キャンセル通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「更新キャンセル通知（Update was canceled.）」の設計仕様を記述する。

### 本通知の処理概要

この通知は、ツール更新処理においてユーザーが更新処理をキャンセルした際に、処理の中断をユーザーに通知する機能を提供する。

**業務上の目的・背景**：StaxRipでは外部ツールの更新時に、古いファイルの削除と新しいファイルのコピーの2段階でユーザーに確認を求める。いずれかの段階でユーザーが「キャンセル」を選択した場合、更新処理が中断されたことを明確に通知する必要がある。これにより、ユーザーは更新が完了していないことを認識し、必要に応じて再度更新を試みることができる。

**通知の送信タイミング**：ToolUpdateクラスのDeleteOldFilesメソッドまたはCopyFilesメソッドにおいて、MsgQuestion確認ダイアログで「Cancel」を選択した場合に通知が発生する。具体的には、(1) 古いファイル削除の確認でキャンセルした場合（行152-155）、(2) 新しいファイルコピーの確認でキャンセルした場合（行178-181）の2箇所で発生する。

**通知の受信者**：StaxRipアプリケーションを操作している現在のユーザー（エンドユーザー）。モーダルダイアログとして表示される。

**通知内容の概要**：固定の情報メッセージ「Update was canceled.」が表示される。エラーではなく情報通知として表示され、ユーザーの意図的なキャンセル操作を確認する役割を持つ。

**期待されるアクション**：ユーザーはメッセージを確認し、更新が完了していないことを認識する。必要に応じて再度ツール更新を試みるか、手動でツールを更新する。

## 通知種別

アプリ内通知（モーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中（情報通知） |
| リトライ | 無 |

### 送信先決定ロジック

現在StaxRipアプリケーションを操作しているユーザーに対して、モーダルダイアログとして直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| タイトル | Info |
| アイコン | Info |
| ボタン | OK |

### 本文テンプレート

```
Update was canceled.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 古いファイル削除確認 | MsgQuestionでCancel選択 | 削除確認ダイアログでキャンセル |
| 画面操作 | 新しいファイルコピー確認 | MsgQuestionでCancel選択 | コピー確認ダイアログでキャンセル |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| MsgQuestionでOK選択 | 確認ダイアログでOKを選択した場合は通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[DeleteOldFiles呼び出し] --> B[MsgQuestion: Delete current files?]
    B -->|OK| C[ファイル削除処理]
    B -->|Cancel| D[UpdatePackageDialog呼び出し]
    D --> E[MsgInfo: Update was canceled.]
    E --> F[処理中断]
    C --> G[CopyFiles呼び出し]
    G --> H[MsgQuestion: Copy new files?]
    H -->|OK| I[ファイルコピー処理]
    H -->|Cancel| J[UpdatePackageDialog呼び出し]
    J --> K[MsgInfo: Update was canceled.]
    K --> L[処理中断]
    I --> M[EditVersion処理へ]
```

## データベース参照・更新仕様

### 参照テーブル一覧

データベースは使用しない。

### 更新テーブル一覧

データベースは使用しない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キャンセル | ユーザーが確認ダイアログでキャンセル選択 | MsgInfoでユーザーに通知し、処理を中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし、ユーザーが再度操作する） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時表示）

## セキュリティ考慮事項

- 固定メッセージのみのため、機密情報漏洩のリスクなし
- ユーザーの意図的な操作に対する応答のため、セキュリティ上の問題なし

## 備考

- この通知はエラーではなく情報通知（MsgInfo）として表示される
- 2箇所で同じメッセージが表示される（DeleteOldFilesとCopyFiles）
- キャンセル後、ユーザーは同じツールに対して再度更新を試みることができる
- 抽出したファイルはExtractDirに残っている可能性がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 更新処理のフロー全体を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ToolUpdate.vb | `Source/General/ToolUpdate.vb` | Extract → DeleteOldFiles → CopyFiles → EditVersionの処理フローを把握 |

**読解のコツ**: 各メソッドの最後の行を見ると、次に呼び出されるメソッドがわかる。

#### Step 2: DeleteOldFilesメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ToolUpdate.vb | `Source/General/ToolUpdate.vb` | DeleteOldFilesメソッド（行127-159）、特に行134-156の確認ダイアログとキャンセル処理 |

**主要処理フロー**:
1. **行128-131**: 削除対象ファイルのリストアップ
2. **行134-135**: MsgQuestion確認ダイアログ表示
3. **行137-151**: OK選択時のファイル削除処理
4. **行152-156**: **通知発生箇所1** - Cancel選択時にMsgInfo呼び出し

#### Step 3: CopyFilesメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ToolUpdate.vb | `Source/General/ToolUpdate.vb` | CopyFilesメソッド（行161-186）、特に行167-182の確認ダイアログとキャンセル処理 |

**主要処理フロー**:
1. **行162-165**: コピー対象ファイルのリストアップ
2. **行167-169**: MsgQuestion確認ダイアログ表示
3. **行171-177**: OK選択時のファイルコピー処理
4. **行178-182**: **通知発生箇所2** - Cancel選択時にMsgInfo呼び出し

### プログラム呼び出し階層図

```
ToolUpdate.Extract()
    │
    └─ ToolUpdate.DeleteOldFiles()
           │
           ├─ MsgQuestion("Delete current files?")
           │      │
           │      ├─ [OK] → ファイル削除 → CopyFiles()
           │      │                            │
           │      │                            ├─ MsgQuestion("Copy new files?")
           │      │                            │      │
           │      │                            │      ├─ [OK] → ファイルコピー → EditVersion()
           │      │                            │      │
           │      │                            │      └─ [Cancel]
           │      │                            │             ├─ UpdatePackageDialog()
           │      │                            │             └─ MsgInfo("Update was canceled.")
           │      │                            │
           │      └─ [Cancel]
           │             ├─ UpdatePackageDialog()
           │             └─ MsgInfo("Update was canceled.")
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ExtractDir ─────────────▶ Directory.GetFileSystemEntries()
        │                     │
        │                     ▼
        │              MsgQuestion確認ダイアログ
        │                     │
        │                     ├─ [OK] ──────────────────▶ ファイル操作実行
        │                     │
        │                     └─ [Cancel] ──────────────▶ MsgInfo表示
        │                            │                        │
        ▼                            ▼                        ▼
TargetDir ──────────────▶ UpdatePackageDialog() ────────▶ UI更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ToolUpdate.vb | `Source/General/ToolUpdate.vb` | ソース | ツール更新処理（行154, 180が通知発生箇所） |
| Msg.vb | `Source/UI/Msg.vb` | ソース | MsgInfo, MsgQuestion関数の定義 |
