# 通知設計書 14-更新確認通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「更新確認通知（No update available.）」の設計仕様を記述する。

### 本通知の処理概要

この通知は、StaxRipアプリケーション本体の更新チェック機能において、利用可能な更新がない場合にユーザーに通知する機能を提供する。

**業務上の目的・背景**：StaxRipはGitHubでリリースされており、ユーザーは定期的にまたは手動で更新をチェックできる。更新チェックを実行した際に新しいバージョンが見つからない場合、その結果をユーザーに明確に伝える必要がある。これにより、ユーザーは現在使用しているバージョンが最新であることを確認できる。ただし、この通知はユーザーが明示的に更新チェックを要求した場合（force=True）にのみ表示される。

**通知の送信タイミング**：StaxRipUpdate.CheckForUpdateAsyncメソッドにおいて、GitHubから取得したバージョン情報と現在のバージョンを比較し、新しいバージョンが見つからない場合に通知が発生する。具体的には、(1) latestVersionsリストは存在するが、最新バージョンが現在のバージョン以下またはユーザーがDismiss済みの場合（行132-133）、(2) latestVersionsリストが空の場合（行135-136）の2箇所で発生する。いずれもforce=Trueの場合のみ。

**通知の受信者**：StaxRipアプリケーションを操作している現在のユーザー（エンドユーザー）。モーダルダイアログとして表示される。

**通知内容の概要**：固定の情報メッセージ「No update available.」が表示される。現在のバージョンが最新であることを示す。

**期待されるアクション**：ユーザーはメッセージを確認し、現在のバージョンが最新であることを認識する。追加のアクションは不要。

## 通知種別

アプリ内通知（モーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低（情報通知） |
| リトライ | 無 |

### 送信先決定ロジック

現在StaxRipアプリケーションを操作しているユーザーに対して、モーダルダイアログとして直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| タイトル | Info |
| アイコン | Info |
| ボタン | OK |

### 本文テンプレート

```
No update available.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 更新チェック実行 | force=True かつ latestVersion <= currentVersion | 強制更新チェック時に新バージョンなし |
| 画面操作 | 更新チェック実行 | force=True かつ latestVersions.Count = 0 | 強制更新チェック時にリリース情報なし |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| force=False | 自動更新チェック時は通知しない |
| 新バージョンあり | 新しいバージョンが見つかった場合は通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[CheckForUpdateAsync開始] --> B{force=True または 定期チェック時刻到来?}
    B -->|No| C[処理終了]
    B -->|Yes| D[GitHubからリリース情報取得]
    D --> E[バージョン一覧を解析]
    E --> F{latestVersions.Count > 0?}
    F -->|No| G{force=True?}
    G -->|Yes| H[MsgInfo: No update available.]
    G -->|No| C
    F -->|Yes| I{latestVersion > currentVersion かつ 未Dismiss?}
    I -->|Yes| J[更新ダイアログ表示]
    I -->|No| K{force=True?}
    K -->|Yes| L[MsgInfo: No update available.]
    K -->|No| C
    H --> M[処理終了]
    L --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

データベースは使用しない。ただし、設定ファイル（s: Settings）から以下の値を参照する。

| 設定キー | 用途 | 備考 |
|---------|------|------|
| s.CheckForUpdates | 更新チェック有効/無効 | Boolean |
| s.CheckForUpdatesDismissed | Dismissしたバージョン | String |
| s.CheckForUpdatesLastRequest | 最後のチェック日時 | DateTime |

### 更新テーブル一覧

データベースは使用しない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 通信エラー | GitHub接続失敗 | Try-Catchで黙殺（通知なし） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時表示）

## セキュリティ考慮事項

- GitHub APIへの通信はHTTPSを使用
- 固定メッセージのみのため、機密情報漏洩のリスクなし
- 外部通信が発生するため、ユーザーに事前確認（ShowUpdateQuestion）を行う

## 備考

- この通知はforce=Trueの場合のみ表示される
- 自動更新チェックでは通知されない（ユーザーの作業を妨げないため）
- 更新チェックの頻度は、初回インストールからの経過時間に応じて調整される（1-12時間間隔）
- GitHubのgithub.comとraw.githubusercontent.comに接続する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 更新チェックの全体フローを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StaxRipUpdate.vb | `Source/General/StaxRipUpdate.vb` | CheckForUpdateAsyncメソッド（行41-141）の全体フロー |

**読解のコツ**: Async/Awaitパターンを使用した非同期処理を把握する。

#### Step 2: バージョン比較ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StaxRipUpdate.vb | `Source/General/StaxRipUpdate.vb` | 行62-80でGitHubリリースページを解析してバージョン一覧を取得 |
| 2-2 | StaxRipUpdate.vb | `Source/General/StaxRipUpdate.vb` | 行82-137で最新バージョンとの比較と通知表示 |

**主要処理フロー**:
1. **行59-61**: GitHubのURLを定義
2. **行62-66**: HTTPでリリースページを取得
3. **行67-80**: 正規表現でバージョン番号を抽出
4. **行82-137**: バージョン比較と結果表示
5. **行132-133**: **通知発生箇所1** - 最新バージョンなしの場合
6. **行135-136**: **通知発生箇所2** - リリース情報なしの場合

### プログラム呼び出し階層図

```
StaxRipUpdate.CheckForUpdateAsync(force)
    │
    ├─ [force=False かつ チェック不要] → 終了
    │
    ├─ HttpClient.GetAsync(releaseUrl)
    │      │
    │      └─ Regex.Matches() [バージョン抽出]
    │
    ├─ [latestVersions.Count > 0]
    │      │
    │      ├─ [latestVersion > currentVersion かつ 未Dismiss]
    │      │      └─ TaskDialog表示 [更新ダイアログ]
    │      │
    │      └─ [latestVersion <= currentVersion または Dismiss済]
    │             └─ [force=True]
    │                    └─ MsgInfo("No update available.")
    │
    └─ [latestVersions.Count = 0]
           └─ [force=True]
                  └─ MsgInfo("No update available.")
```

### データフロー図

```
[入力]                         [処理]                         [出力]

force パラメータ ─────────────▶ CheckForUpdateAsync()
        │
        ▼
GitHub releaseUrl ───────────▶ HttpClient.GetAsync()
        │                           │
        │                           ▼
        │                      Regex.Matches()
        │                           │
        ▼                           ▼
currentVersion ─────────────▶ バージョン比較 ──────────────▶ latestVersions
(Assembly.GetEntryAssembly)        │
        │                           │
        │                           ├─ [新バージョンあり] ──▶ TaskDialog表示
        │                           │
        │                           └─ [新バージョンなし かつ force=True]
        │                                  │
        ▼                                  ▼
s.CheckForUpdatesDismissed ────▶ MsgInfo("No update available.")
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StaxRipUpdate.vb | `Source/General/StaxRipUpdate.vb` | ソース | 更新チェック処理（行133, 136が通知発生箇所） |
| Msg.vb | `Source/UI/Msg.vb` | ソース | MsgInfo関数の定義 |
| Settings.vb | `Source/General/Settings.vb` | ソース | CheckForUpdates等の設定保持 |
