# 通知設計書 15-最新バージョン通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「最新バージョン通知（Already Running the Latest Version!）」の設計仕様を記述する。

### 本通知の処理概要

この通知は、UpdateFormを使用したレガシー更新チェック機能において、現在のバージョンが最新であることをユーザーに通知する機能を提供する。

**業務上の目的・背景**：UpdateFormは旧式の更新チェック機能を提供するフォームで、GitHubの特定リリースからダウンロードを行う。ユーザーが更新フォームを開いた際に、既に最新バージョンを使用している場合は、不要なダウンロードを防ぐためにその旨を通知する必要がある。これにより、ユーザーは現在のバージョンが最新であることを確認し、フォームを閉じることができる。

**通知の送信タイミング**：UpdateForm.Updateメソッドにおいて、バージョン比較を行い、現在のバージョンがNextVersion以上の場合に通知が発生する。また、ダウンロードを試みた後のFinally句でも同じ通知が発生する。具体的には、(1) バージョン比較でVersion >= NextVersionの場合（行33）、(2) ダウンロード後のFinally句（行27）の2箇所で発生する。

**通知の受信者**：StaxRipアプリケーションを操作している現在のユーザー（エンドユーザー）。モーダルダイアログとして表示される。

**通知内容の概要**：固定の情報メッセージ「Already Running the Latest Version!」または「Already Running the Latest Version」（感嘆符なし）が表示される。現在のバージョンが最新であることを示す。

**期待されるアクション**：ユーザーはメッセージを確認し、フォームが自動的に閉じられる。追加のアクションは不要。

## 通知種別

アプリ内通知（モーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低（情報通知） |
| リトライ | 無 |

### 送信先決定ロジック

現在StaxRipアプリケーションを操作しているユーザーに対して、モーダルダイアログとして直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| タイトル | Info |
| アイコン | Info |
| ボタン | OK |

### 本文テンプレート

```
Already Running the Latest Version!
```
または
```
Already Running the Latest Version
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | UpdateForm読込 | Version >= NextVersion | 初回チェックで最新版 |
| 画面操作 | ダウンロード後 | Finally句 | ダウンロード処理後（成功・失敗問わず） |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Version < NextVersion かつ ダウンロード進行中 | ダウンロード中は通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[UpdateForm.Load] --> B[Update呼び出し]
    B --> C{Version >= NextVersion?}
    C -->|No| D[ダウンロード開始]
    D --> E[DownloadFileTaskAsync]
    E --> F{成功?}
    F -->|Yes| G[MsgInfo: Download Complete]
    F -->|No| H[WebException発生]
    G --> I[Finally句]
    H --> I
    I --> J[MsgInfo: Already Running the Latest Version!]
    J --> K[ファイル削除]
    K --> L[Close]
    C -->|Yes| M[MsgInfo: Already Running the Latest Version]
    M --> N[Close]
```

## データベース参照・更新仕様

### 参照テーブル一覧

データベースは使用しない。

| 参照元 | 用途 | 備考 |
|--------|------|------|
| My.Application.Info.Version | 現在のバージョン | Major.Minor.Build.Revision |
| NextVersion定数 | 比較対象バージョン | ハードコード（2.0.0.1） |

### 更新テーブル一覧

データベースは使用しない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| WebException | ダウンロード失敗 | Catchで黙殺し、Finally句で通知 |
| Exception | Load時の例外 | MsgInfoで表示してClose |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時表示）

## セキュリティ考慮事項

- 固定メッセージのみのため、機密情報漏洩のリスクなし
- GitHubからのダウンロードはHTTPSを使用
- ダウンロード先はFolder.Startup（アプリケーションディレクトリ）

## 備考

- UpdateFormはレガシー機能であり、現在はStaxRipUpdate.CheckForUpdateAsyncが推奨される
- 通知メッセージに感嘆符の有無で2パターンある（行27は「!」あり、行33は「!」なし）
- Finally句の通知は、ダウンロード成功・失敗にかかわらず表示される（行26-30）
- ダウンロードURLはRevan654フォークのGitHubリリースを参照（ハードコード）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: UpdateFormの構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | UpdateForm.vb | `Source/Forms/UpdateForm.vb` | フォーム全体の構造（行1-44） |

**読解のコツ**: WithEventsでWebClientを定義し、ダウンロード進捗イベントを処理していることを把握する。

#### Step 2: 更新チェックロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UpdateForm.vb | `Source/Forms/UpdateForm.vb` | Update()メソッド（行14-36）のバージョン比較とダウンロードロジック |

**主要処理フロー**:
1. **行15**: NextVersionをハードコード定義
2. **行16**: 現在バージョンを文字列化
3. **行18**: バージョン比較（文字列比較）
4. **行19-30**: ダウンロード処理（Try-Catch-Finally）
5. **行27**: **通知発生箇所1** - Finally句でMsgInfo（感嘆符あり）
6. **行32-34**: **通知発生箇所2** - 最新版の場合MsgInfo（感嘆符なし）

### プログラム呼び出し階層図

```
UpdateForm.Update_Load()
    │
    └─ UpdateForm.Update()
           │
           ├─ [Version < NextVersion]
           │      │
           │      └─ Progress.DownloadFileTaskAsync()
           │             │
           │             ├─ [成功] MsgInfo("Download Complete")
           │             │          │
           │             │          └─ g.OpenDirAndSelectFile()
           │             │
           │             └─ [WebException] Catch
           │
           │      └─ [Finally]
           │             ├─ MsgInfo("Already Running the Latest Version!")
           │             ├─ File.Delete()
           │             └─ Close()
           │
           └─ [Version >= NextVersion]
                  ├─ MsgInfo("Already Running the Latest Version")
                  └─ Close()
```

### データフロー図

```
[入力]                         [処理]                         [出力]

My.Application.Info.Version ──▶ Version文字列化
        │                           │
        ▼                           ▼
NextVersion (定数) ───────────▶ バージョン比較
                                    │
                                    ├─ [Version < NextVersion]
                                    │      │
                                    │      ▼
                                    │   DownloadFileTaskAsync
                                    │      │
                                    │      └─ [Finally] ────────▶ MsgInfo表示
                                    │
                                    └─ [Version >= NextVersion] ─▶ MsgInfo表示
                                                                      │
                                                                      ▼
                                                                   Close()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UpdateForm.vb | `Source/Forms/UpdateForm.vb` | ソース | レガシー更新フォーム（行27, 33が通知発生箇所） |
| UpdateForm.Designer.vb | `Source/Forms/UpdateForm.Designer.vb` | ソース | フォームデザイナー生成コード |
| Msg.vb | `Source/UI/Msg.vb` | ソース | MsgInfo関数の定義 |
| Folder.vb | `Source/General/Folder.vb` | ソース | Folder.Startup定義 |
