# 通知設計書 16-スクリプトエラー通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「スクリプトエラー通知（Script Error）」の設計仕様を記述する。

### 本通知の処理概要

この通知は、AviSynthまたはVapourSynthスクリプトの実行時にエラーが発生した場合に、ユーザーにエラー内容を表示する機能を提供する。

**業務上の目的・背景**：StaxRipはビデオエンコーディングにAviSynthやVapourSynthスクリプトを使用する。スクリプトに構文エラーや実行時エラーがある場合、エンコード処理を継続することは不可能であり、ユーザーにエラー内容を明確に伝えてスクリプトの修正を促す必要がある。この通知は複数の箇所で使用される共通のエラー通知パターンである。

**通知の送信タイミング**：VideoScriptクラスのGetError()メソッドがエラー文字列を返した場合、または Error プロパティが空でない場合に通知が発生する。具体的な発生箇所は以下の通り：
- PreviewForm.Open（行307）: プレビュー表示時
- PreviewForm.Reload（行356）: プレビューリロード時
- MainForm.ShowPreview（行4017）: プレビュー表示時
- MainForm.OpenVideoSourceFiles（行2919）: ソースファイルを開く時
- MainForm_Assistant（行478）: アシスタント表示時
- CropForm.SetDialogResult（行311）: クロップフォームでOK時
- CodeEditor.CreateTempScript（行442）: 一時スクリプト作成時
- GlobalClass.ProcessJob（行528）: ジョブ処理時（ErrorAbortException）
- GlobalClass.SourceValidOrShowError（行1434）: ソース検証時
- GlobalClass.DisplayHDRInfo（行2100, 2124）: HDR情報表示時

**通知の受信者**：StaxRipアプリケーションを操作している現在のユーザー（エンドユーザー）。モーダルダイアログまたはTaskDialogとして表示される。

**通知内容の概要**：タイトルに「Script Error」または「{Engine} Script Error」、本文にスクリプトエラーの詳細内容が表示される。

**期待されるアクション**：ユーザーはエラーメッセージを確認し、スクリプトを修正する。CropFormの場合は「Exit」ボタンでフォームを閉じるか、エラーを修正して再試行できる。

## 通知種別

アプリ内通知（モーダルダイアログ / TaskDialog）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（エラー通知） |
| リトライ | 無 |

### 送信先決定ロジック

現在StaxRipアプリケーションを操作しているユーザーに対して、モーダルダイアログとして直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| タイトル | Script Error |
| アイコン | Error |
| ボタン | OK（通常）、OK/Exit（CropForm） |

### 本文テンプレート

```
{ErrorMessage}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| ErrorMessage | スクリプトエラーの詳細 | script.GetError() または script.Error | Yes |
| Engine | スクリプトエンジン名 | p.Script.Engine | No（一部のみ） |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | プレビュー表示 | PreviewScript.Error <> "" | スクリプトエラーあり |
| 画面操作 | ソースファイルを開く | errorMsg <> "" | ソーススクリプトエラー |
| 画面操作 | クロップフォームOK | err <> "" | クロップスクリプトエラー |
| 画面操作 | コードエディタ検証 | err <> "" | 一時スクリプトエラー |
| バッチ処理 | ジョブ処理 | p.Script.Error <> "" | ジョブスクリプトエラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Error = "" または Nothing | エラーがない場合は通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[スクリプト操作] --> B[script.Synchronize または GetError呼び出し]
    B --> C{script.Error <> ""?}
    C -->|No| D[正常処理継続]
    C -->|Yes| E[MsgError または TaskDialog表示]
    E --> F{CropFormの場合?}
    F -->|Yes| G[OK/Exitボタン表示]
    F -->|No| H[OKボタンのみ]
    G --> I{ユーザー選択}
    I -->|Exit| J[フォームを閉じる]
    I -->|OK| K[処理継続可能]
    H --> L[処理中断]
```

## データベース参照・更新仕様

### 参照テーブル一覧

データベースは使用しない。

### 更新テーブル一覧

データベースは使用しない（ただし、エラーはLogに書き込まれる場合がある）。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| スクリプト構文エラー | スクリプトの文法が不正 | MsgError表示、処理中断 |
| スクリプト実行時エラー | フィルター呼び出し失敗等 | MsgError表示、処理中断 |
| ソースフィルタエラー | ソースファイルを開けない | MsgError表示、処理中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし、ユーザーがスクリプトを修正する） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時表示）

## セキュリティ考慮事項

- スクリプトエラーメッセージにファイルパスが含まれる可能性がある
- エラーメッセージはスクリプトエンジン（AviSynth/VapourSynth）から提供されるため、内容の制御は限定的

## 備考

- 複数の箇所で使用される共通のエラー通知パターン
- CropFormでは「OK」と「Exit」の2つのボタンが表示され、Exitでフォームを閉じることができる
- GlobalClass.ProcessJobではErrorAbortExceptionがスローされ、上位でキャッチされる
- MainForm.OpenVideoSourceFilesではエラー情報がLogに書き込まれる
- s.ErrorMessageTimeoutによりタイムアウト付きで表示される場合がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エラー取得の基本パターンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | VideoScript.vb | `Source/Video/VideoScript.vb` | GetError()メソッドとErrorプロパティの定義 |

**読解のコツ**: VideoScriptクラスがAviSynth/VapourSynthスクリプトを抽象化していることを把握する。

#### Step 2: 代表的な発生箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PreviewForm.vb | `Source/Forms/PreviewForm.vb` | Open()メソッド（行307）、Reload()メソッド（行356） |
| 2-2 | MainForm.vb | `Source/Forms/MainForm.vb` | OpenVideoSourceFiles（行2919）、ShowPreview（行4017） |
| 2-3 | CropForm.vb | `Source/Forms/CropForm.vb` | SetDialogResult（行311）のTaskDialog |

**主要処理フロー（PreviewForm.Open）**:
1. **行304**: PreviewScript.Synchronize(True, True, True)
2. **行306**: PreviewScript.Error <> "" のチェック
3. **行307**: **通知発生箇所** - MsgError("Script Error", PreviewScript.Error)

#### Step 3: TaskDialogパターンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CropForm.vb | `Source/Forms/CropForm.vb` | 行310-323のTaskDialog実装 |

**主要処理フロー（CropForm）**:
- **行307**: p.Script.GetError呼び出し
- **行309-323**: エラーがある場合、TaskDialogでOK/Exitボタンを表示
- **行311**: td.Title = "Script Error"

### プログラム呼び出し階層図

```
[複数の発生箇所]
    │
    ├─ PreviewForm.Open()
    │      └─ PreviewScript.Synchronize()
    │             └─ [Error <> ""] MsgError("Script Error", ...)
    │
    ├─ MainForm.OpenVideoSourceFiles()
    │      └─ errorMsg取得
    │             └─ [errorMsg <> ""]
    │                    ├─ Log.WriteHeader("Error opening source")
    │                    └─ MsgError("Script Error", errorMsg, Handle, timeout)
    │
    ├─ CropForm.SetDialogResult()
    │      └─ p.Script.GetError()
    │             └─ [err <> ""]
    │                    └─ TaskDialog(Title="Script Error")
    │                           ├─ AddButton("OK")
    │                           └─ AddButton("Exit")
    │
    └─ GlobalClass.ProcessJob()
           └─ p.Script.Synchronize()
                  └─ [p.Script.Error <> ""]
                         └─ Throw ErrorAbortException("{Engine} Script Error", ...)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

AviSynth/VapourSynth ──▶ VideoScript.Synchronize()
スクリプト                    │
        │                    ▼
        │              FrameServerFactory.Create()
        │                    │
        │                    ├─ [成功] ──────────────────▶ FrameServer
        │                    │
        │                    └─ [失敗] ──────────────────▶ Error文字列
        │                            │
        ▼                            ▼
script.Error ────────────▶ MsgError("Script Error", Error)
                                    │
                                    ▼
                              処理中断 / Exit選択
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PreviewForm.vb | `Source/Forms/PreviewForm.vb` | ソース | プレビュー表示（行307, 356が通知発生箇所） |
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | メインフォーム（行2919, 4017が通知発生箇所） |
| MainForm_Assistant.vb | `Source/Forms/MainForm_Assistant.vb` | ソース | アシスタント機能（行478が通知発生箇所） |
| CropForm.vb | `Source/Forms/CropForm.vb` | ソース | クロップフォーム（行311が通知発生箇所） |
| CodeEditor.vb | `Source/Forms/CodeEditor.vb` | ソース | コードエディタ（行442が通知発生箇所） |
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | グローバルクラス（行528, 1434, 2100, 2124が通知発生箇所） |
| VideoScript.vb | `Source/Video/VideoScript.vb` | ソース | スクリプト管理クラス |
| Msg.vb | `Source/UI/Msg.vb` | ソース | MsgError関数の定義 |
