# 通知設計書 17-ソースフィルタエラー通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「ソースフィルタエラー通知（The first filter must be a source filter.）」の設計仕様を記述する。

### 本通知の処理概要

この通知は、ビデオスクリプトの編集時に、フィルタチェーンの最初のフィルタがソースフィルタでない場合に、ユーザーにエラーを通知する機能を提供する。

**業務上の目的・背景**：StaxRipのAviSynth/VapourSynthスクリプトでは、フィルタチェーンの最初のフィルタは必ずソースフィルタ（ビデオファイルを読み込むフィルタ）である必要がある。これはスクリプトの基本構造として不可欠であり、ソースフィルタがない場合はスクリプトが動作しない。ユーザーがコードエディタでフィルタを編集した後、最初のフィルタがソースフィルタでない場合は、明確にエラーを通知してデフォルト設定に戻す必要がある。

**通知の送信タイミング**：ProfileVideoScript.Edit()メソッドにおいて、コードエディタのダイアログがOKで閉じられた後、Filters(0).Category <> "Source" の場合に通知が発生する。具体的にはVideoScript.vbの行773-775で発生する。

**通知の受信者**：StaxRipアプリケーションを操作している現在のユーザー（エンドユーザー）。モーダルダイアログとして表示される。

**通知内容の概要**：固定のエラーメッセージ「The first filter must be a source filter.」が表示される。フィルタ構成の要件を明確に伝える。

**期待されるアクション**：ユーザーはエラーメッセージを確認する。通知後、フィルタはデフォルト設定に自動的にリセットされる。ユーザーは再度コードエディタを開いて正しいフィルタ構成を設定する必要がある。

## 通知種別

アプリ内通知（モーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（エラー通知） |
| リトライ | 無 |

### 送信先決定ロジック

現在StaxRipアプリケーションを操作しているユーザーに対して、モーダルダイアログとして直接表示される。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| タイトル | Error |
| アイコン | Error |
| ボタン | OK |

### 本文テンプレート

```
The first filter must be a source filter.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | コードエディタでOK | Filters.Count = 0 Or Filters(0).Category <> "Source" | 最初のフィルタがソースでない |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Filters(0).Category = "Source" | 最初のフィルタがソースフィルタの場合は通知しない |
| DialogResult = Cancel | コードエディタをキャンセルした場合は通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ProfileVideoScript.Edit呼び出し] --> B[CodeEditorダイアログ表示]
    B --> C{DialogResult?}
    C -->|Cancel| D[処理終了 DialogResult.Cancel返却]
    C -->|OK| E[Filters = form.GetFilters]
    E --> F{Filters.Count = 0 または Filters#400;0#41;.Category <> Source?}
    F -->|No| G[DialogResult.OK返却]
    F -->|Yes| H[MsgError表示]
    H --> I[Filters = GetDefaults#400;0#41;.Filters]
    I --> G
```

## データベース参照・更新仕様

### 参照テーブル一覧

データベースは使用しない。

### 更新テーブル一覧

データベースは使用しない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| フィルタ構成エラー | 最初のフィルタがソースでない | MsgError表示、デフォルトフィルタに戻す |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動的にデフォルトに戻す） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時表示）

## セキュリティ考慮事項

- 固定メッセージのみのため、機密情報漏洩のリスクなし

## 備考

- この通知はVideoScript使用時にのみ発生する
- 通知後、フィルタはGetDefaults(0).Filtersで自動的にデフォルトに戻される
- ProfileVideoScriptクラスはVideoScriptを継承しており、プロファイル用のスクリプト設定を管理する
- コードエディタ（CodeEditor）はフィルタの編集UIを提供する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: VideoScriptクラス階層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | VideoScript.vb | `Source/Video/VideoScript.vb` | VideoScript, ProfileVideoScript, TargetVideoScriptの継承関係を理解 |

**読解のコツ**: ProfileVideoScriptがEdit()メソッドをオーバーライドしていることを把握する。

#### Step 2: Edit()メソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | VideoScript.vb | `Source/Video/VideoScript.vb` | ProfileVideoScript.Edit()メソッド（行766-783） |

**主要処理フロー**:
1. **行767**: Using form As New CodeEditor(Me)
2. **行768**: form.StartPosition = FormStartPosition.CenterParent
3. **行770**: If form.ShowDialog() = DialogResult.OK Then
4. **行771**: Filters = form.GetFilters
5. **行773**: **通知発生箇所** - If Filters.Count = 0 OrElse Filters(0).Category <> "Source" Then
6. **行774**: MsgError("The first filter must be a source filter.")
7. **行775**: Filters = GetDefaults(0).Filters

#### Step 3: VideoFilterクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | VideoScript.vb | `Source/Video/VideoScript.vb` | VideoFilterクラス（行841以降）のCategoryプロパティ |

**読解のコツ**: VideoFilterのCategoryが"Source", "Crop", "Resize"などの文字列で分類されることを理解する。

### プログラム呼び出し階層図

```
ProfileVideoScript.Edit()
    │
    ├─ CodeEditor(Me) [ダイアログ生成]
    │      │
    │      └─ ShowDialog()
    │             │
    │             ├─ [Cancel] → Return DialogResult.Cancel
    │             │
    │             └─ [OK]
    │                    │
    │                    └─ form.GetFilters()
    │                           │
    │                           └─ Filters設定
    │                                  │
    │                                  ├─ [Filters(0).Category = "Source"]
    │                                  │      └─ Return DialogResult.OK
    │                                  │
    │                                  └─ [Filters.Count = 0 Or Filters(0).Category <> "Source"]
    │                                         ├─ MsgError("The first filter must be a source filter.")
    │                                         └─ Filters = GetDefaults(0).Filters
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ProfileVideoScript ────▶ CodeEditor表示
(現在のFilters)             │
        │                    ▼
        │              ユーザー編集
        │                    │
        │                    ▼
        │              form.GetFilters()
        │                    │
        ▼                    ▼
Filters ─────────────▶ Category検証
                            │
                            ├─ [Filters(0).Category = "Source"]
                            │      └─ 編集内容を反映 ──▶ DialogResult.OK
                            │
                            └─ [エラー]
                                   ├─ MsgError表示
                                   └─ GetDefaults(0).Filters ──▶ Filtersリセット
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| VideoScript.vb | `Source/Video/VideoScript.vb` | ソース | スクリプト管理（行774が通知発生箇所） |
| CodeEditor.vb | `Source/Forms/CodeEditor.vb` | ソース | フィルタ編集ダイアログ |
| Msg.vb | `Source/UI/Msg.vb` | ソース | MsgError関数の定義 |
